/*
 * Decompiled with CFR 0.152.
 */
package engineering.swat.watch;

import java.nio.file.Path;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class WatchEvent {
    private final Kind kind;
    private final Path rootPath;
    private final Path relativePath;
    private static final Path EMPTY_PATH = Path.of("", new String[0]);

    public WatchEvent(Kind kind, Path rootPath) {
        this(kind, rootPath, null);
    }

    public WatchEvent(Kind kind, Path rootPath, @Nullable Path relativePath) {
        this.kind = kind;
        this.rootPath = rootPath;
        this.relativePath = relativePath == null ? EMPTY_PATH : relativePath;
    }

    public Kind getKind() {
        return this.kind;
    }

    public Path getRelativePath() {
        return this.relativePath;
    }

    public Path getRootPath() {
        return this.rootPath;
    }

    public Path calculateFullPath() {
        return this.rootPath.resolve(this.relativePath);
    }

    public @Nullable Path getFileName() {
        Path fileName = this.relativePath.getFileName();
        if (fileName == null || fileName.equals(EMPTY_PATH)) {
            fileName = this.rootPath.getFileName();
        }
        return fileName;
    }

    public String toString() {
        return String.format("WatchEvent[%s, %s, %s]", new Object[]{this.rootPath, this.kind, this.relativePath});
    }

    public static boolean areEquivalent(WatchEvent e1, WatchEvent e2) {
        return Objects.equals((Object)e1.getKind(), (Object)e2.getKind()) && Objects.equals(e1.getRootPath(), e2.getRootPath()) && Objects.equals(e1.getRelativePath(), e2.getRelativePath());
    }

    public static enum Kind {
        CREATED,
        MODIFIED,
        DELETED,
        OVERFLOW;

    }
}

