/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.type.DefaultSubtypeOfValue;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import io.usethesource.vallang.type.ValueType;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ParameterType
extends DefaultSubtypeOfValue {
    private final String fName;
    private final Type fBound;

    ParameterType(String name, Type bound) {
        this.fName = name.intern();
        this.fBound = bound;
    }

    ParameterType(String name) {
        this.fName = name.intern();
        this.fBound = TypeFactory.getInstance().valueType();
    }

    @Override
    public TypeFactory.TypeReifier getTypeReifier(TypeFactory.TypeValues symbols) {
        return new Info(symbols);
    }

    @Override
    public Type getTypeParameters() {
        return this.getBound().getTypeParameters();
    }

    @Override
    public Type getBound() {
        return this.fBound;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public int getArity() {
        return this.fBound.getArity();
    }

    @Override
    public Type getFieldType(int i) {
        return this.fBound.getFieldType(i);
    }

    @Override
    public String[] getFieldNames() {
        return this.fBound.getFieldNames();
    }

    @Override
    public String toString() {
        return this.fBound.equivalent(ValueType.getInstance()) ? "&" + this.fName : "&" + this.fName + "<:" + this.fBound.toString();
    }

    @Override
    public int hashCode() {
        return 49991 + 49831 * this.fName.hashCode() + 133020331 * this.fBound.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ParameterType) {
            ParameterType other = (ParameterType)o;
            return this.fName.equals(other.fName) && this.fBound == other.fBound;
        }
        return false;
    }

    @Override
    public <T, E extends Throwable> T accept(ITypeVisitor<T, E> visitor) throws E {
        return visitor.visitParameter(this);
    }

    @Override
    public boolean intersects(Type other) {
        if (other == this) {
            return true;
        }
        return this.getBound().intersects(other);
    }

    @Override
    protected boolean intersectsWithExternal(Type type) {
        return this.getBound().intersects(type);
    }

    @Override
    protected boolean isSupertypeOf(Type type) {
        if (type == this) {
            return true;
        }
        if (this.getBound().isTop()) {
            return true;
        }
        return this.getBound().isSupertypeOf(type);
    }

    @Override
    protected boolean isSubtypeOfAbstractData(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    private boolean couldBeSubtypeOf(Type type) {
        return this.getBound().comparable(type);
    }

    @Override
    protected boolean isSubtypeOfBool(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    @Override
    protected boolean isSubtypeOfConstructor(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    @Override
    protected boolean isSubtypeOfDateTime(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    @Override
    protected boolean isSubtypeOfExternal(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    @Override
    protected boolean isSubtypeOfInteger(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    @Override
    protected boolean isSubtypeOfList(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    @Override
    protected boolean isSubtypeOfMap(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    @Override
    protected boolean isSubtypeOfNode(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    @Override
    protected boolean isSubtypeOfNumber(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    @Override
    protected boolean isSubtypeOfParameter(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    @Override
    protected boolean isSubtypeOfRational(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    @Override
    protected boolean isSubtypeOfReal(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    @Override
    protected boolean isSubtypeOfSet(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    @Override
    protected boolean isSubtypeOfSourceLocation(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    @Override
    protected boolean isSubtypeOfString(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    @Override
    protected boolean isSubtypeOfTuple(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    @Override
    protected boolean isSubtypeOfValue(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    @Override
    protected boolean isSubtypeOfVoid(Type type) {
        return this.couldBeSubtypeOf(type);
    }

    @Override
    protected boolean intersectsWithValue(Type type) {
        return true;
    }

    @Override
    protected boolean intersectsWithReal(Type type) {
        return this.getBound().intersects(type);
    }

    @Override
    protected boolean intersectsWithInteger(Type type) {
        return this.getBound().intersects(type);
    }

    @Override
    protected boolean intersectsWithRational(Type type) {
        return this.getBound().intersects(type);
    }

    @Override
    protected boolean intersectsWithList(Type type) {
        return this.getBound().intersects(type);
    }

    @Override
    protected boolean intersectsWithMap(Type type) {
        return this.getBound().intersects(type);
    }

    @Override
    protected boolean intersectsWithNumber(Type type) {
        return this.getBound().intersects(type);
    }

    @Override
    protected boolean intersectsWithRelation(Type type) {
        return this.getBound().intersects(type);
    }

    @Override
    protected boolean intersectsWithSet(Type type) {
        return this.getBound().intersects(type);
    }

    @Override
    protected boolean intersectsWithSourceLocation(Type type) {
        return this.getBound().intersects(type);
    }

    @Override
    protected boolean intersectsWithString(Type type) {
        return this.getBound().intersects(type);
    }

    @Override
    protected boolean intersectsWithNode(Type type) {
        return this.getBound().intersects(type);
    }

    @Override
    protected boolean intersectsWithConstructor(Type type) {
        return this.getBound().intersects(type);
    }

    @Override
    protected boolean intersectsWithAbstractData(Type type) {
        return this.getBound().intersects(type);
    }

    @Override
    protected boolean intersectsWithTuple(Type type) {
        return this.getBound().intersects(type);
    }

    @Override
    protected boolean intersectsWithFunction(Type type) {
        return this.getBound().intersects(type);
    }

    @Override
    protected boolean intersectsWithVoid(Type type) {
        return false;
    }

    @Override
    protected boolean intersectsWithBool(Type type) {
        return this.getBound().intersects(type);
    }

    @Override
    protected boolean intersectsWithDateTime(Type type) {
        return this.getBound().intersects(type);
    }

    @Override
    public Type lub(Type type) {
        if (type == this) {
            return this;
        }
        if (type.isSubtypeOf(this.getBound())) {
            return this;
        }
        return this.getBound().lub(type);
    }

    @Override
    public Type glb(Type type) {
        if (type == this) {
            return this;
        }
        if (type.isSupertypeOf(this.getBound())) {
            return this;
        }
        return this.getBound().glb(type);
    }

    @Override
    public boolean match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        if (!super.match(matched, bindings)) {
            return false;
        }
        Type earlier = bindings.get(this);
        if (earlier != null) {
            Type lub = earlier;
            HashMap<Type, Type> newBindings = new HashMap<Type, Type>(bindings);
            if (matched.isOpen() && !matched.isParameter() && matched.match(earlier, newBindings)) {
                if (newBindings.size() > bindings.size()) {
                    bindings.put(this, matched.instantiate(newBindings));
                    bindings.putAll(newBindings);
                }
                return true;
            }
            lub = matched.lub(earlier);
            if (lub.isSubtypeOf(this.getBound())) {
                bindings.put(this, lub);
                this.getBound().match(matched, bindings);
                return true;
            }
            return false;
        }
        bindings.put(this, matched);
        this.getBound().match(matched, bindings);
        return true;
    }

    @Override
    public Type instantiate(Map<Type, Type> bindings) {
        Type result = bindings.get(this);
        if (result != null && result != this) {
            try {
                return result.instantiate(bindings);
            }
            catch (StackOverflowError e) {
                assert (false) : "type bindings are not hygenic: cyclic parameter binding leads to infinite recursion";
                return result;
            }
        }
        return TypeFactory.getInstance().parameterType(this.fName, this.getBound().instantiate(bindings));
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isParameter() {
        return true;
    }

    @Override
    public IValue randomValue(Random random, TypeFactory.RandomTypesConfig typesConfig, IValueFactory vf, TypeStore store, Map<Type, Type> typeParameters, int maxDepth, int maxWidth) {
        IValue val = this.getBound().randomValue(random, typesConfig, vf, store, typeParameters, maxDepth, maxWidth);
        this.inferBinding(typeParameters, val);
        return val;
    }

    private void inferBinding(Map<Type, Type> typeParameters, IValue val) {
        Type tv = typeParameters.get(this);
        tv = tv != null ? tv.lub(val.getType()) : val.getType();
        typeParameters.put(this, tv);
    }

    public static class Info
    extends TypeFactory.TypeReifier {
        public Info(TypeFactory.TypeValues symbols) {
            super(symbols);
        }

        @Override
        public Type getSymbolConstructorType() {
            return this.symbols().typeSymbolConstructor("parameter", this.tf().stringType(), "name", this.symbols().symbolADT(), "bound");
        }

        @Override
        public Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            return this.tf().parameterType(((IString)symbol.get("name")).getValue(), this.symbols().fromSymbol((IConstructor)symbol.get("bound"), store, grammar));
        }

        @Override
        public Type randomInstance(BiFunction<TypeStore, TypeFactory.RandomTypesConfig, Type> next, TypeStore store, TypeFactory.RandomTypesConfig rnd) {
            if (rnd.isWithTypeParameters()) {
                return this.tf().parameterType(this.randomLabel(rnd));
            }
            return next.apply(store, rnd);
        }

        @Override
        public IConstructor toSymbol(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            return vf.constructor(this.getSymbolConstructorType(), vf.string(type.getName()), type.getBound().asSymbol(vf, store, grammar, done));
        }

        @Override
        public void asProductions(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            type.getBound().asProductions(vf, store, grammar, done);
        }
    }
}

