/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.exceptions.TypeParseError;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TypeReader {
    private static final char TYPE_PARAMETER_TOKEN = '&';
    private static final char START_OF_ARGUMENTS = '[';
    private static final char END_OF_ARGUMENTS = ']';
    private static final char COMMA_SEPARATOR = ',';
    private static final TypeFactory types = TypeFactory.getInstance();
    private int current;

    public Type read(TypeStore store, Reader reader) throws IOException {
        try (NoWhiteSpaceReader stream = new NoWhiteSpaceReader(reader);){
            this.current = stream.read();
            Type result = this.readType(store, stream);
            if (this.current != -1 || stream.read() != -1) {
                this.unexpected(stream);
            }
            Type type = result;
            return type;
        }
    }

    private Type readType(TypeStore store, NoWhiteSpaceReader stream) throws IOException {
        if (this.current == 38) {
            this.checkAndRead(stream, '&');
            return this.readTypeParameter(store, stream);
        }
        if (Character.isJavaIdentifierStart(this.current)) {
            Type adt;
            String id;
            switch (id = this.readIdentifier(store, stream)) {
                case "int": {
                    return types.integerType();
                }
                case "real": {
                    return types.realType();
                }
                case "rat": {
                    return types.rationalType();
                }
                case "num": {
                    return types.numberType();
                }
                case "bool": {
                    return types.boolType();
                }
                case "node": {
                    return types.nodeType();
                }
                case "void": {
                    return types.voidType();
                }
                case "value": {
                    return types.valueType();
                }
                case "loc": {
                    return types.sourceLocationType();
                }
                case "str": {
                    return types.stringType();
                }
                case "datetime": {
                    return types.dateTimeType();
                }
            }
            if (this.current == 91) {
                switch (id) {
                    case "list": {
                        return this.readComposite(store, stream, (List<Type> t2) -> types.listType((Type)t2.get(0)));
                    }
                    case "set": {
                        return this.readComposite(store, stream, (List<Type> t2) -> types.setType((Type)t2.get(0)));
                    }
                    case "map": {
                        return this.readComposite(store, stream, (List<Type> t2, List<String> l) -> l.isEmpty() ? types.mapType((Type)t2.get(0), (Type)t2.get(1)) : types.mapType((Type)t2.get(0), (String)l.get(0), (Type)t2.get(1), (String)l.get(1)));
                    }
                    case "tuple": {
                        return this.readComposite(store, stream, (List<Type> t2, List<String> l) -> l.isEmpty() ? types.tupleType(t2.toArray(new Type[0])) : types.tupleType(TypeReader.interleave(t2, l)));
                    }
                    case "rel": {
                        return this.readComposite(store, stream, (List<Type> t2, List<String> l) -> l.isEmpty() ? types.relType(t2.toArray(new Type[0])) : types.relType(TypeReader.interleave(t2, l)));
                    }
                    case "lrel": {
                        return this.readComposite(store, stream, (List<Type> t2, List<String> l) -> l.isEmpty() ? types.lrelType(t2.toArray(new Type[0])) : types.lrelType(TypeReader.interleave(t2, l)));
                    }
                }
                adt = store.lookupAbstractDataType(id);
                if (adt != null) {
                    return this.readComposite(store, stream, (List<Type> t2) -> types.abstractDataType(store, id, t2.toArray(new Type[0])));
                }
                throw new TypeParseError("undeclared type " + id, new IllegalArgumentException());
            }
            adt = store.lookupAbstractDataType(id);
            if (adt != null) {
                return adt;
            }
            throw new TypeParseError("undeclared type " + id, new IllegalArgumentException());
        }
        throw new TypeParseError("Unexpected " + (char)this.current, stream.getOffset());
    }

    private static Object[] interleave(List<Type> t2, List<String> l) {
        assert (t2.size() == l.size());
        Object[] result = new Object[t2.size() + l.size()];
        for (int i = 0; i < t2.size(); ++i) {
            result[i * 2] = t2.get(i);
            result[i * 2 + 1] = l.get(i);
        }
        return result;
    }

    private Type readTypeParameter(TypeStore store, NoWhiteSpaceReader stream) throws IOException {
        String name = this.readIdentifier(store, stream);
        if (this.current == 60) {
            this.checkAndRead(stream, '<');
            this.checkAndRead(stream, ':');
            return types.parameterType(name, this.readType(store, stream));
        }
        return types.parameterType(name);
    }

    private Type readComposite(TypeStore store, NoWhiteSpaceReader stream, Function<List<Type>, Type> wrap) throws IOException {
        ArrayList<Type> arr = new ArrayList<Type>();
        this.readFixed(store, stream, ']', arr, null);
        return wrap.apply(arr);
    }

    private Type readComposite(TypeStore store, NoWhiteSpaceReader stream, BiFunction<List<Type>, List<String>, Type> wrap) throws IOException {
        ArrayList<Type> arr = new ArrayList<Type>();
        ArrayList<String> labels = new ArrayList<String>();
        this.readFixed(store, stream, ']', arr, labels);
        return wrap.apply(arr, labels);
    }

    private String readIdentifier(TypeStore store, NoWhiteSpaceReader stream) throws IOException {
        boolean escaped;
        if (Character.isWhitespace(this.current)) {
            this.current = stream.read();
        }
        StringBuilder builder = new StringBuilder();
        boolean bl = escaped = this.current == 92;
        if (escaped) {
            this.current = stream.readRaw();
        }
        while (Character.isJavaIdentifierStart(this.current) || Character.isJavaIdentifierPart(this.current) || escaped && this.current == 45) {
            builder.append((char)this.current);
            this.current = stream.readRaw();
        }
        if (Character.isWhitespace(this.current)) {
            this.current = stream.read();
        }
        return builder.toString();
    }

    private void readFixed(TypeStore store, NoWhiteSpaceReader stream, char end, List<Type> arr, @Nullable List<String> labels) throws IOException {
        this.current = stream.read();
        while (this.current != end) {
            arr.add(this.readType(store, stream));
            if (this.current == end) break;
            if (labels != null && Character.isJavaIdentifierStart(this.current)) {
                labels.add(this.readIdentifier(store, stream));
            }
            if (this.current == end) break;
            this.checkAndRead(stream, ',');
        }
        this.checkAndRead(stream, end);
    }

    private void checkAndRead(NoWhiteSpaceReader stream, char c) throws IOException {
        if (this.current != c) {
            this.unexpected(stream, c);
        }
        this.current = stream.read();
    }

    private void unexpected(NoWhiteSpaceReader stream, int c) {
        throw new TypeParseError("Expected " + (char)c + " but got " + (char)this.current, stream.getOffset());
    }

    private void unexpected(NoWhiteSpaceReader stream) {
        throw new TypeParseError("Unexpected " + (char)this.current, stream.getOffset());
    }

    private static class NoWhiteSpaceReader
    extends Reader {
        private Reader wrapped;
        int offset;
        boolean inString = false;
        boolean escaping = false;

        public NoWhiteSpaceReader(Reader wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            throw new UnsupportedOperationException();
        }

        public int readRaw() throws IOException {
            int r = this.wrapped.read();
            ++this.offset;
            return r;
        }

        @Override
        public int read() throws IOException {
            int r = this.wrapped.read();
            ++this.offset;
            if (!this.inString) {
                while (Character.isWhitespace(r)) {
                    ++this.offset;
                    r = this.wrapped.read();
                }
            }
            if (!this.inString && r == 34) {
                this.inString = true;
            } else if (this.inString) {
                if (this.escaping) {
                    this.escaping = false;
                } else if (r == 92) {
                    this.escaping = true;
                } else if (r == 34) {
                    this.inString = false;
                }
            }
            return r;
        }

        int getOffset() {
            return this.offset;
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
        }
    }
}

