/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ast;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.IASTVisitor;
import org.rascalmpl.ast.Tag;

public abstract class Tags
extends AbstractAST {
    public Tags(ISourceLocation src, IConstructor node) {
        super(src);
    }

    public boolean hasTags() {
        return false;
    }

    public List<Tag> getTags() {
        throw new UnsupportedOperationException(this.src.toString());
    }

    public boolean isDefault() {
        return false;
    }

    public static class Default
    extends Tags {
        private final List<Tag> tags;

        public Default(ISourceLocation src, IConstructor node, List<Tag> tags) {
            super(src, node);
            this.tags = tags;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public <T> T accept(IASTVisitor<T> visitor) {
            return visitor.visitTagsDefault(this);
        }

        @Override
        protected void addForLineNumber(int $line, List<AbstractAST> $result) {
            if (this.getLocation().getBeginLine() == $line) {
                $result.add(this);
            }
            for (AbstractAST abstractAST : this.tags) {
                ISourceLocation $l = abstractAST.getLocation();
                if ($l.hasLineColumn() && $l.getBeginLine() <= $line && $l.getEndLine() >= $line) {
                    abstractAST.addForLineNumber($line, $result);
                }
                if ($l.getBeginLine() <= $line) continue;
                return;
            }
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Default)) {
                return false;
            }
            Default tmp = (Default)o;
            return tmp.tags.equals(this.tags);
        }

        @Override
        public int hashCode() {
            return 487 + 797 * this.tags.hashCode();
        }

        @Override
        public List<Tag> getTags() {
            return this.tags;
        }

        @Override
        public boolean hasTags() {
            return true;
        }

        @Override
        public Object clone() {
            return Default.newInstance(this.getClass(), this.src, null, this.clone(this.tags));
        }
    }
}

