/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.debug;

import io.usethesource.vallang.ISourceLocation;
import org.rascalmpl.debug.IDebugMessage;

public class DebugMessageFactory {
    public static IDebugMessage requestSuspension() {
        return new DebugMessage(IDebugMessage.Action.SUSPEND, IDebugMessage.Subject.INTERPRETER, IDebugMessage.Detail.CLIENT_REQUEST);
    }

    public static IDebugMessage requestResumption() {
        return new DebugMessage(IDebugMessage.Action.RESUME, IDebugMessage.Subject.INTERPRETER, IDebugMessage.Detail.CLIENT_REQUEST);
    }

    public static IDebugMessage requestStepInto() {
        return new DebugMessage(IDebugMessage.Action.RESUME, IDebugMessage.Subject.INTERPRETER, IDebugMessage.Detail.STEP_INTO);
    }

    public static IDebugMessage requestStepOver() {
        return new DebugMessage(IDebugMessage.Action.RESUME, IDebugMessage.Subject.INTERPRETER, IDebugMessage.Detail.STEP_OVER);
    }

    public static IDebugMessage requestStepOut() {
        return new DebugMessage(IDebugMessage.Action.RESUME, IDebugMessage.Subject.INTERPRETER, IDebugMessage.Detail.STEP_OUT);
    }

    public static IDebugMessage requestTermination() {
        return new DebugMessage(IDebugMessage.Action.TERMINATE, IDebugMessage.Subject.INTERPRETER, IDebugMessage.Detail.UNKNOWN);
    }

    public static IDebugMessage requestSetBreakpoint(ISourceLocation location) {
        return new DebugMessage(IDebugMessage.Action.SET, IDebugMessage.Subject.BREAKPOINT, IDebugMessage.Detail.UNKNOWN, location);
    }

    public static IDebugMessage requestDeleteBreakpoint(ISourceLocation location) {
        return new DebugMessage(IDebugMessage.Action.DELETE, IDebugMessage.Subject.BREAKPOINT, IDebugMessage.Detail.UNKNOWN, location);
    }

    private static class DebugMessage
    implements IDebugMessage {
        private final IDebugMessage.Action action;
        private final IDebugMessage.Subject subject;
        private final IDebugMessage.Detail detail;
        private final Object payload;

        public DebugMessage(IDebugMessage.Action action, IDebugMessage.Subject subject, IDebugMessage.Detail detail) {
            this(action, subject, detail, null);
        }

        public DebugMessage(IDebugMessage.Action action, IDebugMessage.Subject subject, IDebugMessage.Detail detail, Object payload) {
            this.action = action;
            this.subject = subject;
            this.detail = detail;
            this.payload = payload;
        }

        @Override
        public IDebugMessage.Action getAction() {
            return this.action;
        }

        @Override
        public IDebugMessage.Subject getSubject() {
            return this.subject;
        }

        @Override
        public IDebugMessage.Detail getDetail() {
            return this.detail;
        }

        @Override
        public Object getPayload() {
            return this.payload;
        }
    }
}

