/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.ideservices;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import java.io.PrintWriter;
import java.net.URI;
import org.jline.terminal.Terminal;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.library.Messages;
import org.rascalmpl.uri.LogicalMapResolver;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.values.IRascalValueFactory;

public interface IDEServices
extends IRascalMonitor {
    public PrintWriter stderr();

    public void browse(URI var1, String var2, int var3);

    public void edit(ISourceLocation var1, int var2);

    default public void edit(ISourceLocation path) {
        this.edit(path, -1);
    }

    default public ISourceLocation resolveProjectLocation(ISourceLocation input) {
        return input;
    }

    default public void registerLanguage(IConstructor language) {
        throw new UnsupportedOperationException("registerLanguage is not implemented in this environment.");
    }

    default public void unregisterLanguage(IConstructor language) {
        throw new UnsupportedOperationException("registerLanguage is not implemented in this environment.");
    }

    default public Terminal activeTerminal() {
        return null;
    }

    @Deprecated(forRemoval=true)
    default public void applyDocumentsEdits(IList edits) {
        this.applyFileSystemEdits(edits);
    }

    default public void applyFileSystemEdits(IList edits) {
        throw new UnsupportedOperationException("applyFileSystemEdits is not implemented in this environment.");
    }

    default public void showMessage(IConstructor message) {
        this.logMessage(message);
    }

    default public void logMessage(IConstructor msg) {
        Messages.write(IRascalValueFactory.getInstance().list(msg), this.stderr());
    }

    default public void registerDiagnostics(IList messages) {
        Messages.write(messages, this.stderr());
    }

    default public void registerDiagnostics(IList messages, ISourceLocation projectRoot) {
        this.registerDiagnostics(messages);
    }

    default public void unregisterDiagnostics(IList resources) {
    }

    default public void registerLocations(IString scheme, IString auth, IMap map) {
        URIResolverRegistry.getInstance().registerLogical(new LogicalMapResolver(scheme.getValue(), auth.getValue(), map));
    }

    default public void unregisterLocations(IString scheme, IString auth) {
        URIResolverRegistry.getInstance().unregisterLogical(scheme.getValue(), auth.getValue());
    }

    default public void startDebuggingSession(int serverPort) {
    }

    default public void registerDebugServerPort(int processID, int serverPort) {
    }
}

