/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.result;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IExternalValue;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWithKeywordParameters;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.exceptions.IllegalOperationException;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.util.Map;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.control_exceptions.Failure;
import org.rascalmpl.interpreter.control_exceptions.MatchFailed;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.result.ICallableValue;
import org.rascalmpl.interpreter.result.OverloadedFunction;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.values.RascalValueFactory;

public class ComposedFunctionResult
extends Result<IValue>
implements IExternalValue,
ICallableValue {
    private static final TypeFactory TF = TypeFactory.getInstance();
    private final ICallableValue left;
    private final ICallableValue right;
    private final boolean isStatic;
    private Type type;

    public <T extends Result<IValue> & ICallableValue, U extends Result<IValue> & ICallableValue> ComposedFunctionResult(T left, U right, Type type, IEvaluatorContext ctx) {
        super(type, null, ctx);
        this.left = left;
        this.right = right;
        this.type = type;
        this.isStatic = ((ICallableValue)left).isStatic() && ((ICallableValue)right).isStatic();
    }

    public <T extends Result<IValue> & ICallableValue, U extends Result<IValue> & ICallableValue> ComposedFunctionResult(T left, U right, IEvaluatorContext ctx) {
        super(TF.voidType(), null, ctx);
        this.left = left;
        this.right = right;
        this.type = ((Result)this).type;
        try {
            this.type = left.getStaticType().compose(right.getStaticType());
        }
        catch (IllegalOperationException illegalOperationException) {
            // empty catch block
        }
        this.isStatic = ((ICallableValue)left).isStatic() && ((ICallableValue)right).isStatic();
    }

    private ComposedFunctionResult(ICallableValue left, ICallableValue right, Type type, IEvaluatorContext ctx) {
        super(type, null, ctx);
        this.left = left;
        this.right = right;
        this.type = type;
        this.isStatic = left.isStatic() && right.isStatic();
    }

    @Override
    public ComposedFunctionResult cloneInto(Environment env) {
        return new ComposedFunctionResult(this.left.cloneInto(env), this.right.cloneInto(env), this.type, this.ctx);
    }

    public boolean isNonDeterministic() {
        return false;
    }

    @Override
    public int getArity() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean hasVarArgs() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public Type getStaticType() {
        return this.type;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public Result<IValue> getLeft() {
        return (Result)((Object)this.left);
    }

    public Result<IValue> getRight() {
        return (Result)((Object)this.right);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<IValue> call(IRascalMonitor monitor, Type[] argTypes, IValue[] argValues, Map<String, IValue> keyArgValues) {
        IRascalMonitor old = this.ctx.getEvaluator().setMonitor(monitor);
        try {
            Result<IValue> result = this.call(argTypes, argValues, keyArgValues);
            return result;
        }
        finally {
            this.ctx.getEvaluator().setMonitor(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IValue> T call(Map<String, IValue> keywordParameters, IValue ... parameters) {
        IEvaluator<Result<IValue>> iEvaluator = this.ctx.getEvaluator();
        synchronized (iEvaluator) {
            return ICallableValue.super.call(keywordParameters, parameters);
        }
    }

    @Override
    public Result<IValue> call(Type[] argTypes, IValue[] argValues, Map<String, IValue> keyArgValues) {
        Result<IValue> rightResult = this.right.call(argTypes, argValues, null);
        return this.left.call(new Type[]{rightResult.getStaticType()}, new IValue[]{rightResult.getValue()}, keyArgValues);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> add(Result<V> right) {
        return right.addFunctionNonDeterministic(this);
    }

    public ComposedFunctionResult addFunctionNonDeterministic(AbstractFunction that) {
        return new NonDeterministic(that, this, this.ctx);
    }

    public ComposedFunctionResult addFunctionNonDeterministic(OverloadedFunction that) {
        return new NonDeterministic(that, this, this.ctx);
    }

    public ComposedFunctionResult addFunctionNonDeterministic(ComposedFunctionResult that) {
        return new NonDeterministic(that, this, this.ctx);
    }

    @Override
    public <U extends IValue, V extends IValue> Result<U> compose(Result<V> right) {
        return right.composeFunction(this);
    }

    public ComposedFunctionResult composeFunction(AbstractFunction that) {
        return new ComposedFunctionResult(that, this, this.ctx);
    }

    public ComposedFunctionResult composeFunction(OverloadedFunction that) {
        return new ComposedFunctionResult(that, this, this.ctx);
    }

    public ComposedFunctionResult composeFunction(ComposedFunctionResult that) {
        return new ComposedFunctionResult(that, this, this.ctx);
    }

    @Override
    public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
        return v.visitExternal(this);
    }

    public boolean isEqual(IValue other) {
        return other == this;
    }

    @Override
    public boolean match(IValue other) throws FactTypeUseException {
        return other == this;
    }

    @Override
    public IValue getValue() {
        return this;
    }

    @Override
    public String toString() {
        return this.left.toString() + " 'o' " + this.right.toString();
    }

    @Override
    public IEvaluator<Result<IValue>> getEval() {
        return (Evaluator)this.ctx;
    }

    @Override
    public boolean hasKeywordArguments() {
        return this.right.hasKeywordArguments();
    }

    @Override
    public boolean mayHaveKeywordParameters() {
        return false;
    }

    @Override
    public IWithKeywordParameters<? extends IValue> asWithKeywordParameters() {
        throw new IllegalOperationException("Cannot be viewed as with keyword parameters", this.getStaticType());
    }

    @Override
    public IConstructor encodeAsConstructor() {
        return this.getValueFactory().constructor(RascalValueFactory.Function_Composition, this.left.encodeAsConstructor(), this.right.encodeAsConstructor());
    }

    public static class NonDeterministic
    extends ComposedFunctionResult {
        private static final TypeFactory TF = TypeFactory.getInstance();

        public <T extends Result<IValue> & ICallableValue, U extends Result<IValue> & ICallableValue> NonDeterministic(T left, U right, IEvaluatorContext ctx) {
            super(left, right, TF.voidType().lub(left.getStaticType()).lub(right.getStaticType()), ctx);
        }

        @Override
        public boolean isNonDeterministic() {
            return true;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Result<IValue> call(Type[] argTypes, IValue[] argValues, Map<String, IValue> keyArgValues) {
            try {
                return this.getRight().call(argTypes, argValues, keyArgValues);
            }
            catch (MatchFailed matchFailed) {
                try {
                    return this.getLeft().call(argTypes, argValues, keyArgValues);
                    catch (Failure failure) {
                        // empty catch block
                    }
                    return this.getLeft().call(argTypes, argValues, keyArgValues);
                }
                catch (Failure f2) {
                    throw new MatchFailed();
                }
            }
        }

        @Override
        public String toString() {
            return this.getLeft().toString() + " '+' " + this.getRight().toString();
        }
    }
}

