/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.lang.xml;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import org.jdom2.Attribute;
import org.jdom2.CDATA;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.EntityRef;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.ProcessingInstruction;
import org.jdom2.Text;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.library.lang.xml.Factory;

public class DOM {
    private final IValueFactory vf;

    public DOM(IValueFactory vf) {
        this.vf = vf;
    }

    public IConstructor parseXMLDOMTrim(IString str) {
        return this.parseXMLDOM(str, true);
    }

    public IConstructor parseXMLDOM(IString str) {
        return this.parseXMLDOM(str, false);
    }

    public IString xmlRaw(IConstructor node) {
        return this.xmlToString(node, Format.getRawFormat());
    }

    public IString xmlPretty(IConstructor node) {
        return this.xmlToString(node, Format.getPrettyFormat());
    }

    public IString xmlCompact(IConstructor node) {
        return this.xmlToString(node, Format.getCompactFormat());
    }

    private IConstructor parseXMLDOM(IString str, boolean trim) {
        try {
            SAXBuilder builder = new SAXBuilder();
            CharArrayReader reader = new CharArrayReader(str.getValue().toCharArray());
            Document doc = builder.build(reader);
            return this.convertDocument(doc, trim);
        }
        catch (JDOMException e) {
            throw RuntimeExceptionFactory.io(e.getMessage());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(e.getMessage());
        }
    }

    private IString xmlToString(IConstructor node, Format format) {
        StringWriter writer = new StringWriter();
        this.writeXML(writer, this.nodeToDocument(node), format);
        return this.vf.string(writer.toString());
    }

    private void writeXML(Writer writer, Document document, Format format) {
        XMLOutputter outputter = new XMLOutputter(format);
        try {
            outputter.output(document, writer);
            writer.close();
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(e.getMessage());
        }
    }

    private Document nodeToDocument(IConstructor node) {
        if (node.getType() != Factory.Node) {
            this.wellformednessError();
        }
        if (node.getConstructorType() != Factory.Node_document && node.getConstructorType() != Factory.Node_element) {
            this.wellformednessError();
        }
        if (node.getConstructorType() == Factory.Node_document) {
            return new Document(this.nodeToElement((IConstructor)node.get(0)));
        }
        return new Document(this.nodeToElement(node));
    }

    private Element nodeToElement(IConstructor elt) {
        IConstructor ns = (IConstructor)elt.get(0);
        IString name = (IString)elt.get(1);
        IList kids = (IList)elt.get(2);
        Element e = new Element(name.getValue(), this.namespaceToNamespace(ns));
        for (IValue k : kids) {
            IConstructor n = (IConstructor)k;
            if (n.getConstructorType() == Factory.Node_attribute) {
                e.setAttribute(this.nodeToAttribute(n));
                continue;
            }
            e.addContent(this.nodeToContent(n));
        }
        return e;
    }

    private Content nodeToContent(IConstructor n) {
        if (n.getConstructorType() == Factory.Node_element) {
            return this.nodeToElement(n);
        }
        if (n.getConstructorType() == Factory.Node_pi) {
            IString target = (IString)n.get(0);
            IString data = (IString)n.get(1);
            return new ProcessingInstruction(target.getValue(), data.getValue());
        }
        if (n.getConstructorType() == Factory.Node_charRef) {
            IInteger code = (IInteger)n.get(0);
            int c = Integer.parseInt(code.getStringRepresentation());
            return new Text(new String(Character.toChars(c)));
        }
        if (n.getConstructorType() == Factory.Node_entityRef) {
            return new EntityRef(((IString)n.get(0)).getValue());
        }
        String text = ((IString)n.get(0)).getValue();
        if (n.getConstructorType() == Factory.Node_cdata) {
            return new CDATA(text);
        }
        if (n.getConstructorType() == Factory.Node_charData) {
            return new Text(text);
        }
        if (n.getConstructorType() == Factory.Node_comment) {
            return new Comment(text);
        }
        this.wellformednessError();
        return null;
    }

    private Attribute nodeToAttribute(IConstructor n) {
        IConstructor ns = (IConstructor)n.get(0);
        IString name = (IString)n.get(1);
        IString data = (IString)n.get(2);
        return new Attribute(name.getValue(), data.getValue(), this.namespaceToNamespace(ns));
    }

    private Namespace namespaceToNamespace(IConstructor ns) {
        if (ns.getConstructorType() == Factory.Namespace_none) {
            return Namespace.NO_NAMESPACE;
        }
        IString prefix = (IString)ns.get(0);
        IString uri = (IString)ns.get(1);
        return Namespace.getNamespace(prefix.getValue(), uri.getValue());
    }

    private void wellformednessError() {
        throw new RuntimeException("Nonwellformed XML node (TODO: make Rascal runtime exception)");
    }

    private IConstructor convertDocument(Document doc, boolean trim) {
        IConstructor root = this.convertElement(doc.getRootElement(), trim);
        return this.vf.constructor(Factory.Node_document, root);
    }

    private IConstructor convertElement(Element e, boolean trim) {
        IListWriter kids = this.vf.listWriter();
        Iterator<Attribute> iterator = e.getAttributes().iterator();
        while (iterator.hasNext()) {
            Attribute o;
            Attribute attr = o = iterator.next();
            IString key = this.vf.string(attr.getName());
            IString val = this.vf.string(attr.getValue());
            kids.insert(this.vf.constructor(Factory.Node_attribute, this.convertNamespace(attr.getNamespace()), key, val));
        }
        int len = e.getContentSize();
        for (int i = 0; i < len; ++i) {
            try {
                kids.append(this.convertContent(e.getContent(i), trim));
                continue;
            }
            catch (Skip c) {
                // empty catch block
            }
        }
        IString name = this.vf.string(e.getName());
        return this.vf.constructor(Factory.Node_element, new IValue[]{this.convertNamespace(e.getNamespace()), name, kids.done()});
    }

    private IConstructor convertNamespace(Namespace ns) {
        if (ns == Namespace.NO_NAMESPACE) {
            return this.vf.constructor(Factory.Namespace_none);
        }
        IString prefix = this.vf.string(ns.getPrefix());
        IString uri = this.vf.string(ns.getURI());
        IConstructor nscon = this.vf.constructor(Factory.Namespace_namespace, prefix, uri);
        return nscon;
    }

    private IConstructor convertContent(Content content, boolean trim) throws Skip {
        if (content instanceof Element) {
            return this.convertElement((Element)content, trim);
        }
        if (content instanceof CDATA) {
            CDATA cdata = (CDATA)content;
            return this.vf.constructor(Factory.Node_cdata, this.getString(trim, cdata));
        }
        if (content instanceof Text) {
            Text text = (Text)content;
            return this.vf.constructor(Factory.Node_charData, this.getString(trim, text));
        }
        if (content instanceof Comment) {
            Comment comment = (Comment)content;
            IString data = this.vf.string(comment.getText());
            return this.vf.constructor(Factory.Node_comment, data);
        }
        if (content instanceof ProcessingInstruction) {
            ProcessingInstruction pi = (ProcessingInstruction)content;
            IString data = this.vf.string(pi.getData());
            return this.vf.constructor(Factory.Node_pi, data);
        }
        if (content instanceof EntityRef) {
            EntityRef er = (EntityRef)content;
            IString data = this.vf.string(er.getName());
            return this.vf.constructor(Factory.Node_entityRef, data);
        }
        throw new AssertionError((Object)("cannot convert JDOM content type " + content.getClass()));
    }

    private IString getString(boolean trim, Text text) throws Skip {
        if (trim) {
            String s2 = text.getTextTrim();
            if ("".equals(s2)) {
                throw new Skip();
            }
            return this.vf.string(s2);
        }
        return this.vf.string(text.getText());
    }

    private static class Skip
    extends Exception {
        private static final long serialVersionUID = -6330585199877497106L;

        private Skip() {
        }
    }
}

