/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.lang.xml;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IDateTime;
import io.usethesource.vallang.IExternalValue;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jsoup.Jsoup;
import org.jsoup.internal.SimpleStreamReader;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.Range;
import org.jsoup.nodes.TextNode;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.parser.StreamParser;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.maybe.UtilMaybe;

public class IO {
    private final IRascalValueFactory vf;
    private static final String SRC_ATTR = "src";
    private static final String QUALIFIED_SRC_ATTR = "rascal-src";
    private static final TypeFactory tf = TypeFactory.getInstance();
    private static final Type nextFunctionType = tf.functionType(UtilMaybe.Maybe.instantiate(Map.of(UtilMaybe.ParameterT, tf.valueType())), tf.tupleEmpty(), tf.tupleEmpty());

    public IO(IRascalValueFactory vf) {
        this.vf = vf;
    }

    public IValue readXML(ISourceLocation loc, IBool fullyQualify, IBool trackOrigins, IBool includeEndTags, IBool ignoreComments, IBool ignoreWhitespace, IString charset, IBool inferCharset) {
        IValue iValue;
        block10: {
            if (inferCharset.getValue()) {
                charset = this.vf.string(URIResolverRegistry.getInstance().detectCharset(loc).toString());
            }
            InputStream reader = URIResolverRegistry.getInstance().getInputStream(loc);
            try {
                Parser xmlParser = Parser.xmlParser().settings(new ParseSettings(false, false)).setTrackPosition(trackOrigins.getValue());
                Document doc = Jsoup.parse(reader, charset.getValue(), loc.getURI().toString(), xmlParser);
                iValue = this.toINode(doc, trackOrigins.getValue() ? loc : null, fullyQualify.getValue(), includeEndTags.getValue(), ignoreWhitespace.getValue(), ignoreComments.getValue());
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (MalformedURLException e) {
                    throw RuntimeExceptionFactory.malformedURI(loc.getURI().toASCIIString());
                }
                catch (IOException e) {
                    throw RuntimeExceptionFactory.io(this.vf.string(e.getMessage()));
                }
            }
            reader.close();
        }
        return iValue;
    }

    public IFunction streamXML(ISourceLocation loc, IString elementName, IBool fullyQualify, IBool trackOrigins, IBool includeEndTags, IBool ignoreComments, IBool ignoreWhitespace, IString charset, IBool inferCharset) {
        if (inferCharset.getValue()) {
            charset = this.vf.string(URIResolverRegistry.getInstance().detectCharset(loc).toString());
        }
        try {
            InputStream reader = URIResolverRegistry.getInstance().getInputStream(loc);
            Parser xmlParser = Parser.xmlParser().settings(new ParseSettings(false, false)).setTrackPosition(trackOrigins.getValue());
            StreamParser streamer = new StreamParser(xmlParser);
            SimpleStreamReader ssr = new SimpleStreamReader(reader, Charset.forName(charset.getValue()));
            streamer.parse(ssr, loc.getURI().toString());
            return this.vf.function(nextFunctionType, (args, kwargs) -> {
                IConstructor iConstructor;
                Element elem = streamer.selectNext(elementName.getValue());
                if (elem == null) {
                    try {
                        reader.close();
                        streamer.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return UtilMaybe.nothing();
                }
                try {
                    iConstructor = UtilMaybe.just(this.toINode(elem, trackOrigins.getValue() ? loc : null, fullyQualify.getValue(), includeEndTags.getValue(), ignoreWhitespace.getValue(), ignoreComments.getValue()));
                }
                catch (Throwable throwable) {
                    try {
                        elem.remove();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw RuntimeExceptionFactory.io(this.vf.string(e.getMessage()));
                    }
                }
                elem.remove();
                return iConstructor;
            });
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(this.vf.string(e.getMessage()));
        }
    }

    public IValue readXML(IString string, ISourceLocation src, IBool fullyQualify, IBool trackOrigins, IBool includeEndTags, IBool ignoreComments, IBool ignoreWhitespace) {
        if (string.length() == 0) {
            throw RuntimeExceptionFactory.io("empty XML document");
        }
        Parser xmlParser = Parser.xmlParser().settings(new ParseSettings(false, false)).setTrackPosition(trackOrigins.getValue());
        Document doc = Jsoup.parse(string.getValue(), src.getURI().toString(), xmlParser);
        return this.toINode(doc.firstChild(), trackOrigins.getValue() ? src : null, fullyQualify.getValue(), includeEndTags.getValue(), ignoreWhitespace.getValue(), ignoreComments.getValue());
    }

    private IValue toINode(Document doc, ISourceLocation file, boolean fullyQualify, boolean includeEndTags, boolean ignoreWhitespace, boolean ignoreComments) {
        return this.toINode((Node)doc, file, fullyQualify, includeEndTags, ignoreWhitespace, ignoreComments);
    }

    private IValue toINode(Node node, ISourceLocation file, boolean fullyQualify, boolean includeEndTags, boolean ignoreWhitespace, boolean ignoreComments) {
        if (node instanceof TextNode) {
            return this.toIString((TextNode)node, file);
        }
        if (node instanceof DocumentType) {
            DocumentType dt = (DocumentType)node;
            HashMap<String, IValue> args = new HashMap<String, IValue>();
            args.put("publicId", this.vf.string(dt.publicId()));
            args.put("systemId", this.vf.string(dt.systemId()));
            return this.vf.node("documentType", new IValue[0], args);
        }
        if (node instanceof XmlDeclaration) {
            XmlDeclaration xd = (XmlDeclaration)node;
            HashMap<String, IValue> args = new HashMap<String, IValue>();
            args.put("content", this.vf.string(xd.getWholeDeclaration()));
            return this.vf.node("xmlDeclaration", new IValue[0], args);
        }
        if (node instanceof DataNode) {
            return this.toIString((DataNode)node, file);
        }
        if (node instanceof Comment) {
            return this.vf.node("comment", this.vf.string(((Comment)node).getData()));
        }
        if (node instanceof Element) {
            IMap m4;
            Element elem = (Element)node;
            IMapWriter namespaces = this.vf.mapWriter();
            Map<String, IValue> kws = StreamSupport.stream(elem.attributes().spliterator(), false).filter(a -> {
                if (a.getKey().startsWith("xmlns:")) {
                    namespaces.put(this.vf.string(a.getKey().substring("xmlns:".length())), this.vf.string(a.getValue()));
                } else if (a.getKey().equals("xmlns")) {
                    namespaces.put(this.vf.string("xml"), this.vf.string(a.getValue()));
                }
                return !a.getKey().startsWith("xmlns");
            }).map(a -> IO.removeNamespace(a, elem.attributes(), fullyQualify)).collect(Collectors.toMap(a -> IO.normalizeAttr(a.getKey()), a -> this.vf.string(a.getValue())));
            if (fullyQualify && (m4 = (IMap)namespaces.done()).size() > 0) {
                kws.put("xmlns", m4);
            }
            IValue[] args = (IValue[])elem.childNodes().stream().filter(p -> !ignoreComments || !(p instanceof Comment) && !(p instanceof DocumentType)).filter(p -> !ignoreWhitespace || !(p instanceof TextNode) || !((TextNode)p).isBlank()).map(n -> this.toINode((Node)n, file, fullyQualify, includeEndTags, ignoreWhitespace, ignoreComments)).filter(c -> c != null).toArray(IValue[]::new);
            if (file != null) {
                kws.put(kws.containsKey(SRC_ATTR) ? QUALIFIED_SRC_ATTR : SRC_ATTR, this.nodeToLoc((Element)node, file, includeEndTags));
            }
            return this.vf.node(IO.removeNamespace(node.nodeName(), fullyQualify), args).asWithKeywordParameters().setParameters(kws);
        }
        throw RuntimeExceptionFactory.illegalArgument((IValue)this.vf.string(node.toString()), this.vf.string("unexpected kind of XML node: " + node.getClass().getCanonicalName()));
    }

    private static String removeNamespace(String name, boolean fullyQualify) {
        if (fullyQualify) {
            return name;
        }
        int index = name.indexOf(":");
        if (index == -1) {
            return name;
        }
        return name.substring(index + 1);
    }

    private static Attribute removeNamespace(Attribute a, Attributes otherAttributes, boolean fullyQualify) {
        if (fullyQualify) {
            return a;
        }
        String key = a.getKey();
        int index = key.indexOf(":");
        if (index == -1) {
            return a;
        }
        String newKey = key.substring(index + 1);
        if (otherAttributes.hasKey(newKey)) {
            return a;
        }
        return new Attribute(newKey, a.getValue());
    }

    private ISourceLocation nodeToLoc(Element node, ISourceLocation file, boolean includeEndTags) {
        Range startRange = node.sourceRange();
        if (!startRange.isTracked()) {
            return file;
        }
        Range endRange = node.endSourceRange();
        return includeEndTags && endRange.isTracked() ? this.vf.sourceLocation(file, startRange.start().pos(), endRange.end().pos() - startRange.start().pos(), startRange.start().lineNumber(), endRange.end().lineNumber(), startRange.start().columnNumber() - 1, endRange.end().columnNumber() - 1) : this.vf.sourceLocation(file, startRange.start().pos(), startRange.end().pos() - startRange.start().pos(), startRange.start().lineNumber(), startRange.end().lineNumber(), startRange.start().columnNumber() - 1, startRange.end().columnNumber() - 1);
    }

    private IValue toIString(DataNode node, ISourceLocation file) {
        return this.vf.string(node.getWholeData());
    }

    private IValue toIString(TextNode elem, ISourceLocation file) {
        return this.vf.string(elem.getWholeText());
    }

    public IString writeXMLString(IValue cons, IString charset, IBool outline, IBool prettyPrint, IInteger indentAmount, IInteger maxPaddingWidth, IBool dropOrigins) {
        try {
            Document doc = this.createXMLDocument(cons, dropOrigins.getValue());
            doc = doc.outputSettings(this.createOutputSettings(charset.getValue(), outline.getValue(), prettyPrint.getValue(), indentAmount.intValue(), maxPaddingWidth.intValue()));
            return this.vf.string(doc.outerHtml());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(e.getMessage());
        }
    }

    public void writeXMLFile(ISourceLocation file, IValue cons, IString charset, IBool outline, IBool prettyPrint, IInteger indentAmount, IInteger maxPaddingWidth, IBool dropOrigins) {
        try (Writer out = URIResolverRegistry.getInstance().getCharacterWriter(file, charset.getValue(), false);){
            Document doc = this.createXMLDocument(cons, dropOrigins.getValue());
            doc = doc.outputSettings(this.createOutputSettings(charset.getValue(), outline.getValue(), prettyPrint.getValue(), indentAmount.intValue(), maxPaddingWidth.intValue()));
            out.write(doc.outerHtml());
        }
        catch (IOException e) {
            throw RuntimeExceptionFactory.io(e.getMessage());
        }
    }

    private Document.OutputSettings createOutputSettings(String charset, boolean outline, boolean prettyPrint, int indentAmount, int maxPaddingWidth) {
        return new Document.OutputSettings().charset(charset).escapeMode(Entities.EscapeMode.base).outline(outline).prettyPrint(prettyPrint).indentAmount(indentAmount).maxPaddingWidth(maxPaddingWidth).syntax(Document.OutputSettings.Syntax.xml);
    }

    private Document createXMLDocument(IValue cons, boolean dropOrigins) throws IOException {
        Document doc = new Document("http://localhost");
        Node node = cons.accept(new ElementCreator(dropOrigins));
        return (Document)doc.appendChild(node);
    }

    private static String normalizeAttr(String attr) {
        return attr.replaceAll(":", "-");
    }

    private static String deNormalizeAttr(String attr) {
        return attr.replaceAll("-", ":");
    }

    private static class ElementCreator
    implements IValueVisitor<Node, RuntimeException> {
        private final boolean dropOrigins;

        public ElementCreator(boolean dropOrigins) {
            this.dropOrigins = dropOrigins;
        }

        @Override
        public Node visitString(IString o) throws RuntimeException {
            return new TextNode(o.getValue());
        }

        @Override
        public Node visitReal(IReal o) throws RuntimeException {
            Element real = new Element("real");
            real.attr("val", o.toString());
            return real;
        }

        @Override
        public Node visitRational(IRational o) throws RuntimeException {
            Element rat = new Element("rat");
            rat.attr("numerator", o.numerator().toString());
            rat.attr("denominator", o.denominator().toString());
            return rat;
        }

        @Override
        public Node visitList(IList o) throws RuntimeException {
            Element list = new Element("list");
            o.stream().forEach(e -> list.appendChild(e.accept(this)));
            return list;
        }

        @Override
        public Node visitSet(ISet o) throws RuntimeException {
            Element list = new Element("set");
            o.stream().forEach(e -> list.appendChild(e.accept(this)));
            return list;
        }

        @Override
        public Node visitSourceLocation(ISourceLocation o) throws RuntimeException {
            Element loc = new Element("loc");
            loc.attr("uri", o.getURI().toString());
            if (o.hasOffsetLength()) {
                loc.attr("offset", Integer.toString(o.getOffset()));
                loc.attr("length", Integer.toString(o.getLength()));
            }
            if (o.hasLineColumn()) {
                loc.attr("beginLine", Integer.toString(o.getBeginLine()));
                loc.attr("endLine", Integer.toString(o.getEndLine()));
                loc.attr("beginColumn", Integer.toString(o.getBeginColumn()));
                loc.attr("endColumn", Integer.toString(o.getEndColumn()));
            }
            return loc;
        }

        @Override
        public Node visitTuple(ITuple o) throws RuntimeException {
            Element tuple = new Element("tuple");
            StreamSupport.stream(o.spliterator(), false).forEach(e -> tuple.appendChild(e.accept(this)));
            return tuple;
        }

        @Override
        public Node visitNode(INode o) throws RuntimeException {
            Element node = new Element(o.getName().replaceAll("-", ":"));
            Map<String, IValue> parameters = o.asWithKeywordParameters().getParameters();
            if (parameters.containsKey("xmlns")) {
                IMap ps = (IMap)parameters.get("xmlns");
                for (IValue e2 : ps) {
                    IString skey = (IString)e2;
                    if (skey.getValue().equals("xml")) {
                        node.attr("xmlns", ((IString)ps.get(skey)).getValue());
                        continue;
                    }
                    node.attr("xmlns:" + skey.getValue(), ((IString)ps.get(skey)).getValue());
                }
                parameters.remove("xmlns");
            }
            String originKey = parameters.containsKey(IO.SRC_ATTR) && parameters.containsKey(IO.QUALIFIED_SRC_ATTR) ? IO.QUALIFIED_SRC_ATTR : IO.SRC_ATTR;
            parameters.entrySet().stream().filter(v -> !this.dropOrigins || !((String)v.getKey()).equals(originKey)).forEach(e -> {
                IValue v = (IValue)e.getValue();
                node.attr(IO.deNormalizeAttr((String)e.getKey()), v.getType().isString() ? ((IString)v).getValue() : v.toString());
            });
            StreamSupport.stream(o.spliterator(), false).forEach(e -> node.appendChild(e.accept(this)));
            return node;
        }

        @Override
        public Node visitConstructor(IConstructor o) throws RuntimeException {
            return this.visitNode(o);
        }

        @Override
        public Node visitInteger(IInteger o) throws RuntimeException {
            Element integer = new Element("integer");
            integer.attr("val", o.toString());
            return integer;
        }

        @Override
        public Node visitMap(IMap o) throws RuntimeException {
            Element map = new Element("map");
            for (Map.Entry e : () -> o.entryIterator()) {
                map.appendChild(new Element("entry").appendChild(((IValue)e.getKey()).accept(this)).appendChild(((IValue)e.getValue()).accept(this)));
            }
            return map;
        }

        @Override
        public Node visitBoolean(IBool boolValue) throws RuntimeException {
            Element bool = new Element("bool");
            bool.attr("val", boolValue.toString());
            return bool;
        }

        @Override
        public Node visitExternal(IExternalValue externalValue) throws RuntimeException {
            return new TextNode(externalValue.toString());
        }

        @Override
        public Node visitDateTime(IDateTime o) throws RuntimeException {
            Element datetime = new Element("datetime");
            datetime.attr("val", o.toString());
            return datetime;
        }
    }
}

