/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.tasks.facts;

import io.usethesource.vallang.IValue;
import java.util.Collection;
import java.util.Iterator;
import org.rascalmpl.tasks.IDependencyListener;
import org.rascalmpl.tasks.IExpirationListener;
import org.rascalmpl.tasks.IFact;
import org.rascalmpl.tasks.facts.AbstractFact;

public class FineGrainedStrongFact<V>
extends AbstractFact<V> {
    public FineGrainedStrongFact(Object key, String keyName, IExpirationListener<V> exp) {
        super(key, keyName, exp);
    }

    @Override
    public synchronized boolean setValue(V val) {
        Object oldValue = this.value;
        if (oldValue == null) {
            oldValue = this.getRef();
        }
        this.clearRef();
        this.value = val;
        this.status = 0;
        if (oldValue != null && !(!(this.value instanceof IValue) ? oldValue.equals(this.value) : ((IValue)oldValue).equals((IValue)val))) {
            this.notifyChanged();
            return true;
        }
        return false;
    }

    @Override
    public synchronized void changed(IFact<?> fact, IDependencyListener.Change change, Object moreInfo) {
        switch (change) {
            case CHANGED: {
                if (this.status >= 2) break;
                System.out.println("CHANGED: " + fact + " recv by " + this);
                this.setRefWeak(this.value);
                this.value = null;
                this.status = 2;
                this.notifyInvalidated();
                break;
            }
            case INVALIDATED: {
                if (this.status >= 1) break;
                System.out.println("INVALID: " + fact + " recv by " + this);
                this.status = 1;
                this.notifyInvalidated();
                break;
            }
            case REMOVED: {
                if (this.status >= 2) break;
                this.dependencies.remove(fact);
                this.setRefWeak(this.value);
                this.value = null;
                this.status = 2;
                this.notifyInvalidated();
                break;
            }
            case MOVED_TO: {
                if (!this.dependencies.remove(fact)) break;
                this.dependencies.add((IFact)moreInfo);
                break;
            }
            case EXPIRED: {
                if (!this.dependencies.remove(fact)) break;
                Collection<IFact<?>> deps = fact.getDepends();
                this.dependencies.addAll(deps);
                for (IFact<?> dep : deps) {
                    dep.registerListener(this);
                }
                break;
            }
        }
    }

    public void dispose() {
        for (IFact f : this.dependencies) {
            f.unregisterListener(this);
        }
        for (IDependencyListener l : this.listeners) {
            l.changed(this, IDependencyListener.Change.REMOVED, null);
        }
        this.dependencies.clear();
        this.listeners.clear();
        this.value = null;
        this.clearRef();
    }

    @Override
    public synchronized V getValue() {
        if (this.status == 0) {
            return (V)this.value;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean updateFrom(IFact<V> fact) {
        boolean result = false;
        IFact<V> iFact = fact;
        synchronized (iFact) {
            if (fact instanceof AbstractFact) {
                AbstractFact f = (AbstractFact)fact;
                int oldStatus = this.status;
                this.status = f.status;
                Object oldValue = this.value;
                if (oldValue == null) {
                    oldValue = this.getRef();
                }
                if (this.status == 0) {
                    this.value = f.value;
                    if (oldValue != null && !(!(oldValue instanceof IValue) ? oldValue.equals(this.value) : ((IValue)oldValue).equals((IValue)this.value))) {
                        this.notifyChanged();
                        result = true;
                    }
                } else if (oldStatus == 0) {
                    this.notifyInvalidated();
                    this.value = null;
                    this.clearRef();
                }
                Iterator iterator = this.dependencies.iterator();
                while (iterator.hasNext()) {
                    IFact df = (IFact)iterator.next();
                    if (f.dependencies.contains(df)) continue;
                    iterator.remove();
                    df.unregisterListener(this);
                }
                for (IFact<?> df : f.dependencies) {
                    if (this.dependencies.contains(df)) continue;
                    this.dependencies.add(df);
                    df.registerListener(this);
                }
                for (IDependencyListener dl : f.listeners) {
                    dl.changed(f, IDependencyListener.Change.MOVED_TO, this);
                }
                this.listeners.addAll(f.listeners);
            }
        }
        return result;
    }
}

