/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.unicode;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class ByteOrderMarker {
    private Charset charset;
    private Charset group;
    private int[] header;
    private boolean shouldBOM = true;
    public static final ByteOrderMarker UTF8 = new ByteOrderMarker(Charset.forName("UTF-8"), null, false, new int[]{239, 187, 191});
    public static final ByteOrderMarker UTF16LE = new ByteOrderMarker(Charset.forName("UTF-16BE"), Charset.forName("UTF-16"), new int[]{254, 255});
    public static final ByteOrderMarker UTF16BE = new ByteOrderMarker(Charset.forName("UTF-16LE"), Charset.forName("UTF-16"), new int[]{255, 254});
    public static final ByteOrderMarker UTF32LE = new ByteOrderMarker(Charset.forName("UTF-32LE"), Charset.forName("UTF-32"), new int[]{255, 254, 0, 0});
    public static final ByteOrderMarker UTF32BE = new ByteOrderMarker(Charset.forName("UTF-32BE"), Charset.forName("UTF-32"), new int[]{0, 0, 254, 255});
    private static final Map<Charset, ByteOrderMarker> names = new HashMap<Charset, ByteOrderMarker>();

    public ByteOrderMarker(Charset charset, Charset group, int[] header) {
        this.group = group;
        this.charset = charset;
        this.header = header;
    }

    public ByteOrderMarker(Charset charset, Charset group, boolean shouldBom, int[] header) {
        this(charset, group, header);
        this.shouldBOM = shouldBom;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public int[] getHeader() {
        return this.header;
    }

    public int getHeaderLength() {
        return this.header.length;
    }

    public Charset getGroup() {
        return this.group;
    }

    public boolean shouldBom() {
        return this.shouldBOM;
    }

    private static void addBOM(ByteOrderMarker bom) {
        names.put(bom.charset, bom);
    }

    public static ByteOrderMarker fromString(String name) {
        return names.get(Charset.forName(name));
    }

    public boolean matches(byte[] b) {
        return this.matches(b, b.length);
    }

    public boolean matches(byte[] detectionBuffer, int len) {
        if (this.header.length > len) {
            return false;
        }
        for (int i = 0; i < this.header.length; ++i) {
            if (this.header[i] == (detectionBuffer[i] & 0xFF)) continue;
            return false;
        }
        return true;
    }

    static {
        ByteOrderMarker.addBOM(UTF8);
        ByteOrderMarker.addBOM(UTF16LE);
        ByteOrderMarker.addBOM(UTF16BE);
        ByteOrderMarker.addBOM(UTF32LE);
        ByteOrderMarker.addBOM(UTF32BE);
        names.put(ByteOrderMarker.UTF16BE.group, UTF16BE);
        names.put(ByteOrderMarker.UTF32BE.group, UTF32BE);
    }
}

