/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.file;

import io.usethesource.vallang.ISourceLocation;
import java.io.IOException;
import org.rascalmpl.uri.ILogicalSourceLocationResolver;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.file.FileURIResolver;

public abstract class AliasedFileResolver
implements ILogicalSourceLocationResolver {
    private final String scheme;
    protected final ISourceLocation root;

    AliasedFileResolver(String scheme, String rootPath) {
        this.scheme = scheme;
        this.root = FileURIResolver.constructFileURI(rootPath);
    }

    @Override
    public ISourceLocation resolve(ISourceLocation input) throws IOException {
        return URIUtil.getChildLocation(this.root, input.getPath());
    }

    @Override
    public String scheme() {
        return this.scheme;
    }

    @Override
    public String authority() {
        return "";
    }
}

