/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.file;

import engineering.swat.watch.ActiveWatch;
import engineering.swat.watch.Approximation;
import engineering.swat.watch.DaemonThreadPool;
import engineering.swat.watch.Watch;
import engineering.swat.watch.WatchEvent;
import engineering.swat.watch.WatchScope;
import io.usethesource.vallang.ISourceLocation;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.rascalmpl.uri.BadURIException;
import org.rascalmpl.uri.FileAttributes;
import org.rascalmpl.uri.ISourceLocationInputOutput;
import org.rascalmpl.uri.ISourceLocationWatcher;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.classloaders.IClassloaderLocationResolver;

public class FileURIResolver
implements ISourceLocationInputOutput,
IClassloaderLocationResolver,
ISourceLocationWatcher {
    private final Map<WatchId, ActiveWatch> watchers = new ConcurrentHashMap<WatchId, ActiveWatch>();
    private final ExecutorService watcherPool = DaemonThreadPool.buildConstrainedCached("file:///-watch-handler", Math.max(2, Math.min(6, Runtime.getRuntime().availableProcessors() - 2)));

    @Override
    public InputStream getInputStream(ISourceLocation uri) throws IOException {
        String path = this.getPath(uri);
        if (path != null) {
            return new FileInputStream(path);
        }
        throw new IOException("uri has no path: " + uri);
    }

    @Override
    public ClassLoader getClassLoader(ISourceLocation loc, ClassLoader parent) throws IOException {
        assert (loc.getScheme().equals(this.scheme()));
        Object path = loc.getPath();
        if (this.isDirectory(loc) && !((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        if (!this.isDirectory(loc) && !((String)path).endsWith(".jar")) {
            throw new IOException("Can only provide classloaders for directories or jar files, not for " + loc);
        }
        return new URLClassLoader(new URL[]{new File((String)path).toURI().toURL()}, parent);
    }

    @Override
    public void setLastModified(ISourceLocation uri, long timestamp) throws IOException {
        this.resolveToFile(uri).setLastModified(timestamp);
    }

    @Override
    public OutputStream getOutputStream(ISourceLocation uri, boolean append) throws IOException {
        String path = this.getPath(uri);
        if (path != null) {
            return new BufferedOutputStream(new FileOutputStream(this.getPath(uri), append));
        }
        throw new IOException("uri has no path: " + uri);
    }

    @Override
    public void remove(ISourceLocation uri) throws IOException {
        this.resolveToFile(uri).delete();
    }

    @Override
    public void rename(ISourceLocation from, ISourceLocation to, boolean overwrite) throws IOException {
        if (this.isFile(from) || this.isDirectory(from) && this.list(from).length == 0) {
            if (this.exists(to) && !overwrite) {
                throw new IOException("file exists " + to);
            }
            if (!this.resolveToFile(from).renameTo(this.resolveToFile(to))) {
                throw new IOException("rename failed: " + from + " to " + to);
            }
        } else {
            ISourceLocationInputOutput.super.rename(from, to, overwrite);
        }
    }

    @Override
    public String scheme() {
        return "file";
    }

    @Override
    public boolean exists(ISourceLocation uri) {
        return this.resolveToFile(uri).exists();
    }

    protected String getPath(ISourceLocation uri) {
        assert (!uri.hasAuthority());
        return uri.getPath();
    }

    @Override
    public boolean isDirectory(ISourceLocation uri) {
        return this.resolveToFile(uri).isDirectory();
    }

    @Override
    public boolean isFile(ISourceLocation uri) {
        return this.resolveToFile(uri).isFile();
    }

    @Override
    public long lastModified(ISourceLocation uri) {
        return this.resolveToFile(uri).lastModified();
    }

    @Override
    public long created(ISourceLocation uri) throws IOException {
        BasicFileAttributeView basicfile = Files.getFileAttributeView(this.resolveToFile(uri).toPath(), BasicFileAttributeView.class, LinkOption.NOFOLLOW_LINKS);
        BasicFileAttributes attr = basicfile.readAttributes();
        return attr.creationTime().toMillis();
    }

    @Override
    public boolean isWritable(ISourceLocation uri) throws IOException {
        return Files.isWritable(this.resolveToFile(uri).toPath());
    }

    @Override
    public boolean isReadable(ISourceLocation uri) throws IOException {
        return Files.isReadable(this.resolveToFile(uri).toPath());
    }

    @Override
    public long size(ISourceLocation uri) throws IOException {
        return this.resolveToFile(uri).length();
    }

    @Override
    public FileAttributes stat(ISourceLocation loc) throws IOException {
        Path file = this.resolveToFile(loc).toPath();
        BasicFileAttributes attrs = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
        return new FileAttributes(true, attrs.isRegularFile(), attrs.creationTime().toMillis(), attrs.lastModifiedTime().toMillis(), Files.isReadable(file), Files.isWritable(file), attrs.size());
    }

    @Override
    public String[] list(ISourceLocation uri) {
        return this.resolveToFile(uri).list();
    }

    private File resolveToFile(ISourceLocation uri) {
        return new File(this.getPath(uri));
    }

    @Override
    public void mkDirectory(ISourceLocation uri) {
        this.resolveToFile(uri).mkdirs();
    }

    public static ISourceLocation constructFileURI(String path) {
        try {
            return URIUtil.createFileLocation(path);
        }
        catch (URISyntaxException usex) {
            throw new BadURIException(usex);
        }
    }

    @Override
    public boolean supportsHost() {
        return false;
    }

    @Override
    public Charset getCharset(ISourceLocation uri) throws IOException {
        return null;
    }

    @Override
    public boolean supportsReadableFileChannel() {
        return true;
    }

    @Override
    public FileChannel getReadableFileChannel(ISourceLocation uri) throws IOException {
        String path = this.getPath(uri);
        if (path != null) {
            return FileChannel.open(this.resolveToFile(uri).toPath(), StandardOpenOption.READ);
        }
        throw new IOException("uri has no path: " + uri);
    }

    @Override
    public boolean supportsWritableFileChannel() {
        return true;
    }

    @Override
    public FileChannel getWritableOutputStream(ISourceLocation uri, boolean append) throws IOException {
        String path = this.getPath(uri);
        if (path != null) {
            OpenOption[] options = append ? new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.READ, StandardOpenOption.APPEND} : new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING};
            return FileChannel.open(new File(path).toPath(), options);
        }
        throw new IOException("uri has no path: " + uri);
    }

    @Override
    public void watch(ISourceLocation root, Consumer<ISourceLocationWatcher.ISourceLocationChanged> callback, boolean recursive) throws IOException {
        File rootFile = this.resolveToFile(root);
        WatchScope scope = rootFile.isFile() ? WatchScope.PATH_ONLY : (recursive ? WatchScope.PATH_AND_ALL_DESCENDANTS : WatchScope.PATH_AND_CHILDREN);
        ActiveWatch watch = Watch.build(rootFile.toPath(), scope).onOverflow(Approximation.ALL).withExecutor(this.watcherPool).on(e -> {
            ISourceLocationWatcher.ISourceLocationChanged change = this.calculateChange((WatchEvent)e, root);
            if (change != null) {
                this.watcherPool.submit(() -> callback.accept(change));
            }
        }).start();
        this.watchers.put(new WatchId(root, callback, recursive), watch);
    }

    @Override
    public boolean supportsRecursiveWatch() {
        return true;
    }

    @Override
    public void unwatch(ISourceLocation root, Consumer<ISourceLocationWatcher.ISourceLocationChanged> callback, boolean recursive) throws IOException {
        ActiveWatch activeWatch = this.watchers.remove(new WatchId(root, callback, recursive));
        if (activeWatch != null) {
            activeWatch.close();
        }
    }

    private ISourceLocationWatcher.ISourceLocationChanged calculateChange(WatchEvent event, ISourceLocation root) {
        ISourceLocation subject = URIUtil.getChildLocation(root, event.getRelativePath().toString());
        switch (event.getKind()) {
            case CREATED: {
                return ISourceLocationWatcher.created(subject);
            }
            case DELETED: {
                return ISourceLocationWatcher.deleted(subject);
            }
            case MODIFIED: {
                return ISourceLocationWatcher.modified(subject);
            }
        }
        return null;
    }

    private static class WatchId {
        final ISourceLocation root;
        final Consumer<ISourceLocationWatcher.ISourceLocationChanged> callback;
        final boolean recursive;

        public WatchId(ISourceLocation root, Consumer<ISourceLocationWatcher.ISourceLocationChanged> callback, boolean recursive) {
            this.root = root;
            this.callback = callback;
            this.recursive = recursive;
        }

        public int hashCode() {
            return Objects.hash(this.root, this.callback, this.recursive);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof WatchId)) {
                return false;
            }
            WatchId other = (WatchId)obj;
            return Objects.equals(this.root, other.root) && Objects.equals(this.callback, other.callback) && this.recursive == other.recursive;
        }
    }
}

