/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.libraries;

import io.usethesource.vallang.ISourceLocation;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.NoSuchFileException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.rascalmpl.uri.FileAttributes;
import org.rascalmpl.uri.ISourceLocationInputOutput;
import org.rascalmpl.uri.fs.FSEntry;
import org.rascalmpl.uri.fs.FileSystemTree;

public class MemoryResolver
implements ISourceLocationInputOutput {
    private final ConcurrentMap<String, FileSystemTree<MemoryEntry>> fileSystems = new ConcurrentHashMap<String, FileSystemTree<MemoryEntry>>();

    @Override
    public String scheme() {
        return "memory";
    }

    private FileSystemTree<MemoryEntry> getFS(ISourceLocation loc) {
        return this.getFS(loc.getAuthority());
    }

    private FileSystemTree<MemoryEntry> getFS(String authority) {
        return this.fileSystems.computeIfAbsent(authority, a -> new FileSystemTree<MemoryEntry>(new MemoryEntry(), true));
    }

    private MemoryEntry get(ISourceLocation uri) throws IOException {
        return this.getFS(uri).getEntry(uri.getPath());
    }

    @Override
    public InputStream getInputStream(ISourceLocation uri) throws IOException {
        MemoryEntry file = this.get(uri);
        if (file == null) {
            throw new FileNotFoundException();
        }
        if (file.contents == null) {
            throw new NoSuchFileException(uri.getPath(), null, "not a file, but a directory");
        }
        return new ByteArrayInputStream(file.contents);
    }

    @Override
    public OutputStream getOutputStream(final ISourceLocation uri, boolean append) throws IOException {
        if (uri.getScheme().endsWith("+readonly")) {
            throw new AccessDeniedException(uri.toString());
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                MemoryEntry entry = null;
                try {
                    entry = MemoryResolver.this.get(uri);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                byte[] content = this.toByteArray();
                FileSystemTree<MemoryEntry> fs = MemoryResolver.this.getFS(uri);
                if (entry == null) {
                    fs.addFile(uri.getPath(), new MemoryEntry(content), MemoryEntry::new);
                } else {
                    fs.replaceFile(uri.getPath(), old -> old.newContents(content));
                }
                super.close();
            }
        };
        if (append) {
            MemoryEntry file = this.get(uri);
            if (file == null) {
                throw new FileNotFoundException();
            }
            if (file.contents == null) {
                throw new NoSuchFileException(uri.getPath(), null, "not a file, but a directory");
            }
            result.write(file.contents);
        }
        return result;
    }

    @Override
    public long lastModified(ISourceLocation uri) throws IOException {
        return this.getFS(uri).lastModified(uri.getPath());
    }

    @Override
    public void setLastModified(ISourceLocation uri, long timestamp) throws IOException {
        this.getFS(uri).touch(uri.getPath(), timestamp);
    }

    @Override
    public Charset getCharset(ISourceLocation uri) throws IOException {
        return null;
    }

    @Override
    public boolean exists(ISourceLocation uri) {
        return this.getFS(uri).exists(uri.getPath());
    }

    @Override
    public boolean isDirectory(ISourceLocation uri) {
        return this.getFS(uri).isDirectory(uri.getPath());
    }

    @Override
    public boolean isFile(ISourceLocation uri) {
        return this.getFS(uri).isFile(uri.getPath());
    }

    @Override
    public String[] list(ISourceLocation uri) throws IOException {
        return this.getFS(uri).directChildren(uri.getPath());
    }

    @Override
    public boolean supportsHost() {
        return false;
    }

    @Override
    public void mkDirectory(ISourceLocation uri) throws IOException {
        if (uri.getScheme().endsWith("+readonly")) {
            throw new AccessDeniedException(uri.toString());
        }
        this.getFS(uri).addDirectory(uri.getPath(), new MemoryEntry(), MemoryEntry::new);
    }

    @Override
    public boolean isWritable(ISourceLocation uri) throws IOException {
        if (this.isFile(uri)) {
            return true;
        }
        throw new FileNotFoundException(uri.toString());
    }

    @Override
    public boolean isReadable(ISourceLocation uri) throws IOException {
        return this.isWritable(uri);
    }

    @Override
    public long size(ISourceLocation uri) throws IOException {
        return this.getFS(uri).size(uri.getPath());
    }

    @Override
    public FileAttributes stat(ISourceLocation loc) throws IOException {
        return this.getFS(loc).stat(loc.getPath());
    }

    @Override
    public void remove(ISourceLocation uri) throws IOException {
        if (uri.getScheme().endsWith("+readonly")) {
            throw new AccessDeniedException(uri.toString());
        }
        FileSystemTree<MemoryEntry> ft = this.getFS(uri.getAuthority());
        String path = uri.getPath();
        if (!path.isEmpty() && !path.equals("/")) {
            ft.remove(path);
        }
        if (ft.isEmpty()) {
            this.fileSystems.remove(uri.getAuthority());
        }
    }

    private static class MemoryEntry
    extends FSEntry {
        private final @Nullable byte[] contents;

        public MemoryEntry() {
            this(null);
        }

        public MemoryEntry(@Nullable byte[] contents) {
            this(System.currentTimeMillis(), System.currentTimeMillis(), contents);
        }

        public MemoryEntry(long created, long lastModified) {
            this(created, lastModified, null);
        }

        public MemoryEntry(long created, long lastModified, @Nullable byte[] contents) {
            super(created, lastModified, contents == null ? 0L : (long)contents.length);
            this.contents = contents;
        }

        public MemoryEntry newContents(byte[] newContents) {
            long newTimestamp = System.currentTimeMillis();
            if (newTimestamp <= this.getLastModified()) {
                newTimestamp = this.getLastModified() + 1L;
            }
            return new MemoryEntry(this.getCreated(), newTimestamp, newContents);
        }
    }
}

