/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util.maven;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import org.apache.commons.lang3.tuple.Pair;
import org.rascalmpl.library.Messages;
import org.rascalmpl.library.Prelude;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.util.locations.ColumnMaps;
import org.rascalmpl.util.locations.LineColumnOffsetMap;
import org.rascalmpl.util.maven.Artifact;
import org.rascalmpl.util.maven.Dependency;
import org.rascalmpl.values.IRascalValueFactory;

public class MavenMessages {
    private static final IRascalValueFactory VF = IRascalValueFactory.getInstance();
    private static final ColumnMaps columnMaps = MavenMessages.initColumnMaps();

    private static ColumnMaps initColumnMaps() {
        return new ColumnMaps(loc -> Prelude.consumeInputStream(URIResolverRegistry.getInstance().getCharacterReader(loc.top())));
    }

    private static ISourceLocation calcMessageLocation(ISourceLocation pomLocation, int line, int column) {
        LineColumnOffsetMap map = columnMaps.get(pomLocation);
        if (map != null) {
            int utf32Column = map.translateInverseColumn(line, column, true);
            Pair<Integer, Integer> offsets = map.calculateInverseOffsetLength(0, 0, line, column);
            return VF.sourceLocation(pomLocation, (int)offsets.getRight(), 0, line, line, utf32Column, utf32Column);
        }
        return pomLocation;
    }

    public static IValue info(String message, ISourceLocation pomLocation, int line, int column) {
        return Messages.info(message, MavenMessages.calcMessageLocation(pomLocation, line, column));
    }

    public static IValue warning(String message, ISourceLocation pomLocation, int line, int column) {
        return Messages.warning(message, MavenMessages.calcMessageLocation(pomLocation, line, column));
    }

    public static IValue error(String message, ISourceLocation pomLocation, int line, int column) {
        return Messages.error(message, MavenMessages.calcMessageLocation(pomLocation, line, column));
    }

    public static IValue info(String message, Dependency dep) {
        return MavenMessages.info(message, dep.getPomLocation(), dep.getLine(), dep.getColumn());
    }

    public static IValue warning(String message, Dependency dep) {
        return MavenMessages.warning(message, dep.getPomLocation(), dep.getLine(), dep.getColumn());
    }

    public static IValue error(String message, Dependency dep) {
        return MavenMessages.error(message, dep.getPomLocation(), dep.getLine(), dep.getColumn());
    }

    public static IValue info(String message, Artifact artifact) {
        return MavenMessages.info(message, artifact.getOrigin());
    }

    public static IValue warning(String message, Artifact artifact) {
        return MavenMessages.warning(message, artifact.getOrigin());
    }

    public static IValue error(String message, Artifact artifact) {
        return MavenMessages.error(message, artifact.getOrigin());
    }
}

