---
title: "module analysis::statistics::Correlation"
id: Correlation
slug: /Library/analysis/statistics/Correlation
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

Correlation between data values.
#### Usage

```rascal
import analysis::statistics::Correlation;
```



Compute the [correlation](http://en.wikipedia.org/wiki/Correlation) between pairs of data values.
Correlation measures the statistical relationship between two sets of data.

The following functions are provided:
* [PearsonsCorrelation](../../..//Library/analysis/statistics/Correlation.md#analysis-statistics-Correlation-PearsonsCorrelation)
* [PearsonsCorrelationPValues](../../..//Library/analysis/statistics/Correlation.md#analysis-statistics-Correlation-PearsonsCorrelationPValues)
* [PearsonsCorrelationStandardErrors](../../..//Library/analysis/statistics/Correlation.md#analysis-statistics-Correlation-PearsonsCorrelationStandardErrors)
* [SpearmansCorrelation](../../..//Library/analysis/statistics/Correlation.md#analysis-statistics-Correlation-SpearmansCorrelation)
* [covariance](../../..//Library/analysis/statistics/Correlation.md#analysis-statistics-Correlation-covariance)


## function PearsonsCorrelation {#analysis-statistics-Correlation-PearsonsCorrelation}

Pearson product-moment correlation coefficient.

```rascal
num PearsonsCorrelation(lrel[num x,num y] values)
```


Compute the [Pearson product-moment correlation coefficient](http://en.wikipedia.org/wiki/Pearson_product-moment_correlation_coefficient).
It is a measure of the strength of the linear dependence between two variables.

#### Pitfalls


Use [Spearmans Correlation](../../..//Library/analysis/statistics/Correlation.md#analysis-statistics-Correlation-SpearmansCorrelation) when there is a *monotonous dependence* between the two variables.

## function PearsonsCorrelationStandardErrors {#analysis-statistics-Correlation-PearsonsCorrelationStandardErrors}

Standard errors associated with Pearson correlation.

```rascal
list[real] PearsonsCorrelationStandardErrors(lrel[num x,num y] values)
```

## function PearsonsCorrelationPValues {#analysis-statistics-Correlation-PearsonsCorrelationPValues}

P-values (significance) associated with Pearson correlation.

```rascal
list[real] PearsonsCorrelationPValues(lrel[num x,num y] values)
```

## function SpearmansCorrelation {#analysis-statistics-Correlation-SpearmansCorrelation}

Spearman's rank correlation coefficient.

```rascal
num SpearmansCorrelation(lrel[num x,num y] values)
```


Compute [Spearman's rank correlation coefficient](http://en.wikipedia.org/wiki/Spearman's_rank_correlation_coefficient).
The correlation between the data values is computed by first performing a rank transformation
on the data values using a natural ranking and then computing [Pearsons Correlation](../../..//Library/analysis/statistics/Correlation.md#analysis-statistics-Correlation-PearsonsCorrelation).

#### Pitfalls


Use [Pearsons Correlation](../../..//Library/analysis/statistics/Correlation.md#analysis-statistics-Correlation-PearsonsCorrelation) when there is a *linear dependence* between the variables.

## function covariance {#analysis-statistics-Correlation-covariance}

Covariance of data values.

```rascal
num covariance(lrel[num x,num y] values)
```


Computes the [covariance](http://en.wikipedia.org/wiki/Covariance) between the `x` and `y` values.

#### Examples



```rascal-shell 
rascal>import analysis::statistics::Correlation;
ok
rascal>covariance([<1,12>,<3,12>,<3,11>,<5,7>]);
num: -2.5
```

