---
title: "module lang::html::IO"
id: IO
slug: /Library/lang/html/IO
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

Provides read and write functionality for HTMLElements defined in ((lang::html::AST))
#### Usage

```rascal
import lang::html::IO;
```

#### Dependencies
```rascal
extend lang::html::AST;
import Content;
```


## data HTMLEscapeMode {#lang-html-IO-HTMLEscapeMode}

```rascal
data HTMLEscapeMode  
     = baseMode()
     | extendedMode()
     | xhtmlMode()
     ;
```

## data HTMLSyntax {#lang-html-IO-HTMLSyntax}

```rascal
data HTMLSyntax  
     = htmlSyntax()
     | xmlSyntax()
     ;
```

## function readHTMLFile {#lang-html-IO-readHTMLFile}

Parse a HTML file and return an HTMLElement AST

```rascal
HTMLElement readHTMLFile(loc file, loc base=file, bool trackOrigins=false, bool includeEndTags=true)
```


This function uses [JSoup's](http://www.jsoup.org) HTML parser which is robust
against errors in the HTML, and complete in the sense that it supports all of HTML.

## function readHTMLString {#lang-html-IO-readHTMLString}

Parse a HTML string and return an HTMLElement AST

```rascal
HTMLElement readHTMLString(str content, loc base=|http://localhost|, bool trackOrigins=false, bool includeEndTags=true, loc src=|unknown:///|)
```


This function uses [JSoup's](http://www.jsoup.org) HTML parser which is robust
against errors in the HTML, and complete in the sense that it supports all of HTML.

## function writeHTMLString {#lang-html-IO-writeHTMLString}

Pretty-print the HTMLElement AST to a string

```rascal
str writeHTMLString(HTMLElement dom, str charset="UTF-8", HTMLEscapeMode escapeMode = baseMode(), bool outline=false, bool prettyPrint=true, int indentAmount=4, int maxPaddingWidth=30, HTMLSyntax \syntax=htmlSyntax(), bool dropOrigins=true)
```


This function uses [JSoup's](http://www.jsoup.org) DOM functionality to 
yield a syntactically correct (X)HTML string.

## function writeHTMLFile {#lang-html-IO-writeHTMLFile}

Pretty-print the HTMLElement AST to a string

```rascal
void writeHTMLFile(loc file, HTMLElement dom, str charset="UTF-8", HTMLEscapeMode escapeMode = baseMode(), bool outline=false, bool prettyPrint=true, int indentAmount=4, int maxPaddingWidth=30, HTMLSyntax \syntax=htmlSyntax(), bool dropOrigins=true)
```


This function uses [JSoup's](http://www.jsoup.org) DOM functionality to 
yield a syntactically correct (X)HTML file.

## function serve {#lang-html-IO-serve}

Convenience function to visualize an HTMLElement tree in the browser

```rascal
Content serve(HTMLElement elem)
```

