/*
 * Decompiled with CFR 0.152.
 */
package engineering.swat.watch.impl.overflows;

import engineering.swat.watch.WatchScope;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.util.EnumSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BaseFileVisitor
extends SimpleFileVisitor<Path> {
    private final Logger logger = LogManager.getLogger();
    protected final Path path;
    protected final WatchScope scope;

    public BaseFileVisitor(Path path, WatchScope scope) {
        this.path = path;
        this.scope = scope;
    }

    public void walkFileTree() {
        EnumSet<FileVisitOption> options = EnumSet.noneOf(FileVisitOption.class);
        int maxDepth = this.scope == WatchScope.PATH_AND_ALL_DESCENDANTS ? Integer.MAX_VALUE : 1;
        try {
            Files.walkFileTree(this.path, options, maxDepth, this);
        }
        catch (IOException e) {
            this.logger.error("Could not walk: {} ({})", (Object)this.path, (Object)e);
        }
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
        this.logger.error("Could not walk regular file: {} ({})", (Object)file, (Object)exc);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
        if (exc != null) {
            this.logger.error("Could not walk directory: {} ({})", (Object)dir, (Object)exc);
        }
        return FileVisitResult.CONTINUE;
    }
}

