/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.reference;

import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IWriter;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.impl.reference.Set;
import io.usethesource.vallang.impl.reference.ValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

class SetWriter
implements ISetWriter {
    protected final HashSet<IValue> setContent;
    protected Type eltType = TypeFactory.getInstance().voidType();
    protected @MonotonicNonNull Set constructedSet = null;

    SetWriter() {
        this.setContent = new HashSet();
    }

    @Override
    public Iterator<IValue> iterator() {
        return this.setContent.iterator();
    }

    private void put(IValue elem) {
        this.updateType(elem);
        this.setContent.add(elem);
    }

    private void updateType(IValue elem) {
        this.eltType = this.eltType.lub(elem.getType());
    }

    @Override
    public void insertTuple(IValue ... fields) {
        this.insert(ValueFactory.getInstance().tuple(fields));
    }

    @Override
    public void insert(IValue ... elems) throws FactTypeUseException {
        this.checkMutation();
        for (IValue elem : elems) {
            this.put(elem);
        }
    }

    @Override
    public void insertAll(Iterable<? extends IValue> collection) throws FactTypeUseException {
        this.checkMutation();
        for (IValue iValue : collection) {
            this.put(iValue);
        }
    }

    @Override
    public ISet done() {
        if (this.constructedSet == null) {
            this.constructedSet = new Set(this.eltType, this.setContent);
        }
        return this.constructedSet;
    }

    private void checkMutation() {
        if (this.constructedSet != null) {
            throw new UnsupportedOperationException("Mutation of a finalized set is not supported.");
        }
    }

    @Override
    public Supplier<IWriter<ISet>> supplier() {
        return () -> ValueFactory.getInstance().setWriter();
    }
}

