/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.util;

import io.usethesource.vallang.io.binary.util.ByteBufferOutputStream;
import io.usethesource.vallang.io.binary.util.DirectByteBufferCache;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class FileChannelDirectOutputStream
extends ByteBufferOutputStream {
    private boolean closing = false;
    private int flushes = 0;
    private final FileChannel channel;
    private final int growEvery;

    public FileChannelDirectOutputStream(FileChannel channel, int growEvery) {
        super(DirectByteBufferCache.getInstance().get(8192));
        this.channel = channel;
        this.growEvery = growEvery;
    }

    @Override
    protected ByteBuffer flush(ByteBuffer toflush) throws IOException {
        this.channel.write(toflush);
        toflush.clear();
        ++this.flushes;
        if (this.flushes == this.growEvery && !this.closing) {
            this.flushes = 0;
            return this.grow(toflush);
        }
        return toflush;
    }

    protected ByteBuffer grow(ByteBuffer current) {
        int currentCapacity = current.capacity();
        if (currentCapacity < 0x100000) {
            DirectByteBufferCache.getInstance().put(current);
            return DirectByteBufferCache.getInstance().get(currentCapacity * 2);
        }
        return current;
    }

    @Override
    public void write(ByteBuffer buf) throws IOException {
        if (this.target.remaining() >= buf.remaining()) {
            this.target.put(buf);
        } else {
            int oldLimit = buf.limit();
            buf.limit(buf.position() + this.target.remaining());
            this.target.put(buf);
            buf.limit(oldLimit);
            this.flush();
            if (this.target.remaining() >= buf.remaining()) {
                this.target.put(buf);
            } else {
                assert (this.target.position() == 0);
                this.channel.write(buf);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this.closed) {
            try (FileChannel chan = this.channel;){
                this.closing = true;
                this.flush();
                super.close();
            }
            finally {
                DirectByteBufferCache.getInstance().put(this.target);
            }
        }
    }
}

