/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.matching.AbstractBooleanResult;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;

public class MatchResult
extends AbstractBooleanResult {
    private boolean positive;
    private IMatchingResult mp;
    private Expression expression;
    private boolean firstTime;
    private Expression pattern;

    public MatchResult(IEvaluatorContext ctx, Expression pattern, boolean positive, Expression expression) {
        super(ctx);
        this.positive = positive;
        this.pattern = pattern;
        this.mp = null;
        this.expression = expression;
    }

    @Override
    public void init() {
        super.init();
        Result<IValue> result = this.expression.interpret(this.ctx.getEvaluator());
        Type subjectType = result.getStaticType();
        this.mp = this.pattern.getMatcher(this.ctx, false);
        this.mp.initMatch(result);
        if (!this.mp.mayMatch(subjectType, this.ctx.getCurrentEnvt())) {
            throw new UnexpectedType(this.mp.getType(this.ctx.getCurrentEnvt(), null), subjectType, this.ctx.getCurrentAST());
        }
        this.firstTime = true;
    }

    @Override
    public boolean hasNext() {
        if (this.firstTime) {
            return true;
        }
        return this.mp.hasNext();
    }

    @Override
    public boolean next() {
        this.firstTime = false;
        if (this.hasNext()) {
            return this.positive ? this.mp.next() : !this.mp.next();
        }
        return !this.positive;
    }
}

