/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.staticErrors;

import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import java.util.Arrays;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.result.NamedFunction;
import org.rascalmpl.interpreter.result.OverloadedFunction;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.StaticError;

public class ArgumentMismatch
extends StaticError {
    private static final long serialVersionUID = -641438732779898646L;

    public ArgumentMismatch(String name, List<AbstractFunction> candidates, Type[] argTypes, AbstractAST ast) {
        super(ArgumentMismatch.computeMessage(name, candidates, argTypes), ast);
    }

    public ArgumentMismatch(String message, AbstractAST ast) {
        super(message, ast);
    }

    public ArgumentMismatch(Result<IValue> function, Type[] argTypes, AbstractAST caller) {
        super(ArgumentMismatch.computeMessage(function, argTypes), caller);
    }

    private static String computeMessage(Result<IValue> function, Type[] argTypes) {
        if (function instanceof OverloadedFunction) {
            OverloadedFunction of = (OverloadedFunction)function;
            return ArgumentMismatch.computeMessage(of.getName(), of.getFunctions(), argTypes);
        }
        if (function instanceof NamedFunction) {
            return ArgumentMismatch.computeMessage(((NamedFunction)function).getName(), Arrays.asList(function), argTypes);
        }
        return ArgumentMismatch.computeMessage("", Arrays.asList(function), argTypes);
    }

    private static String computeMessage(String name, List<?> candidates, Type[] argTypes) {
        StringBuilder b = new StringBuilder();
        b.append("The called signature: " + name);
        b.append('(');
        ArgumentMismatch.argumentTypes(TypeFactory.getInstance().tupleType(argTypes), b);
        b.append(')');
        if (candidates.size() == 1) {
            b.append(",\ndoes not match the declared signature:");
        } else {
            b.append(",\ndoes not match any of the declared (overloaded) signature patterns:\n");
        }
        for (Object c : candidates) {
            b.append('\t');
            b.append(c.toString());
            b.append('\n');
        }
        return b.toString();
    }

    private static void argumentTypes(Type argTypes, StringBuilder b) {
        int i = 0;
        for (Type arg : argTypes) {
            if (i != 0) {
                b.append(", ");
            }
            b.append(arg);
            if (argTypes.hasFieldNames()) {
                b.append(' ');
                b.append(argTypes.getFieldName(i));
            }
            ++i;
        }
    }
}

