/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack.filter.follow;

import java.util.Arrays;
import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.stack.filter.ICompletionFilter;

public class CaseInsensitiveStringFollowRestriction
implements ICompletionFilter {
    private final int[][] string;

    public CaseInsensitiveStringFollowRestriction(int[][] string) {
        this.string = string;
        assert (Arrays.stream(string).noneMatch(letter -> ((int[])letter).length != 2));
    }

    @Override
    public boolean isFiltered(int[] input, int start, int end, PositionStore positionStore) {
        if (end + this.string.length - 1 >= input.length) {
            return false;
        }
        for (int i = this.string.length - 1; i >= 0; --i) {
            if (input[end + i] == this.string[i][0] || input[end + i] == this.string[i][1]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEqual(ICompletionFilter otherCompletionFilter) {
        if (!(otherCompletionFilter instanceof CaseInsensitiveStringFollowRestriction)) {
            return false;
        }
        CaseInsensitiveStringFollowRestriction otherStringFollowFilter = (CaseInsensitiveStringFollowRestriction)otherCompletionFilter;
        int[][] otherString = otherStringFollowFilter.string;
        if (this.string.length != otherString.length) {
            return false;
        }
        for (int i = this.string.length - 1; i >= 0; --i) {
            if (this.string[i][0] == otherString[i][0] && this.string[i][1] == otherString[i][1]) continue;
            return false;
        }
        return true;
    }
}

