/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.uptr.recovery;

import org.rascalmpl.parser.uptr.recovery.InputMatcher;

public class CaseInsensitiveLiteralMatcher
implements InputMatcher {
    private final int[] chars;
    private final int[] altChars;

    public CaseInsensitiveLiteralMatcher(String literal) {
        int length = literal.length();
        this.chars = new int[length];
        this.altChars = new int[length];
        for (int i = 0; i < length; ++i) {
            int character;
            this.chars[i] = character = literal.codePointAt(i);
            this.altChars[i] = Character.isLowerCase(character) ? Character.toUpperCase(character) : (Character.isUpperCase(character) ? Character.toLowerCase(character) : character);
        }
    }

    public CaseInsensitiveLiteralMatcher(int[][] ciLiteral) {
        int length = ciLiteral.length;
        this.chars = new int[length];
        this.altChars = new int[length];
        for (int i = 0; i < length; ++i) {
            this.chars[i] = ciLiteral[i][0];
            this.altChars[i] = ciLiteral[i][ciLiteral[i].length - 1];
        }
    }

    @Override
    public int match(int[] input, int location) {
        int length = this.chars.length;
        if (input.length < location + length) {
            return -1;
        }
        for (int i = 0; i < length; ++i) {
            int inputChar = input[location + i];
            if (inputChar == this.chars[i] || inputChar == this.altChars[i]) continue;
            return -1;
        }
        return location + length;
    }

    public String toString() {
        return "CaseInsensitiveLiteralMatcher[" + new String(this.chars, 0, this.chars.length) + "]";
    }
}

