/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.repl.completers;

import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.jline.reader.Candidate;
import org.jline.reader.Completer;
import org.jline.reader.LineReader;
import org.jline.reader.ParsedLine;

public class RascalCommandCompletion
implements Completer {
    private static final NavigableMap<String, String> COMMAND_KEYWORDS = new TreeMap<String, String>();
    private final NavigableMap<String, String> setOptions;
    private final BiConsumer<String, List<Candidate>> completeIdentifier;
    private final BiConsumer<String, List<Candidate>> completeModule;

    public RascalCommandCompletion(NavigableMap<String, String> setOptions, BiConsumer<String, List<Candidate>> completeIdentifier, BiConsumer<String, List<Candidate>> completeModule) {
        this.setOptions = setOptions;
        this.completeIdentifier = completeIdentifier;
        this.completeModule = completeModule;
    }

    private static void generateCandidates(String partial, NavigableMap<String, String> candidates, String group, List<Candidate> target) {
        for (Map.Entry can : candidates.subMap(partial, true, partial + "\uffff", false).entrySet()) {
            target.add(new Candidate((String)can.getKey(), (String)can.getKey(), group, (String)can.getValue(), null, null, true));
        }
    }

    @Override
    public void complete(LineReader reader, ParsedLine line, List<Candidate> candidates) {
        List<String> words = line.words();
        if (words.isEmpty() || !words.get(0).equals(":")) {
            return;
        }
        if (line.wordIndex() == 1) {
            RascalCommandCompletion.generateCandidates(line.word(), COMMAND_KEYWORDS, "interpreter modifiers", candidates);
            return;
        }
        if (line.wordIndex() == 2) {
            switch (words.get(1)) {
                case "set": {
                    RascalCommandCompletion.generateCandidates(line.word(), this.setOptions, "evaluator settings", candidates);
                    return;
                }
                case "undeclare": {
                    this.completeIdentifier.accept(line.word(), candidates);
                    return;
                }
                case "edit": 
                case "unimport": {
                    this.completeModule.accept(line.word(), candidates);
                    return;
                }
            }
            return;
        }
    }

    static {
        COMMAND_KEYWORDS.put("set", "change an evaluator setting");
        COMMAND_KEYWORDS.put("undeclare", "undeclare a local variable of the REPL");
        COMMAND_KEYWORDS.put("help", "print help message");
        COMMAND_KEYWORDS.put("edit", "open a rascal module in the editor");
        COMMAND_KEYWORDS.put("unimport", "unload an imported module from the REPL");
        COMMAND_KEYWORDS.put("declarations", "show declarations");
        COMMAND_KEYWORDS.put("quit", "cleanly exit the REPL");
        COMMAND_KEYWORDS.put("history", "history");
        COMMAND_KEYWORDS.put("test", "run test modules");
        COMMAND_KEYWORDS.put("modules", "show imported modules");
        COMMAND_KEYWORDS.put("clear", "clear REPL screen");
    }
}

