/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.runtime.utils;

import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import java.util.Iterator;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.values.ValueFactoryFactory;

class SubSetIterator
implements Iterator<ISet> {
    private static final IValueFactory $VF = ValueFactoryFactory.getValueFactory();
    private long n;
    private final int len;
    private final long max;
    private final IValue[] setElems;

    SubSetIterator(ISet s2) {
        this.len = s2.size();
        if (this.len >= 64) {
            throw RuntimeExceptionFactory.illegalArgument((IValue)s2, "SubSetIterator can only handle sets with less than 64 elements");
        }
        this.n = 0L;
        this.max = 1L << this.len;
        this.setElems = new IValue[this.len];
        int i = 0;
        for (IValue elm : s2) {
            this.setElems[i++] = elm;
        }
    }

    @Override
    public boolean hasNext() {
        return this.n < this.max;
    }

    @Override
    public ISet next() {
        ISetWriter w = $VF.setWriter();
        for (int j = 0; j < this.len; ++j) {
            if ((this.n & 1L << j) <= 0L) continue;
            w.insert(this.setElems[j]);
        }
        ++this.n;
        return (ISet)w.done();
    }
}

