/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.TypeFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.Field;
import org.rascalmpl.ast.KeywordArgument_Expression;
import org.rascalmpl.ast.KeywordArguments_Expression;
import org.rascalmpl.ast.KeywordFormal;
import org.rascalmpl.ast.Label;
import org.rascalmpl.ast.Mapping_Expression;
import org.rascalmpl.ast.Name;
import org.rascalmpl.ast.OptionalExpression;
import org.rascalmpl.ast.Parameters;
import org.rascalmpl.ast.Statement;
import org.rascalmpl.ast.Type;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.RascalStackOverflowError;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.TypeDeclarationEvaluator;
import org.rascalmpl.interpreter.callbacks.IConstructorDeclared;
import org.rascalmpl.interpreter.control_exceptions.Failure;
import org.rascalmpl.interpreter.control_exceptions.InterruptException;
import org.rascalmpl.interpreter.control_exceptions.MatchFailed;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.matching.AndResult;
import org.rascalmpl.interpreter.matching.AntiPattern;
import org.rascalmpl.interpreter.matching.BasicBooleanResult;
import org.rascalmpl.interpreter.matching.ConcreteListVariablePattern;
import org.rascalmpl.interpreter.matching.DescendantPattern;
import org.rascalmpl.interpreter.matching.EnumeratorResult;
import org.rascalmpl.interpreter.matching.EquivalenceResult;
import org.rascalmpl.interpreter.matching.GuardedPattern;
import org.rascalmpl.interpreter.matching.IBooleanResult;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.matching.ListPattern;
import org.rascalmpl.interpreter.matching.MatchResult;
import org.rascalmpl.interpreter.matching.MultiVariablePattern;
import org.rascalmpl.interpreter.matching.NegativePattern;
import org.rascalmpl.interpreter.matching.NodePattern;
import org.rascalmpl.interpreter.matching.NotResult;
import org.rascalmpl.interpreter.matching.OrResult;
import org.rascalmpl.interpreter.matching.QualifiedNamePattern;
import org.rascalmpl.interpreter.matching.ReifiedTypePattern;
import org.rascalmpl.interpreter.matching.SetPattern;
import org.rascalmpl.interpreter.matching.TuplePattern;
import org.rascalmpl.interpreter.matching.TypedMultiVariablePattern;
import org.rascalmpl.interpreter.matching.TypedVariablePattern;
import org.rascalmpl.interpreter.matching.VariableBecomesPattern;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.result.BoolResult;
import org.rascalmpl.interpreter.result.ICallableValue;
import org.rascalmpl.interpreter.result.IRascalResult;
import org.rascalmpl.interpreter.result.LessThanOrEqualResult;
import org.rascalmpl.interpreter.result.RascalFunction;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.NonVoidTypeRequired;
import org.rascalmpl.interpreter.staticErrors.SyntaxError;
import org.rascalmpl.interpreter.staticErrors.UndeclaredField;
import org.rascalmpl.interpreter.staticErrors.UndeclaredVariable;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;
import org.rascalmpl.interpreter.staticErrors.UnguardedIt;
import org.rascalmpl.interpreter.staticErrors.UninitializedPatternMatch;
import org.rascalmpl.interpreter.staticErrors.UninitializedVariable;
import org.rascalmpl.interpreter.staticErrors.UnsupportedOperation;
import org.rascalmpl.interpreter.staticErrors.UnsupportedPattern;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.parser.ASTBuilder;
import org.rascalmpl.parser.gtd.exception.ParseError;
import org.rascalmpl.semantics.dynamic.QualifiedName;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.types.RascalTypeFactory;
import org.rascalmpl.types.TypeReifier;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.RascalFunctionValueFactory;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.functions.IFunction;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.SymbolAdapter;

public abstract class Expression
extends org.rascalmpl.ast.Expression {
    private static final boolean instantiateTypeParameters = true;
    private static final Name IT = (Name)ASTBuilder.makeLex("Name", null, "<it>");

    public Expression(ISourceLocation __param1, IConstructor tree) {
        super(__param1, tree);
    }

    private static java.util.List<IMatchingResult> buildMatchers(java.util.List<org.rascalmpl.ast.Expression> elements, IEvaluatorContext eval, boolean bindTypeParameters) {
        ArrayList<IMatchingResult> args = new ArrayList<IMatchingResult>(elements.size());
        int i = 0;
        for (org.rascalmpl.ast.Expression e : elements) {
            args.add(i++, e.buildMatcher(eval, bindTypeParameters));
        }
        return args;
    }

    private static Result<IValue> evalBooleanExpression(org.rascalmpl.ast.Expression x, IEvaluatorContext ctx) {
        IBooleanResult mp = x.getBacktracker(ctx);
        mp.init();
        return Expression.makeResult(TypeFactory.getInstance().boolType(), ctx.getValueFactory().bool(mp.hasNext() && mp.next()), ctx);
    }

    public static class VoidClosure
    extends Expression.VoidClosure {
        public VoidClosure(ISourceLocation __param1, IConstructor tree, Parameters __param2, java.util.List<Statement> __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> eval) {
            java.util.List<KeywordFormal> kws;
            eval.setCurrentAST(this);
            eval.notifyAboutSuspension(this);
            Parameters parameters = this.getParameters();
            io.usethesource.vallang.type.Type formals = parameters.typeOf(eval.getCurrentEnvt(), eval, true);
            io.usethesource.vallang.type.Type kwParams = TF.tupleEmpty();
            java.util.List<KeywordFormal> list = kws = parameters.getKeywordFormals().hasKeywordFormalList() ? parameters.getKeywordFormals().getKeywordFormalList() : Collections.emptyList();
            if (parameters.hasKeywordFormals() && parameters.getKeywordFormals().hasKeywordFormalList()) {
                kwParams = TypeDeclarationEvaluator.computeKeywordParametersType(kws, eval);
            }
            return new RascalFunction(this, eval, null, TF.functionType(TF.voidType(), formals, kwParams), TF.functionType(TF.voidType(), formals, kwParams).instantiate(eval.getCurrentEnvt().getDynamicTypeBindings()), kws, this.getParameters().isVarArgs(), false, false, this.getStatements0(), eval.getCurrentEnvt(), eval.__getAccumulators());
        }
    }

    public static class Visit
    extends Expression.Visit {
        public Visit(ISourceLocation __param1, IConstructor tree, Label __param2, org.rascalmpl.ast.Visit __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            return this.getVisit().interpret(__eval);
        }
    }

    public static class VariableBecomes
    extends Expression.VariableBecomes {
        public VariableBecomes(ISourceLocation __param1, IConstructor tree, Name __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            org.rascalmpl.ast.Expression pattern = this.getPattern();
            if (pattern instanceof Expression.Splice) {
                throw new UnsupportedPattern("named splices (i.e. name:*pattern)", this);
            }
            IMatchingResult pat = pattern.buildMatcher(eval, bindTypeParameters);
            LinkedList<Name> names = new LinkedList<Name>();
            names.add(this.getName());
            QualifiedNamePattern var = new QualifiedNamePattern(eval, this, (org.rascalmpl.ast.QualifiedName)ASTBuilder.make("QualifiedName", "Default", this.getLocation(), names));
            return new VariableBecomesPattern(eval, this, var, pat);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            return this.getPattern().interpret(__eval);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return this.getPattern().typeOf(env, eval, instantiateTypeParameters);
        }
    }

    public static class TypedVariableBecomes
    extends Expression.TypedVariableBecomes {
        public TypedVariableBecomes(ISourceLocation __param1, IConstructor tree, Type __param2, Name __param3, org.rascalmpl.ast.Expression __param4) {
            super(__param1, tree, __param2, __param3, __param4);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new SyntaxError("expression", this.getLocation());
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            io.usethesource.vallang.type.Type type = this.getType().typeOf(eval.getCurrentEnvt(), eval.getEvaluator(), true);
            IMatchingResult pat = this.getPattern().buildMatcher(eval, bindTypeParameters);
            TypedVariablePattern var = new TypedVariablePattern(eval, (org.rascalmpl.ast.Expression)this, type, this.getName(), bindTypeParameters);
            return new VariableBecomesPattern(eval, this, var, pat);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            return this.getPattern().interpret(__eval);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return this.getType().typeOf(env, eval, instantiateTypeParameters);
        }
    }

    public static class TypedVariable
    extends Expression.TypedVariable {
        public TypedVariable(ISourceLocation __param1, IConstructor tree, Type __param2, Name __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UninitializedVariable(Names.name(this.getName()), this);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            Environment env = eval.getCurrentEnvt();
            io.usethesource.vallang.type.Type type = this.getType().typeOf(env, eval.getEvaluator(), true);
            return new TypedVariablePattern(eval, (org.rascalmpl.ast.Expression)this, type, this.getName(), bindTypeParameters);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            IRascalResult result = __eval.getCurrentEnvt().getFrameVariable(Names.name(this.getName()));
            if (result != null && ((Result)result).getValue() != null) {
                return result;
            }
            throw new UninitializedVariable(Names.name(this.getName()), this);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return this.getType().typeOf(env, eval, instantiateTypeParameters);
        }
    }

    public static class Tuple
    extends Expression.Tuple {
        public Tuple(ISourceLocation __param1, IConstructor tree, java.util.List<org.rascalmpl.ast.Expression> __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            return new TuplePattern(eval, this, Expression.buildMatchers(this.getElements(), eval, bindTypeParameters));
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            java.util.List<org.rascalmpl.ast.Expression> elements = this.getElements();
            IValue[] values = new IValue[elements.size()];
            io.usethesource.vallang.type.Type[] types = new io.usethesource.vallang.type.Type[elements.size()];
            for (int i = 0; i < elements.size(); ++i) {
                Result<IValue> resultElem = elements.get(i).interpret(__eval);
                if (resultElem.getStaticType().isBottom()) {
                    throw new UnexpectedType(TF.valueType(), TF.voidType(), this);
                }
                types[i] = resultElem.getStaticType();
                values[i] = resultElem.getValue();
            }
            return ResultFactory.makeResult(TF.tupleType(types), __eval.__getVf().tuple(values), __eval);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            java.util.List<org.rascalmpl.ast.Expression> fields = this.getElements();
            io.usethesource.vallang.type.Type[] fieldTypes = new io.usethesource.vallang.type.Type[fields.size()];
            for (int i = 0; i < fields.size(); ++i) {
                fieldTypes[i] = fields.get(i).typeOf(env, eval, instantiateTypeParameters);
            }
            return TF.tupleType(fieldTypes);
        }
    }

    public static class TransitiveReflexiveClosure
    extends Expression.TransitiveReflexiveClosure {
        public TransitiveReflexiveClosure(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            return this.getArgument().interpret(__eval).transitiveReflexiveClosure();
        }
    }

    public static class TransitiveClosure
    extends Expression.TransitiveClosure {
        public TransitiveClosure(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            return this.getArgument().interpret(__eval).transitiveClosure();
        }
    }

    public static class Subtraction
    extends Expression.Subtraction {
        public Subtraction(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> left = this.getLhs().interpret(__eval);
            Result<IValue> right = this.getRhs().interpret(__eval);
            return left.subtract(right);
        }
    }

    public static class Subscript
    extends Expression.Subscript {
        public Subscript(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, java.util.List<org.rascalmpl.ast.Expression> __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new BasicBooleanResult(eval, this);
        }

        @Override
        public Result<IBool> isDefined(IEvaluator<Result<IValue>> __eval) {
            Result<IValue> expr = this.getExpression().interpret(__eval);
            int nSubs = this.getSubscripts().size();
            Result[] subscripts = new Result[nSubs];
            for (int i = 0; i < nSubs; ++i) {
                org.rascalmpl.ast.Expression subsExpr = this.getSubscripts().get(i);
                subscripts[i] = this.isWildCard(subsExpr) ? null : subsExpr.interpret(__eval);
            }
            return expr.isKeyDefined(subscripts);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> expr = this.getExpression().interpret(__eval);
            int nSubs = this.getSubscripts().size();
            Result[] subscripts = new Result[nSubs];
            for (int i = 0; i < nSubs; ++i) {
                org.rascalmpl.ast.Expression subsExpr = this.getSubscripts().get(i);
                subscripts[i] = this.isWildCard(subsExpr) ? null : subsExpr.interpret(__eval);
            }
            return expr.subscript(subscripts);
        }

        private boolean isWildCard(org.rascalmpl.ast.Expression fieldName) {
            if (fieldName.isQualifiedName()) {
                return ((QualifiedName.Default)fieldName.getQualifiedName()).lastName().equals("_");
            }
            return false;
        }
    }

    public static class SliceStep
    extends Expression.SliceStep {
        public SliceStep(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, OptionalExpression __param3, org.rascalmpl.ast.Expression __param4, OptionalExpression __param5) {
            super(__param1, tree, __param2, __param3, __param4, __param5);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new BasicBooleanResult(eval, this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> expr = this.getExpression().interpret(__eval);
            Result<IValue> first = this.getOptFirst().hasExpression() ? this.getOptFirst().getExpression().interpret(__eval) : null;
            Result<IValue> second = this.getSecond().interpret(__eval);
            Result<IValue> last = this.getOptLast().hasExpression() ? this.getOptLast().getExpression().interpret(__eval) : null;
            return expr.slice(first, second, last);
        }
    }

    public static class Slice
    extends Expression.Slice {
        public Slice(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, OptionalExpression __param3, OptionalExpression __param4) {
            super(__param1, tree, __param2, __param3, __param4);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new BasicBooleanResult(eval, this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> expr = this.getExpression().interpret(__eval);
            Result<IValue> first = this.getOptFirst().hasExpression() ? this.getOptFirst().getExpression().interpret(__eval) : null;
            Result<IValue> last = this.getOptLast().hasExpression() ? this.getOptLast().getExpression().interpret(__eval) : null;
            return expr.slice(first, null, last);
        }
    }

    public static class StepRange
    extends Expression.StepRange {
        public StepRange(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3, org.rascalmpl.ast.Expression __param4) {
            super(__param1, tree, __param2, __param3, __param4);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> from = this.getFirst().interpret(__eval);
            Result<IValue> to = this.getLast().interpret(__eval);
            Result<IValue> second = this.getSecond().interpret(__eval);
            return from.makeStepRange(to, second);
        }
    }

    public static class SetAnnotation
    extends Expression.SetAnnotation {
        public SetAnnotation(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, Name __param3, org.rascalmpl.ast.Expression __param4) {
            super(__param1, tree, __param2, __param3, __param4);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> base = this.getExpression().interpret(__eval);
            String annoName = Names.name(this.getName());
            Result<IValue> anno = this.getValue().interpret(__eval);
            return base.setAnnotation(annoName, anno, __eval.getCurrentEnvt());
        }
    }

    public static class Set
    extends Expression.Set {
        public Set(ISourceLocation __param1, IConstructor tree, java.util.List<org.rascalmpl.ast.Expression> __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            return new SetPattern(eval, this, Expression.buildMatchers(this.getElements0(), eval, bindTypeParameters), bindTypeParameters);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            java.util.List<org.rascalmpl.ast.Expression> elements = this.getElements0();
            io.usethesource.vallang.type.Type elementType = TF.voidType();
            ArrayList<IValue> results = new ArrayList<IValue>();
            for (org.rascalmpl.ast.Expression expr : elements) {
                Result<IValue> resultElem;
                if (expr.isSplice() || expr.isSplicePlus()) {
                    resultElem = expr.getArgument().interpret(__eval);
                    if (resultElem.getStaticType().isBottom()) {
                        throw new NonVoidTypeRequired(expr.getArgument());
                    }
                    if (resultElem.getStaticType().isSet() || resultElem.getStaticType().isList()) {
                        elementType = elementType.lub(resultElem.getStaticType().getElementType());
                        for (IValue val : (Iterable)((Object)resultElem.getValue())) {
                            results.add(val);
                        }
                        continue;
                    }
                } else {
                    resultElem = expr.interpret(__eval);
                    if (resultElem.getStaticType().isBottom()) {
                        throw new NonVoidTypeRequired(expr);
                    }
                }
                elementType = elementType.lub(resultElem.getStaticType());
                results.add(results.size(), resultElem.getValue());
            }
            io.usethesource.vallang.type.Type resultType = TF.setType(elementType);
            ISetWriter w = __eval.__getVf().setWriter();
            w.insertAll(results);
            return Set.makeResult(resultType, w.done(), __eval);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            io.usethesource.vallang.type.Type elementType = TF.voidType();
            for (org.rascalmpl.ast.Expression elt : this.getElements0()) {
                io.usethesource.vallang.type.Type eltType = elt.typeOf(env, eval, instantiateTypeParameters);
                if (eltType.isSet()) {
                    eltType = eltType.getElementType();
                }
                elementType = elementType.lub(eltType);
            }
            return TF.setType(elementType);
        }
    }

    public static class ReifyType
    extends Expression.ReifyType {
        public ReifyType(ISourceLocation __param1, IConstructor tree, Type __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> eval) {
            eval.setCurrentAST(this);
            eval.notifyAboutSuspension(this);
            io.usethesource.vallang.type.Type t2 = this.getType().typeOf(eval.getCurrentEnvt(), eval, true);
            IMap gr = (IMap)eval.__getVf().mapWriter().done();
            if (!t2.isTop()) {
                gr = (IMap)eval.getEvaluator().getGrammar(eval.getCurrentEnvt()).get("rules");
            }
            IConstructor value = t2 instanceof NonTerminalType ? ((IRascalValueFactory)eval.getValueFactory()).reifiedType(((NonTerminalType)t2).getSymbol(), gr) : new TypeReifier(eval.__getVf()).typeToValue(t2, eval.getCurrentEnvt().getStore(), gr);
            return ReifyType.makeResult(value.getType(), value, eval);
        }
    }

    public static class ReifiedType
    extends Expression.ReifiedType {
        private static final io.usethesource.vallang.type.Type defType = TypeFactory.getInstance().mapType(RascalValueFactory.Symbol, RascalValueFactory.Production);

        public ReifiedType(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            return new ReifiedTypePattern(eval, this, this.getSymbol().buildMatcher(eval, bindTypeParameters), this.getDefinitions().buildMatcher(eval, bindTypeParameters));
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> symbol = this.getSymbol().interpret(__eval);
            Result<IValue> declarations = this.getDefinitions().interpret(__eval);
            if (!symbol.getStaticType().isSubtypeOf(RascalValueFactory.Symbol)) {
                throw new UnexpectedType(RascalValueFactory.Symbol, symbol.getStaticType(), this.getSymbol());
            }
            if (!declarations.getStaticType().isSubtypeOf(defType)) {
                throw new UnexpectedType(defType, declarations.getStaticType(), this.getSymbol());
            }
            IConstructor val = IRascalValueFactory.getInstance().reifiedType((IConstructor)symbol.getValue(), (IMap)declarations.getValue());
            io.usethesource.vallang.type.Type typ = RascalValueFactory.Type.instantiate(Collections.singletonMap(RascalValueFactory.TypeParam, TF.valueType()));
            return ResultFactory.makeResult(typ, val, __eval);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return RascalTypeFactory.getInstance().reifiedType(TF.valueType());
        }
    }

    public static class Reducer
    extends Expression.Reducer {
        public Reducer(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3, java.util.List<org.rascalmpl.ast.Expression> __param4) {
            super(__param1, tree, __param2, __param3, __param4);
        }

        @Override
        public IBooleanResult getBacktracker(IEvaluatorContext ctx) {
            return new BasicBooleanResult(ctx, this);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return this.getBacktracker(eval);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            org.rascalmpl.ast.Expression init = this.getInit();
            org.rascalmpl.ast.Expression result = this.getResult();
            java.util.List<org.rascalmpl.ast.Expression> generators = this.getGenerators();
            int size = generators.size();
            IBooleanResult[] gens = new IBooleanResult[size];
            Environment[] olds = new Environment[size];
            Environment old = __eval.getCurrentEnvt();
            int i = 0;
            Result<IValue> it = init.interpret(__eval);
            try {
                olds[0] = __eval.getCurrentEnvt();
                __eval.pushEnv();
                gens[0] = generators.get(0).getBacktracker(__eval);
                gens[0].init();
                while (i >= 0 && i < size) {
                    if (__eval.isInterrupted()) {
                        throw new InterruptException(__eval.getStackTrace(), __eval.getCurrentAST().getLocation());
                    }
                    if (gens[i].hasNext() && gens[i].next()) {
                        if (i == size - 1) {
                            __eval.getCurrentEnvt().storeVariable(IT, it);
                            it = result.interpret(__eval);
                            __eval.unwind(olds[i]);
                            __eval.pushEnv();
                            continue;
                        }
                        gens[++i] = generators.get(i).getBacktracker(__eval);
                        gens[i].init();
                        olds[i] = __eval.getCurrentEnvt();
                        __eval.pushEnv();
                        continue;
                    }
                    __eval.unwind(olds[i]);
                    --i;
                }
            }
            finally {
                __eval.unwind(old);
            }
            return it;
        }
    }

    public static class Range
    extends Expression.Range {
        public Range(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> from = this.getFirst().interpret(__eval);
            Result<IValue> to = this.getLast().interpret(__eval);
            return from.makeRange(to);
        }
    }

    public static class QualifiedName
    extends Expression.QualifiedName {
        public QualifiedName(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.QualifiedName __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new BasicBooleanResult(eval, this);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            org.rascalmpl.ast.QualifiedName name = this.getQualifiedName();
            Result<IValue> r = eval.getEvaluator().getCurrentEnvt().getSimpleVariable(name);
            if (r != null) {
                NonTerminalType cType;
                if (r.getValue() != null) {
                    return new QualifiedNamePattern(eval, this, name);
                }
                io.usethesource.vallang.type.Type type = r.getStaticType();
                if (type instanceof NonTerminalType && (cType = (NonTerminalType)type).isConcreteListType()) {
                    return new ConcreteListVariablePattern(eval, (AbstractAST)this, type, ((QualifiedName.Default)name).lastName());
                }
                return new QualifiedNamePattern(eval, this, name);
            }
            return new QualifiedNamePattern(eval, this, name);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            org.rascalmpl.ast.QualifiedName name = this.getQualifiedName();
            Result<IValue> variable = __eval.getCurrentEnvt().getVariable(name);
            if (variable == null) {
                throw new UndeclaredVariable(Names.fullName(name), name);
            }
            if (variable.getValue() == null) {
                throw new UninitializedVariable(Names.fullName(name), name);
            }
            return variable;
        }

        @Override
        public Result<IBool> isDefined(IEvaluator<Result<IValue>> __eval) {
            org.rascalmpl.ast.QualifiedName name = this.getQualifiedName();
            String fullName = Names.fullName(name);
            Result<IValue> variable = __eval.getCurrentEnvt().getSimpleVariable(AbstractFunction.makeIsSetKeywordParameterName(fullName));
            if (variable == null || variable.getValue() == null) {
                variable = __eval.getCurrentEnvt().getVariable(name);
                __eval.warning("deprecated feature: run-time check on variable initialization", this.getLocation());
                return ResultFactory.bool(variable != null && variable.getValue() != null, __eval);
            }
            return ResultFactory.bool(((IBool)variable.getValue()).getValue(), __eval);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return this.getQualifiedName().typeOf(env, eval, instantiateTypeParameters);
        }
    }

    public static class Product
    extends Expression.Product {
        public Product(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> left = this.getLhs().interpret(__eval);
            Result<IValue> right = this.getRhs().interpret(__eval);
            return left.multiply(right);
        }
    }

    public static class Or
    extends Expression.Or {
        public Or(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new OrResult(eval, this.getLhs().buildBacktracker(eval), this.getRhs().buildBacktracker(eval));
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            return Expression.evalBooleanExpression(this, __eval);
        }
    }

    public static class NotIn
    extends Expression.NotIn {
        public NotIn(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new BasicBooleanResult(eval, this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> left = this.getLhs().interpret(__eval);
            Result<IValue> right = this.getRhs().interpret(__eval);
            Result<IBool> result = right.notIn(left);
            return NotIn.makeResult(result.getStaticType(), result.getValue(), __eval);
        }
    }

    public static class NonEquals
    extends Expression.NonEquals {
        public NonEquals(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new BasicBooleanResult(eval, this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> left = this.getLhs().interpret(__eval);
            Result<IValue> right = this.getRhs().interpret(__eval);
            Result<IBool> result = left.nonEquals(right);
            return NonEquals.makeResult(result.getStaticType(), result.getValue(), __eval);
        }
    }

    public static class NonEmptyBlock
    extends Expression.NonEmptyBlock {
        public NonEmptyBlock(ISourceLocation __param1, IConstructor tree, java.util.List<Statement> __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            return ((AbstractAST)ASTBuilder.make("Statement", "NonEmptyBlock", this.getLocation(), ASTBuilder.make("Label", "Empty", this.getLocation(), new Object[0]), this.getStatements())).interpret(__eval);
        }
    }

    public static class NoMatch
    extends Expression.NoMatch {
        public NoMatch(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new MatchResult(eval, this.getPattern(), false, this.getExpression());
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            return Expression.evalBooleanExpression(this, __eval);
        }
    }

    public static class Negative
    extends Expression.Negative {
        public Negative(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext __eval, boolean bindTypeParameters) {
            return new NegativePattern(__eval, this, this.getArgument().buildMatcher(__eval, bindTypeParameters));
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> arg = this.getArgument().interpret(__eval);
            return arg.negative();
        }
    }

    public static class Negation
    extends Expression.Negation {
        public Negation(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new NotResult(eval, this.getArgument().buildBacktracker(eval));
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            return Expression.evalBooleanExpression(this, __eval);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return TF.boolType();
        }
    }

    public static class Splice
    extends Expression.Splice {
        public Splice(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            org.rascalmpl.ast.Expression arg = this.getArgument();
            if (arg.hasType() && arg.hasName()) {
                Environment env = eval.getCurrentEnvt();
                io.usethesource.vallang.type.Type type = arg.getType().typeOf(env, eval.getEvaluator(), true);
                if ((type = type.instantiate(env.getStaticTypeBindings())) instanceof NonTerminalType) {
                    throw new UnsupportedOperation("splicing match", type, this);
                }
                return new TypedMultiVariablePattern(eval, (org.rascalmpl.ast.Expression)this, type, arg.getName(), bindTypeParameters);
            }
            if (arg.hasQualifiedName()) {
                return new MultiVariablePattern(eval, this, arg.getQualifiedName());
            }
            throw new UnsupportedOperation("splice operator outside of list or set", this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Name name = this.getName();
            Result<IValue> variable = __eval.getCurrentEnvt().getVariable(name);
            if (variable == null) {
                throw new UndeclaredVariable(Names.name(name), name);
            }
            if (variable.getValue() == null) {
                throw new UninitializedVariable(Names.name(name), name);
            }
            return variable;
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            org.rascalmpl.ast.Expression arg = this.getArgument();
            if (arg.hasType() && arg.hasName()) {
                return arg.getType().typeOf(env, eval, instantiateTypeParameters);
            }
            if (arg.hasQualifiedName()) {
                return arg.getQualifiedName().typeOf(env, eval, instantiateTypeParameters);
            }
            return arg.typeOf(env, eval, instantiateTypeParameters);
        }
    }

    public static class MultiVariable
    extends Expression.MultiVariable {
        public MultiVariable(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.QualifiedName __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            return new MultiVariablePattern(eval, this, this.getQualifiedName());
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            __eval.warning("Var* is deprecated, use *Var or *Type Var instead", this.getLocation());
            System.err.println(this.getLocation() + ": Var* is deprecated, use *Var instead");
            Name name = this.getName();
            Result<IValue> variable = __eval.getCurrentEnvt().getVariable(name);
            if (variable == null) {
                throw new UndeclaredVariable(Names.name(name), name);
            }
            if (variable.getValue() == null) {
                throw new UninitializedVariable(Names.name(name), name);
            }
            return variable;
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return this.getQualifiedName().typeOf(env, eval, instantiateTypeParameters);
        }
    }

    public static class Remainder
    extends Expression.Remainder {
        public Remainder(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> left = this.getLhs().interpret(__eval);
            Result<IValue> right = this.getRhs().interpret(__eval);
            return left.remainder(right);
        }
    }

    public static class Modulo
    extends Expression.Modulo {
        public Modulo(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> left = this.getLhs().interpret(__eval);
            Result<IValue> right = this.getRhs().interpret(__eval);
            return left.modulo(right);
        }
    }

    public static class Match
    extends Expression.Match {
        public Match(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new MatchResult(eval, this.getPattern(), true, this.getExpression());
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            return Expression.evalBooleanExpression(this, __eval);
        }
    }

    public static class Map
    extends Expression.Map {
        public Map(ISourceLocation __param1, IConstructor tree, java.util.List<Mapping_Expression> __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext __eval, boolean bindTypeParameters) {
            throw new ImplementationError("Map in pattern not yet implemented");
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            java.util.List<Mapping_Expression> mappings = this.getMappings();
            HashMap<IValue, IValue> seen = new HashMap<IValue, IValue>();
            io.usethesource.vallang.type.Type keyType = TF.voidType();
            io.usethesource.vallang.type.Type valueType = TF.voidType();
            IMapWriter w = __eval.__getVf().mapWriter();
            for (Mapping_Expression mapping : mappings) {
                Result<IValue> keyResult = mapping.getFrom().interpret(__eval);
                Result<IValue> valueResult = mapping.getTo().interpret(__eval);
                if (keyResult.getStaticType().isBottom()) {
                    throw new NonVoidTypeRequired(mapping.getFrom());
                }
                if (valueResult.getStaticType().isBottom()) {
                    throw new NonVoidTypeRequired(mapping.getTo());
                }
                IValue key = keyResult.getValue();
                keyType = keyType.lub(keyResult.getStaticType());
                valueType = valueType.lub(valueResult.getStaticType());
                IValue keyValue = (IValue)seen.get(key);
                if (keyValue != null) {
                    throw RuntimeExceptionFactory.MultipleKey(keyResult.getValue(), keyValue, valueResult.getValue(), mapping.getFrom(), __eval.getStackTrace());
                }
                seen.put(key, valueResult.getValue());
                w.put(key, valueResult.getValue());
            }
            io.usethesource.vallang.type.Type type = TF.mapType(keyType, valueType);
            return ResultFactory.makeResult(type, w.done(), __eval);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            io.usethesource.vallang.type.Type keyType = TF.voidType();
            io.usethesource.vallang.type.Type valueType = TF.valueType();
            for (Mapping_Expression me : this.getMappings()) {
                keyType = keyType.lub(me.getFrom().typeOf(env, eval, instantiateTypeParameters));
                valueType = valueType.lub(me.getTo().typeOf(env, eval, instantiateTypeParameters));
            }
            return TF.mapType(keyType, valueType);
        }
    }

    public static class Literal
    extends Expression.Literal {
        public Literal(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Literal __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            if (this.getLiteral().isBoolean()) {
                return new BasicBooleanResult(eval, this);
            }
            throw new UnexpectedType(TF.boolType(), this.interpret(eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext __eval, boolean bindTypeParameters) {
            return this.getLiteral().buildMatcher(__eval, bindTypeParameters);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            return this.getLiteral().interpret(__eval);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return this.getLiteral().typeOf(env, eval, instantiateTypeParameters);
        }
    }

    public static class List
    extends Expression.List {
        public List(ISourceLocation __param1, IConstructor tree, java.util.List<org.rascalmpl.ast.Expression> __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            return new ListPattern(eval, this, Expression.buildMatchers(this.getElements0(), eval, bindTypeParameters), bindTypeParameters);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            java.util.List<org.rascalmpl.ast.Expression> elements = this.getElements0();
            io.usethesource.vallang.type.Type elementType = TF.voidType();
            ArrayList<IValue> results = new ArrayList<IValue>();
            for (org.rascalmpl.ast.Expression expr : elements) {
                boolean isSplicedElem = expr.isSplice() || expr.isSplicePlus();
                Result<IValue> resultElem = null;
                if (!isSplicedElem && (resultElem = expr.interpret(__eval)).getStaticType().isBottom()) {
                    throw new NonVoidTypeRequired(expr);
                }
                if (isSplicedElem) {
                    resultElem = expr.getArgument().interpret(__eval);
                    if (resultElem.getStaticType().isBottom()) {
                        throw new NonVoidTypeRequired(expr);
                    }
                    if (resultElem.getStaticType().isList() || resultElem.getStaticType().isSet()) {
                        elementType = elementType.lub(resultElem.getStaticType().getElementType());
                        for (IValue val : (Iterable)((Object)resultElem.getValue())) {
                            results.add(val);
                        }
                        continue;
                    }
                }
                elementType = elementType.lub(resultElem.getStaticType());
                results.add(results.size(), resultElem.getValue());
            }
            io.usethesource.vallang.type.Type resultType = TF.listType(elementType);
            IListWriter w = __eval.__getVf().listWriter();
            w.appendAll(results);
            return ResultFactory.makeResult(resultType, w.done(), __eval);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            io.usethesource.vallang.type.Type elementType = TF.voidType();
            for (org.rascalmpl.ast.Expression elt : this.getElements0()) {
                elementType = elementType.lub(elt.typeOf(env, eval, instantiateTypeParameters));
            }
            return TF.listType(elementType);
        }
    }

    public static class LessThanOrEq
    extends Expression.LessThanOrEq {
        public LessThanOrEq(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new BasicBooleanResult(eval, this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> left = this.getLhs().interpret(__eval);
            Result<IValue> right = this.getRhs().interpret(__eval);
            LessThanOrEqualResult result = left.lessThanOrEqual(right);
            return ResultFactory.makeResult(result.getStaticType(), result.getValue(), __eval);
        }
    }

    public static class LessThan
    extends Expression.LessThan {
        public LessThan(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new BasicBooleanResult(eval, this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> left = this.getLhs().interpret(__eval);
            Result<IValue> right = this.getRhs().interpret(__eval);
            Result<IBool> result = left.lessThan(right);
            return LessThan.makeResult(TF.boolType(), result.getValue(), __eval);
        }
    }

    public static class Join
    extends Expression.Join {
        public Join(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> left = this.getLhs().interpret(__eval);
            Result<IValue> right = this.getRhs().interpret(__eval);
            return left.join(right);
        }
    }

    public static class It
    extends Expression.It {
        public It(ISourceLocation __param1, IConstructor tree) {
            super(__param1, tree);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> v = __eval.getCurrentEnvt().getVariable(IT);
            if (v == null) {
                throw new UnguardedIt(this);
            }
            return v;
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new BasicBooleanResult(eval, this);
        }
    }

    public static class IsDefined
    extends Expression.IsDefined {
        public IsDefined(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new BasicBooleanResult(eval, this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            return IsDefined.makeResult(TF.boolType(), this.getArgument().isDefined(__eval).getValue(), __eval);
        }
    }

    public static class Is
    extends Expression.Is {
        public Is(ISourceLocation src, IConstructor node, org.rascalmpl.ast.Expression expression, Name name) {
            super(src, node, expression, name);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new BasicBooleanResult(eval, this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IBool> result = this.getExpression().interpret(__eval).is(this.getName());
            return Is.makeResult(TF.boolType(), result.getValue(), __eval);
        }
    }

    public static class Intersection
    extends Expression.Intersection {
        public Intersection(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> left = this.getLhs().interpret(__eval);
            Result<IValue> right = this.getRhs().interpret(__eval);
            return left.intersect(right);
        }
    }

    public static class In
    extends Expression.In {
        public In(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            return new BasicBooleanResult(__eval, this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> left = this.getLhs().interpret(__eval);
            Result<IValue> right = this.getRhs().interpret(__eval);
            Result<IBool> result = right.in(left);
            return In.makeResult(TF.boolType(), result.getValue(), __eval);
        }
    }

    public static class Implication
    extends Expression.Implication {
        public Implication(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new OrResult(eval, new NotResult(eval, this.getLhs().buildBacktracker(eval)), this.getRhs().buildBacktracker(eval));
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            return Expression.evalBooleanExpression(this, __eval);
        }
    }

    public static class IfThenElse
    extends Expression.IfThenElse {
        public IfThenElse(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3, org.rascalmpl.ast.Expression __param4) {
            super(__param1, tree, __param2, __param3, __param4);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            return new BasicBooleanResult(__eval, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Environment old = __eval.getCurrentEnvt();
            __eval.pushEnv();
            try {
                Result<IValue> cval = this.getCondition().interpret(__eval);
                if (!cval.getStaticType().isBool()) {
                    throw new UnexpectedType(TF.boolType(), cval.getStaticType(), this);
                }
                if (cval.isTrue()) {
                    Result<IValue> result = this.getThenExp().interpret(__eval);
                    return result;
                }
                Result<IValue> result = this.getElseExp().interpret(__eval);
                return result;
            }
            finally {
                __eval.unwind(old);
            }
        }
    }

    public static class IfDefinedOtherwise
    extends Expression.IfDefinedOtherwise {
        public IfDefinedOtherwise(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            if (this.getLhs().isDefined(__eval).getValue().getValue()) {
                try {
                    return this.getLhs().interpret(__eval);
                }
                catch (Throw | UndeclaredField e) {
                    return this.getRhs().interpret(__eval);
                }
            }
            return this.getRhs().interpret(__eval);
        }
    }

    public static class Has
    extends Expression.Has {
        public Has(ISourceLocation src, IConstructor node, org.rascalmpl.ast.Expression expression, Name name) {
            super(src, node, expression, name);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new BasicBooleanResult(eval, this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IBool> result = this.getExpression().interpret(__eval).has(this.getName());
            return Has.makeResult(TF.boolType(), result.getValue(), __eval);
        }
    }

    public static class AsType
    extends Expression.AsType {
        public AsType(ISourceLocation __param1, IConstructor tree, Type __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            io.usethesource.vallang.type.Type type = this.getType().typeOf(eval.getCurrentEnvt(), eval.getEvaluator(), true);
            IMatchingResult absPat = this.getArgument().buildMatcher(eval, bindTypeParameters);
            return new GuardedPattern(eval, this, type, absPat);
        }

        private boolean isBootstrapped(IEvaluatorContext eval) {
            Environment root = eval.getCurrentEnvt().getRoot();
            if (root instanceof ModuleEnvironment) {
                return ((ModuleEnvironment)root).getBootstrap();
            }
            return false;
        }

        private ITree parseObject(IEvaluatorContext eval, IConstructor grammar, ISet filters, ISourceLocation location, char[] input, boolean allowAmbiguity, int maxAmbDepth, boolean allowRecovery, int maxRecoveryAttempts, int maxRecoveryTokens, boolean hasSideEffects) {
            RascalFunctionValueFactory vf = eval.getFunctionValueFactory();
            IString str = vf.string(new String(input));
            if (this.isBootstrapped(eval)) {
                return (ITree)vf.bootstrapParsers().call(grammar, str, location);
            }
            IFunction parser = vf.parser(grammar, vf.bool(allowAmbiguity), vf.integer(maxAmbDepth), vf.bool(allowRecovery), vf.integer(maxRecoveryAttempts), vf.integer(maxRecoveryTokens), vf.bool(hasSideEffects), vf.bool(false), filters);
            return (ITree)parser.call(vf.string(new String(input)), location);
        }

        private ITree parseObject(IEvaluatorContext eval, IConstructor grammar, ISet filters, ISourceLocation location, boolean allowAmbiguity, int maxAmbDepth, boolean allowRecovery, int maxRecoveryAttempts, int maxRecoveryTokens, boolean hasSideEffects) {
            RascalFunctionValueFactory vf = eval.getFunctionValueFactory();
            if (this.isBootstrapped(eval)) {
                return (ITree)vf.bootstrapParsers().call(grammar, location, location);
            }
            IFunction parser = vf.parser(grammar, vf.bool(allowAmbiguity), vf.integer(maxAmbDepth), vf.bool(allowRecovery), vf.integer(maxRecoveryAttempts), vf.integer(maxRecoveryTokens), vf.bool(hasSideEffects), vf.bool(false), filters);
            return (ITree)parser.call(location, location);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> result = this.getArgument().interpret(__eval);
            io.usethesource.vallang.type.Type expected = this.getType().typeOf(__eval.getCurrentEnvt(), __eval, true);
            if (!(expected instanceof NonTerminalType)) {
                throw new UnsupportedOperation("inline parsing", expected, this);
            }
            if (!result.getStaticType().isSubtypeOf(TF.stringType()) && !result.getStaticType().isSubtypeOf(TF.sourceLocationType())) {
                throw new UnsupportedOperation("inline parsing", result.getStaticType(), this);
            }
            IConstructor symbol = ((NonTerminalType)expected).getSymbol();
            if (!(SymbolAdapter.isSort(symbol) || SymbolAdapter.isLex(symbol) || SymbolAdapter.isLayouts(symbol) || SymbolAdapter.isStartSort(symbol))) {
                throw new UnsupportedOperation("inline parsing", expected, this);
            }
            __eval.__setInterrupt(false);
            try {
                ITree tree = null;
                IMap gr = this.isBootstrapped(__eval) ? __eval.getValueFactory().map() : (IMap)__eval.getEvaluator().getGrammar(__eval.getCurrentEnvt()).get("rules");
                IConstructor value = ((IRascalValueFactory)__eval.getValueFactory()).reifiedType(symbol, gr);
                if (result.getStaticType().isString()) {
                    tree = this.parseObject(__eval, value, VF.set(new IValue[0]), this.getLocation(), ((IString)result.getValue()).getValue().toCharArray(), true, Integer.MAX_VALUE, false, 0, 0, false);
                } else if (result.getStaticType().isSourceLocation()) {
                    tree = this.parseObject(__eval, value, VF.set(new IValue[0]), (ISourceLocation)result.getValue(), true, Integer.MAX_VALUE, false, 0, 0, false);
                }
                assert (tree != null);
                return ResultFactory.makeResult(expected, tree, __eval);
            }
            catch (ParseError e) {
                throw RuntimeExceptionFactory.parseError(this.getLocation(), this, __eval.getStackTrace());
            }
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return this.getType().typeOf(env, eval, instantiateTypeParameters);
        }
    }

    public static class GreaterThanOrEq
    extends Expression.GreaterThanOrEq {
        public GreaterThanOrEq(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            return new BasicBooleanResult(__eval, this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> left = this.getLhs().interpret(__eval);
            Result<IValue> right = this.getRhs().interpret(__eval);
            Result<IBool> result = left.greaterThanOrEqual(right);
            return GreaterThanOrEq.makeResult(TF.boolType(), result.getValue(), __eval);
        }
    }

    public static class GreaterThan
    extends Expression.GreaterThan {
        public GreaterThan(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            return new BasicBooleanResult(__eval, this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> left = this.getLhs().interpret(__eval);
            Result<IValue> right = this.getRhs().interpret(__eval);
            Result<IBool> result = left.greaterThan(right);
            return GreaterThan.makeResult(TF.boolType(), result.getValue(), __eval);
        }
    }

    public static class GetAnnotation
    extends Expression.GetAnnotation {
        public GetAnnotation(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, Name __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            return new BasicBooleanResult(__eval, this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> base = this.getExpression().interpret(__eval);
            String annoName = Names.name(this.getName());
            return base.getAnnotation(annoName, __eval.getCurrentEnvt());
        }

        @Override
        public Result<IBool> isDefined(IEvaluator<Result<IValue>> __eval) {
            Result<IValue> lhs = this.getExpression().interpret(__eval);
            Name annoName = this.getName();
            if (lhs.getValue().getType().isSubtypeOf(RascalValueFactory.Tree) && "loc".equals(Names.name(annoName))) {
                annoName = Names.toName("src", this.getName().getLocation());
            }
            return lhs.isDefined(annoName);
        }
    }

    public static class FieldUpdate
    extends Expression.FieldUpdate {
        public FieldUpdate(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, Name __param3, org.rascalmpl.ast.Expression __param4) {
            super(__param1, tree, __param2, __param3, __param4);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> expr = this.getExpression().interpret(__eval);
            Result<IValue> repl = this.getReplacement().interpret(__eval);
            String name = Names.name(this.getKey());
            return expr.fieldUpdate(name, repl, __eval.getCurrentEnvt().getStore());
        }
    }

    public static class FieldProject
    extends Expression.FieldProject {
        public FieldProject(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, java.util.List<Field> __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> base = this.getExpression().interpret(__eval);
            java.util.List<Field> fields = this.getFields();
            return base.fieldSelect(fields.toArray(new Field[0]));
        }
    }

    public static class FieldAccess
    extends Expression.FieldAccess {
        public FieldAccess(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, Name __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            return new BasicBooleanResult(__eval, this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> expr = this.getExpression().interpret(__eval);
            String field = Names.name(this.getField());
            return expr.fieldAccess(field, __eval.getCurrentEnvt().getStore());
        }

        @Override
        public Result<IBool> isDefined(IEvaluator<Result<IValue>> __eval) {
            Result<IValue> expr = this.getExpression().interpret(__eval);
            return expr.isDefined(this.getField());
        }
    }

    public static class Equivalence
    extends Expression.Equivalence {
        public Equivalence(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new EquivalenceResult(eval, this.getLhs().buildBacktracker(eval), this.getRhs().buildBacktracker(eval));
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            return Expression.evalBooleanExpression(this, __eval);
        }
    }

    public static class Equals
    extends Expression.Equals {
        public Equals(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            return new BasicBooleanResult(__eval, this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> left = this.getLhs().interpret(__eval);
            Result<IValue> right = this.getRhs().interpret(__eval);
            Result<IBool> result = left.equals(right);
            return Equals.makeResult(TF.boolType(), result.getValue(), __eval);
        }
    }

    public static class Enumerator
    extends Expression.Enumerator {
        public Enumerator(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new EnumeratorResult(eval, this.getPattern().buildMatcher(eval.getEvaluator(), false), this.getExpression());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Environment old = __eval.getCurrentEnvt();
            try {
                __eval.pushEnv();
                IBooleanResult gen = this.getBacktracker(__eval);
                gen.init();
                if (gen.hasNext() && gen.next()) {
                    Result<IValue> result = ResultFactory.makeResult(TF.boolType(), VF.bool(true), __eval);
                    return result;
                }
                Result<IValue> result = ResultFactory.makeResult(TF.boolType(), VF.bool(false), __eval);
                return result;
            }
            finally {
                __eval.unwind(old);
            }
        }
    }

    public static class Division
    extends Expression.Division {
        public Division(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> left = this.getLhs().interpret(__eval);
            Result<IValue> right = this.getRhs().interpret(__eval);
            return left.divide(right);
        }
    }

    public static class Descendant
    extends Expression.Descendant {
        public Descendant(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            IMatchingResult absPat = this.getPattern().buildMatcher(eval, bindTypeParameters);
            return new DescendantPattern(eval, this, absPat);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return TypeFactory.getInstance().valueType();
        }
    }

    public static class Concrete
    extends Expression.Concrete {
        public Concrete(ISourceLocation src, IConstructor node, org.rascalmpl.ast.Concrete concrete) {
            super(src, node, concrete);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return RascalValueFactory.Tree;
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> eval) {
            throw new SyntaxError("concrete syntax fragment", this.getLocation());
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            throw new SyntaxError("concrete syntax fragment", this.getLocation());
        }
    }

    public static class Comprehension
    extends Expression.Comprehension {
        public Comprehension(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Comprehension __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            return this.getComprehension().interpret(__eval);
        }
    }

    public static class Composition
    extends Expression.Composition {
        public Composition(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> left = this.getLhs().interpret(__eval);
            Result<IValue> right = this.getRhs().interpret(__eval);
            return left.compose(right);
        }
    }

    public static class Closure
    extends Expression.Closure {
        public Closure(ISourceLocation __param1, IConstructor tree, Type __param2, Parameters __param3, java.util.List<Statement> __param4) {
            super(__param1, tree, __param2, __param3, __param4);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            java.util.List<KeywordFormal> kwd;
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Environment env = __eval.getCurrentEnvt();
            Parameters parameters = this.getParameters();
            io.usethesource.vallang.type.Type formals = parameters.typeOf(env, __eval, true);
            io.usethesource.vallang.type.Type returnType = this.typeOf(env, __eval, true);
            io.usethesource.vallang.type.Type kwParams = TF.tupleEmpty();
            java.util.List<KeywordFormal> list = kwd = parameters.getKeywordFormals().hasKeywordFormalList() ? parameters.getKeywordFormals().getKeywordFormalList() : Collections.emptyList();
            if (parameters.hasKeywordFormals() && parameters.getKeywordFormals().hasKeywordFormalList()) {
                kwParams = TypeDeclarationEvaluator.computeKeywordParametersType(kwd, __eval);
            }
            return new RascalFunction(this, __eval, null, TF.functionType(returnType, formals, kwParams).instantiate(__eval.getCurrentEnvt().getStaticTypeBindings()), TF.functionType(returnType, formals, kwParams).instantiate(__eval.getCurrentEnvt().getDynamicTypeBindings()), kwd, this.getParameters().isVarArgs(), false, false, this.getStatements(), env, __eval.__getAccumulators());
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return this.getType().typeOf(env, eval, instantiateTypeParameters);
        }
    }

    public static class CallOrTree
    extends Expression.CallOrTree {
        private Result<IValue> cachedPrefix = null;
        private boolean registeredCacheHandler = false;
        private io.usethesource.vallang.type.Type cachedConstructorType = null;
        private boolean registeredTypeCacheHandler = false;

        public CallOrTree(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, java.util.List<org.rascalmpl.ast.Expression> __param3, KeywordArguments_Expression __param4) {
            super(__param1, tree, __param2, __param3, __param4);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            return new BasicBooleanResult(__eval, this);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            org.rascalmpl.ast.Expression nameExpr = this.getExpression();
            if (nameExpr.isQualifiedName()) {
                if (this.cachedConstructorType == null) {
                    this.registerTypeCacheHandler(eval);
                    this.cachedConstructorType = this.computeConstructorType(eval, nameExpr);
                }
                return new NodePattern(eval, this, null, nameExpr.getQualifiedName(), this.cachedConstructorType, this.visitArguments(eval, bindTypeParameters), this.visitKeywordArguments(eval, bindTypeParameters));
            }
            return new NodePattern(eval, this, nameExpr.buildMatcher(eval, bindTypeParameters), null, TF.nodeType(), this.visitArguments(eval, bindTypeParameters), this.visitKeywordArguments(eval, bindTypeParameters));
        }

        private java.util.Map<String, IMatchingResult> visitKeywordArguments(IEvaluatorContext eval, boolean bindTypeParameters) {
            KeywordArguments_Expression keywordArgs;
            HashMap<String, IMatchingResult> result = new HashMap<String, IMatchingResult>();
            if (this.hasKeywordArguments() && (keywordArgs = this.getKeywordArguments()).isDefault()) {
                for (KeywordArgument_Expression kwa : keywordArgs.getKeywordArgumentList()) {
                    result.put(Names.name(kwa.getName()), kwa.getExpression().buildMatcher(eval, bindTypeParameters));
                }
            }
            return result;
        }

        private io.usethesource.vallang.type.Type computeConstructorType(IEvaluatorContext eval, org.rascalmpl.ast.Expression nameExpr) {
            LinkedList<AbstractFunction> functions = new LinkedList<AbstractFunction>();
            String cons = Names.consName(nameExpr.getQualifiedName());
            io.usethesource.vallang.type.Type adt = eval.getCurrentEnvt().lookupAbstractDataType(Names.moduleName(nameExpr.getQualifiedName()));
            if (adt != null) {
                eval.getCurrentEnvt().getAllFunctions(adt, cons, functions);
            } else {
                eval.getCurrentEnvt().getAllFunctions(cons, functions);
            }
            if (functions.isEmpty()) {
                return null;
            }
            io.usethesource.vallang.type.Type signature = this.getArgumentTypes(eval, false);
            io.usethesource.vallang.type.Type constructorType = adt != null ? adt : TF.nodeType();
            for (AbstractFunction candidate : functions) {
                io.usethesource.vallang.type.Type decl;
                if (!candidate.getReturnType().isAbstractData() || candidate.getReturnType().isBottom() || !candidate.mayMatch(signature) || (decl = eval.getCurrentEnvt().getConstructor(candidate.getReturnType(), cons, signature)) == null) continue;
                constructorType = decl;
            }
            return constructorType;
        }

        private io.usethesource.vallang.type.Type getArgumentTypes(IEvaluatorContext eval, boolean bindTypeParameters) {
            java.util.List<IMatchingResult> args = this.visitArguments(eval, bindTypeParameters);
            io.usethesource.vallang.type.Type[] argTypes = new io.usethesource.vallang.type.Type[args.size()];
            for (int i = 0; i < argTypes.length; ++i) {
                argTypes[i] = args.get(i).getType(eval.getCurrentEnvt(), null);
            }
            io.usethesource.vallang.type.Type signature = TF.tupleType(argTypes);
            return signature;
        }

        private void registerCacheHandler(IEvaluatorContext eval) {
            if (!this.registeredCacheHandler) {
                eval.getEvaluator().registerConstructorDeclaredListener(new IConstructorDeclared(){

                    @Override
                    public void handleConstructorDeclaredEvent() {
                        cachedPrefix = null;
                        registeredCacheHandler = false;
                    }
                });
                this.registeredCacheHandler = true;
            }
        }

        private void registerTypeCacheHandler(IEvaluatorContext eval) {
            if (!this.registeredTypeCacheHandler) {
                eval.getEvaluator().registerConstructorDeclaredListener(new IConstructorDeclared(){

                    @Override
                    public void handleConstructorDeclaredEvent() {
                        cachedConstructorType = null;
                        registeredTypeCacheHandler = false;
                    }
                });
                this.registeredTypeCacheHandler = true;
            }
        }

        private java.util.List<IMatchingResult> visitArguments(IEvaluatorContext eval, boolean bindTypeParameters) {
            return Expression.buildMatchers(this.getArguments(), eval, bindTypeParameters);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> eval) {
            eval.setCurrentAST(this);
            eval.notifyAboutSuspension(this);
            if (eval.isInterrupted()) {
                throw new InterruptException(eval.getStackTrace(), eval.getCurrentAST().getLocation());
            }
            eval.setCurrentAST(this);
            Result<IValue> function = this.cachedPrefix;
            if (function == null) {
                function = this.getExpression().interpret(eval);
                if (this.getExpression().isQualifiedName() && function instanceof ICallableValue && ((ICallableValue)((Object)function)).isStatic()) {
                    org.rascalmpl.ast.QualifiedName qname = this.getExpression().getQualifiedName();
                    if (eval.getCurrentEnvt().isNameFinal(qname)) {
                        this.cachedPrefix = function;
                        this.registerCacheHandler(eval);
                    }
                } else {
                    this.cachedPrefix = null;
                }
            }
            java.util.List<org.rascalmpl.ast.Expression> args = this.getArguments();
            IValue[] actuals = new IValue[args.size()];
            io.usethesource.vallang.type.Type[] types = new io.usethesource.vallang.type.Type[args.size()];
            for (int i = 0; i < args.size(); ++i) {
                Result<IValue> resultElem = args.get(i).interpret(eval);
                types[i] = resultElem.getStaticType();
                if (types[i].isBottom()) {
                    throw new UninitializedPatternMatch("The argument is of the type 'void'", args.get(i));
                }
                actuals[i] = resultElem.getValue();
            }
            java.util.Map<String, IValue> kwActuals = Collections.emptyMap();
            if (this.hasKeywordArguments()) {
                KeywordArguments_Expression keywordArgs = this.getKeywordArguments();
                io.usethesource.vallang.type.Type kwFormals = function.getKeywordArgumentTypes(eval.getCurrentEnvt());
                if (keywordArgs.isDefault()) {
                    kwActuals = new HashMap<String, IValue>();
                    for (KeywordArgument_Expression kwa : keywordArgs.getKeywordArgumentList()) {
                        Result<IValue> val = kwa.getExpression().interpret(eval);
                        String name = Names.name(kwa.getName());
                        if (kwFormals != null) {
                            if (kwFormals.hasField(name)) {
                                if (!val.getStaticType().isSubtypeOf(kwFormals.getFieldType(name))) {
                                    throw new UnexpectedType(kwFormals.getFieldType(name), val.getStaticType(), this);
                                }
                            } else {
                                eval.getMonitor().warning("calling function with extra unknown keyword argument: " + name, this.getLocation());
                            }
                        }
                        kwActuals.put(name, val.getValue());
                    }
                }
            }
            Result<IValue> res = null;
            try {
                res = function.call(types, actuals, kwActuals);
            }
            catch (Failure | MatchFailed e) {
                throw RuntimeExceptionFactory.callFailed(eval.getValueFactory().list(actuals), eval.getCurrentAST(), eval.getStackTrace());
            }
            catch (StackOverflowError e) {
                throw new RascalStackOverflowError(this, eval.getCurrentEnvt());
            }
            return res;
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            io.usethesource.vallang.type.Type lambda = this.getExpression().typeOf(env, eval, instantiateTypeParameters);
            if (lambda.isString()) {
                return TF.nodeType();
            }
            if (lambda.isSourceLocation()) {
                return lambda;
            }
            if (lambda.isFunction()) {
                return lambda.getReturnType();
            }
            return TF.nodeType();
        }
    }

    public static class Bracket
    extends Expression.Bracket {
        public Bracket(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            return this.getExpression().buildBacktracker(__eval);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext __eval, boolean bindTypeParameters) {
            return this.getExpression().buildMatcher(__eval, bindTypeParameters);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            return this.getExpression().interpret(__eval);
        }

        @Override
        public Result<IBool> isDefined(IEvaluator<Result<IValue>> __eval) {
            return this.getExpression().isDefined(__eval);
        }
    }

    public static class Any
    extends Expression.Any {
        public Any(ISourceLocation __param1, IConstructor tree, java.util.List<org.rascalmpl.ast.Expression> __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            return new BasicBooleanResult(__eval, this);
        }

        public Result interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            java.util.List<org.rascalmpl.ast.Expression> generators = this.getGenerators();
            int size = generators.size();
            IBooleanResult[] gens = new IBooleanResult[size];
            int i = 0;
            gens[0] = generators.get(0).getBacktracker(__eval);
            gens[0].init();
            while (i >= 0 && i < size) {
                if (__eval.isInterrupted()) {
                    throw new InterruptException(__eval.getStackTrace(), __eval.getCurrentAST().getLocation());
                }
                if (gens[i].hasNext() && gens[i].next()) {
                    if (i == size - 1) {
                        return new BoolResult(TF.boolType(), __eval.__getVf().bool(true), (IEvaluatorContext)__eval);
                    }
                    gens[++i] = generators.get(i).getBacktracker(__eval);
                    gens[i].init();
                    continue;
                }
                --i;
            }
            return new BoolResult(TF.boolType(), __eval.__getVf().bool(false), (IEvaluatorContext)__eval);
        }
    }

    public static class Anti
    extends Expression.Anti {
        public Anti(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext __eval, boolean bindTypeParameters) {
            IMatchingResult absPat = this.getPattern().buildMatcher(__eval, bindTypeParameters);
            return new AntiPattern(__eval, this, absPat);
        }

        @Override
        public io.usethesource.vallang.type.Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return TypeFactory.getInstance().voidType();
        }
    }

    public static class And
    extends Expression.And {
        public And(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            return new AndResult(__eval, this.getLhs().buildBacktracker(__eval), this.getRhs().buildBacktracker(__eval));
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            return Expression.evalBooleanExpression(this, __eval);
        }
    }

    public static class All
    extends Expression.All {
        public All(ISourceLocation __param1, IConstructor tree, java.util.List<org.rascalmpl.ast.Expression> __param2) {
            super(__param1, tree, __param2);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            return new BasicBooleanResult(__eval, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Result interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            java.util.List<org.rascalmpl.ast.Expression> producers = this.getGenerators();
            int size = producers.size();
            IBooleanResult[] gens = new IBooleanResult[size];
            Environment[] olds = new Environment[size];
            Environment old = __eval.getCurrentEnvt();
            int i = 0;
            try {
                olds[0] = __eval.getCurrentEnvt();
                __eval.pushEnv();
                gens[0] = producers.get(0).getBacktracker(__eval);
                gens[0].init();
                while (i >= 0 && i < size) {
                    if (__eval.isInterrupted()) {
                        throw new InterruptException(__eval.getStackTrace(), __eval.getCurrentAST().getLocation());
                    }
                    if (gens[i].hasNext()) {
                        if (!gens[i].next()) {
                            BoolResult boolResult = new BoolResult(TF.boolType(), __eval.__getVf().bool(false), (IEvaluatorContext)__eval);
                            return boolResult;
                        }
                        if (i == size - 1) {
                            __eval.unwind(olds[i]);
                            __eval.pushEnv();
                            continue;
                        }
                        gens[++i] = producers.get(i).getBacktracker(__eval);
                        gens[i].init();
                        olds[i] = __eval.getCurrentEnvt();
                        __eval.pushEnv();
                        continue;
                    }
                    __eval.unwind(olds[i]);
                    --i;
                }
            }
            finally {
                __eval.unwind(old);
            }
            return new BoolResult(TF.boolType(), __eval.__getVf().bool(true), (IEvaluatorContext)__eval);
        }
    }

    public static class Addition
    extends Expression.Addition {
        public Addition(ISourceLocation __param1, IConstructor tree, org.rascalmpl.ast.Expression __param2, org.rascalmpl.ast.Expression __param3) {
            super(__param1, tree, __param2, __param3);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext __eval) {
            throw new UnexpectedType(TF.boolType(), this.interpret(__eval.getEvaluator()).getStaticType(), this);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.notifyAboutSuspension(this);
            Result<IValue> left = this.getLhs().interpret(__eval);
            Result<IValue> right = this.getRhs().interpret(__eval);
            return left.add(right);
        }
    }
}

