/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.types;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.rascalmpl.library.Prelude;
import org.rascalmpl.types.ReifiedType;
import org.rascalmpl.values.IRascalValueFactory;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.SymbolAdapter;

public class TypeReifier {
    private final IValueFactory vf;

    public TypeReifier(IValueFactory valueFactory) {
        this.vf = valueFactory;
    }

    public IConstructor typeToValue(Type t2, TypeStore store, IMap syntax) {
        ISetWriter definitions = this.vf.setWriter();
        IConstructor symbol = this.reify(t2, definitions, store, syntax);
        IMap index = Prelude.index(this.vf, (ISet)definitions.done());
        IMapWriter grammar = this.vf.mapWriter();
        for (IValue sym : index) {
            ISet alts = (ISet)index.get(sym);
            grammar.put(sym, this.vf.constructor(RascalValueFactory.Production_Choice, sym, alts));
        }
        return IRascalValueFactory.getInstance().reifiedType(symbol, (IMap)grammar.done());
    }

    public TypeStore buildTypeStore(IConstructor root, IMap symbol_definitions) {
        TypeStore ts = new TypeStore(new TypeStore[0]);
        TypeFactory.getInstance().fromSymbol(root, new TypeStore(new TypeStore[0]), x -> this.getAlternatives(symbol_definitions, (IConstructor)x));
        return ts;
    }

    public TypeStore buildTypeStore(IMap symbol_definitions) {
        TypeStore ts = new TypeStore(new TypeStore[0]);
        for (IValue sort : symbol_definitions) {
            TypeFactory.getInstance().fromSymbol((IConstructor)sort, ts, x -> this.getAlternatives(symbol_definitions, (IConstructor)x));
        }
        return ts;
    }

    public Type valueToType(IConstructor typeValue) {
        return this.valueToType(typeValue, new TypeStore(new TypeStore[0]));
    }

    public Type valueToType(IConstructor typeValue, TypeStore store) {
        if (typeValue.getType() instanceof ReifiedType) {
            IMap definitions = (IMap)typeValue.get("definitions");
            return TypeFactory.getInstance().fromSymbol((IConstructor)typeValue.get("symbol"), store, x -> this.getAlternatives(definitions, (IConstructor)x));
        }
        throw new IllegalArgumentException(typeValue + " is not a reified type.");
    }

    public Type productionToConstructorType(IConstructor prod) {
        if (prod.getConstructorType() == RascalValueFactory.Symbol_Prod) {
            return this.productionToConstructorType(this.convertSymbolProdToProduction(prod));
        }
        IConstructor adt = (IConstructor)(prod.has("adt") ? prod.get("adt") : prod.get("def"));
        return TypeFactory.getInstance().fromSymbol(prod, new TypeStore(new TypeStore[0]), x -> x == adt ? Collections.singleton(prod) : Collections.emptySet());
    }

    private IConstructor convertSymbolProdToProduction(IConstructor prod) {
        IValue sort = prod.get("sort");
        IValue parameters = prod.get("parameters");
        IValue attributes = prod.get("attributes");
        return this.vf.constructor(RascalValueFactory.Production_Default, sort, parameters, attributes);
    }

    private Set<IConstructor> getAlternatives(IMap definitions, IConstructor sort) {
        if (SymbolAdapter.isParametrizableType(sort) && !SymbolAdapter.getParameters(sort).isEmpty()) {
            return this.getParameterizedAlternatives(definitions, sort);
        }
        return this.getSimpleAlternatives(definitions, sort);
    }

    private Set<IConstructor> getSimpleAlternatives(IMap definitions, IConstructor sort) {
        IConstructor choice = (IConstructor)definitions.get(sort);
        if (choice == null || choice.getConstructorType() != RascalValueFactory.Production_Choice) {
            return Collections.emptySet();
        }
        HashSet<IConstructor> result = new HashSet<IConstructor>();
        for (IValue alt : (ISet)choice.get("alternatives")) {
            result.add((IConstructor)alt);
        }
        return result;
    }

    private Set<IConstructor> getParameterizedAlternatives(IMap definitions, IConstructor sort) {
        String name = SymbolAdapter.getName(sort);
        for (IValue elem : definitions) {
            IConstructor symbol = (IConstructor)elem;
            if (!SymbolAdapter.isParametrizableType(sort) || !SymbolAdapter.getName(symbol).equals(name)) continue;
            return this.getSimpleAlternatives(definitions, symbol);
        }
        return Set.of();
    }

    public Type symbolToType(IConstructor symbol) {
        return TypeFactory.getInstance().fromSymbol(symbol, new TypeStore(new TypeStore[0]), x -> Collections.emptySet());
    }

    public Type symbolToType(IConstructor symbol, IMap definitions) {
        return TypeFactory.getInstance().fromSymbol(symbol, new TypeStore(new TypeStore[0]), x -> this.getAlternatives(definitions, (IConstructor)x));
    }

    private IConstructor reify(Type t2, ISetWriter definitions, TypeStore store, IMap syntax) {
        return t2.asSymbol(this.vf, new TypeStoreWithSyntax(this.vf, store, syntax), definitions, new HashSet<IConstructor>());
    }

    public static class TypeStoreWithSyntax
    extends TypeStore {
        private final IMap grammar;
        private final IValueFactory vf;

        public TypeStoreWithSyntax(IValueFactory vf, TypeStore parent, IMap grammar) {
            super(new TypeStore[0]);
            this.grammar = grammar;
            this.vf = vf;
            this.extendStore(parent);
        }

        public IMap getGrammar() {
            return this.grammar;
        }

        public ISet getRules(IConstructor nt) {
            IConstructor choice = (IConstructor)this.grammar.get(nt);
            return choice != null ? (ISet)choice.get("alternatives") : (ISet)this.vf.setWriter().done();
        }
    }
}

