/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.file;

import io.usethesource.vallang.ISourceLocation;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.apache.commons.compress.utils.FileNameUtils;
import org.rascalmpl.uri.FileAttributes;
import org.rascalmpl.uri.ISourceLocationInput;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.classloaders.IClassloaderLocationResolver;
import org.rascalmpl.uri.jar.JarURIResolver;
import org.rascalmpl.util.maven.MavenSettings;

public class MavenRepositoryURIResolver
implements ISourceLocationInput,
IClassloaderLocationResolver {
    private static final String GROUP_ARTIFACT_VERSION_SEPARATOR = "--";
    private final ISourceLocation root = MavenRepositoryURIResolver.inferMavenRepositoryLocation();
    private final URIResolverRegistry reg;

    public MavenRepositoryURIResolver(URIResolverRegistry reg) throws IOException, URISyntaxException {
        this.reg = reg;
    }

    private static ISourceLocation inferMavenRepositoryLocation() throws URISyntaxException {
        return URIUtil.createFileLocation(MavenSettings.mavenRepository());
    }

    private ISourceLocation resolveJar(ISourceLocation input) throws IOException {
        String authority = input.getAuthority();
        if (authority.isEmpty()) {
            throw new IOException("missing mvn://groupid!artifactId!version/ as the authority in " + input);
        }
        String[] parts = authority.split(GROUP_ARTIFACT_VERSION_SEPARATOR);
        if (parts.length == 3) {
            String group = parts[0];
            String name = parts[1];
            String version = parts[2];
            String jarPath = group.replaceAll("\\.", "/") + "/" + name + "/" + version + "/" + name + "-" + version + ".jar";
            return URIUtil.getChildLocation(this.root, jarPath);
        }
        throw new IOException("Pattern mvn:///groupId!artifactId!version did not match on " + input);
    }

    private ISourceLocation resolveInsideJar(ISourceLocation input) throws IOException {
        ISourceLocation jarLocation = this.resolveJar(input);
        return URIUtil.getChildLocation(JarURIResolver.jarify(jarLocation), input.getPath());
    }

    @Override
    public ClassLoader getClassLoader(ISourceLocation loc, ClassLoader parent) throws IOException {
        return this.reg.getClassLoader(this.resolveJar(loc), parent);
    }

    @Override
    public InputStream getInputStream(ISourceLocation uri) throws IOException {
        return this.reg.getInputStream(this.resolveInsideJar(uri));
    }

    @Override
    public Charset getCharset(ISourceLocation uri) throws IOException {
        return this.reg.getCharset(this.resolveInsideJar(uri));
    }

    @Override
    public boolean exists(ISourceLocation uri) {
        try {
            return this.reg.exists(this.resolveInsideJar(uri));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public long lastModified(ISourceLocation uri) throws IOException {
        return this.reg.lastModified(this.resolveInsideJar(uri));
    }

    @Override
    public long size(ISourceLocation uri) throws IOException {
        return this.reg.size(this.resolveInsideJar(uri));
    }

    @Override
    public boolean isDirectory(ISourceLocation uri) {
        try {
            return this.reg.isDirectory(this.resolveInsideJar(uri));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public FileAttributes stat(ISourceLocation loc) throws IOException {
        return this.reg.stat(this.resolveInsideJar(loc));
    }

    @Override
    public boolean isFile(ISourceLocation uri) {
        try {
            return this.reg.isFile(this.resolveInsideJar(uri));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean isReadable(ISourceLocation uri) throws IOException {
        if (this.isFile(uri)) {
            return true;
        }
        throw new FileNotFoundException(uri.toString());
    }

    @Override
    public String[] list(ISourceLocation uri) throws IOException {
        if (uri.getAuthority().isEmpty() && (uri.getPath().isEmpty() || uri.getPath().equals("/"))) {
            return this.listAllMainArtifacts();
        }
        return this.reg.listEntries(this.resolveInsideJar(uri));
    }

    private String[] listAllMainArtifacts() throws IOException {
        try (Stream<Path> files = Files.walk(Path.of(this.root.getURI()), new FileVisitOption[0]);){
            String[] stringArray = (String[])files.filter(f -> FileNameUtils.getExtension(f).equals("jar")).filter(f -> !f.toString().endsWith("-sources.jar")).filter(f -> !f.toString().endsWith("-javadoc.jar")).map(f -> {
                try {
                    return URIUtil.createFileLocation(f);
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Could not convert path to source location", e);
                }
            }).map(fl -> {
                ISourceLocation parent = URIUtil.getParentLocation(fl);
                String version = URIUtil.getLocationName(parent);
                ISourceLocation grandParent = URIUtil.getParentLocation(parent);
                String artifact = URIUtil.getLocationName(grandParent);
                String groupId = URIUtil.relativize(this.root, URIUtil.getParentLocation(grandParent)).getPath().substring(1).replace("/", ".");
                if ((artifact + "-" + version + ".jar").equals(URIUtil.getLocationName(fl))) {
                    return MavenRepositoryURIResolver.make(groupId, artifact, version, "").getAuthority();
                }
                return null;
            }).filter(f -> f != null).toArray(String[]::new);
            return stringArray;
        }
    }

    @Override
    public String scheme() {
        return "mvn";
    }

    @Override
    public boolean supportsHost() {
        return false;
    }

    public static ISourceLocation make(String groupId, String artifactId, String version, String path) {
        return URIUtil.correctLocation("mvn", groupId + GROUP_ARTIFACT_VERSION_SEPARATOR + artifactId + GROUP_ARTIFACT_VERSION_SEPARATOR + version, path);
    }

    public static ISourceLocation mavenize(ISourceLocation loc) {
        try {
            boolean isFileInRepo;
            ISourceLocation nloc;
            ISourceLocation iSourceLocation = nloc = URIResolverRegistry.getInstance() != null ? URIResolverRegistry.getInstance().logicalToPhysical(loc) : loc;
            if (!URIUtil.getExtension(nloc).equals("jar")) {
                return loc;
            }
            ISourceLocation repo = MavenRepositoryURIResolver.inferMavenRepositoryLocation();
            ISourceLocation relative = URIUtil.relativize(repo, nloc);
            boolean bl = isFileInRepo = nloc.getScheme().equals("file") && relative.getScheme().equals("relative");
            if (isFileInRepo) {
                relative = URIUtil.getParentLocation(relative);
                String version = URIUtil.getLocationName(relative);
                relative = URIUtil.getParentLocation(relative);
                String artifactId = URIUtil.getLocationName(relative);
                relative = URIUtil.getParentLocation(relative);
                String groupId = relative.getPath().substring(1).replace("/", ".");
                return MavenRepositoryURIResolver.make(groupId, artifactId, version, "");
            }
            return loc;
        }
        catch (IOException | URISyntaxException e) {
            return loc;
        }
    }
}

