/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class ListClassLoader
extends ClassLoader {
    private final List<ClassLoader> path;
    private final Stack<String> stack = new Stack();

    public ListClassLoader(List<ClassLoader> path, ClassLoader parent) {
        super(parent);
        this.path = Collections.unmodifiableList(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.stack.contains(name)) {
            return null;
        }
        for (ClassLoader l : this.path) {
            try {
                this.stack.push(name);
                Class<?> clazz = l.loadClass(name);
                return clazz;
            }
            catch (ClassNotFoundException e) {}
            continue;
            finally {
                this.stack.pop();
            }
        }
        return null;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader l : this.path) {
            try {
                return l.loadClass(name);
            }
            catch (ClassNotFoundException e) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader l : this.path) {
            URL url = l.getResource(name);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        final ArrayList<URL> result = new ArrayList<URL>(this.path.size());
        for (ClassLoader l : this.path) {
            Enumeration<URL> e = l.getResources(name);
            while (e.hasMoreElements()) {
                result.add(e.nextElement());
            }
        }
        return new Enumeration<URL>(){
            final Iterator<URL> it;
            {
                this.it = result.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.it.hasNext();
            }

            @Override
            public URL nextElement() {
                return this.it.next();
            }
        };
    }
}

