---
title: "module Message"
id: Message
slug: /Library//Message
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

Provides the `Message` datatype that represents error messages and warnings.
#### Usage

```rascal
import Message;
```

#### Dependencies
```rascal
import IO;
```

#### Description


Messages can be used to communicate information about source texts.
They can be interpreted by IDEs to display type errors and warnings, etc.

`Message`s are, for instance, used as additional keyword fields of
other data types (syntax trees), or collected in sets or lists of errors to 
be published in an IDE. See [IDEServices](..//Library/util/IDEServices.md).


## data Message {#Message-Message}
Symbolic representation of UI-facing error messages.

```rascal
data Message (list[Message] causes=[]) 
     = error(str msg, loc at)
     | warning(str msg, loc at)
     | info(str msg, loc at)
     ;
```


A `Message` or a `list[Message]` is typically produced by language processors such as
parsers, type checkers, static analyzers, etc. The Message data type is a simple contract between
these producers and the consumers of the messages (typically terminals, editors and IDE's).

* The severity of an error is encoded in the constructor name: error, warning or info.
* The `msg` field is a UI-facing string that describes why something was hard or impossible to process.
* The `at` field points at the source code that was identified as a primary cause of a problem.
* The optional `causes` lists secondary causes via recursion. Each of the causes is a _conjunctive_
cause of the primary issue. This means that if hypothetically at least one of them was resolved, the primary issue
would also be resolved.

#### Benefits


* The Message data type has consumers on the terminal, in editors and in the IDE. One uniform format
for all user environments. This makes error producing tools reusable in different contexts without adaptation.

#### Pitfalls


* One of the error constructors misses an `at` field. This constructor is _deprecated_. Error messages without
source locations are not useful in any UI context. 

## function write {#Message-write}

Call the standard message pretty-printing and sorting code, writing the result to a string

```rascal
str write(list[Message] messages, loc projectRoot=|unknown:///|)
```

## function mainMessageHandler {#Message-mainMessageHandler}

Reusable message handler for commandline `main` functions

```rascal
int mainMessageHandler(list[Message] messages, loc projectRoot = |unknown:///|, bool errorsAsWarnings = false, bool warningsAsErrors = false)
```


This function takes care of some typical responsibilities of `main` functions:
* return an `int` to signal failure (!= 0) or success (0).
* print the collected and sorted error messages to stdout.
* implement the errorsAsWarnings feature.
* implement the warningsAsErrors feature.

With `errorsAsWarnings` we do not fail while we are still developing experimental code. The process
of testing and deployment may continue even if (fatal) errors were detected.

With `warningsAsErrors` we can signal a higher level of stability and compliance than the default.
Every new warnings will lead to a failing build, making sure that new issues can not creep in anymore.

#### Benefits


* consistent error handling between different `main` functions
* consistent error printing
* consistent interpretation of errorsAsWarnings and warningsAsErrors

#### Pitfalls


* stdout is used to print the messages; no further processing is possible.
* have to remember to return the result of this function as the return value of `main`

