---
title: "module lang::std::ASCII"
id: ASCII
slug: /Library/lang/std/ASCII
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

Character classes commonly known in the ASCII set
#### Usage

```rascal
import lang::std::ASCII;
```




## syntax Ascii {#lang-std-ASCII-Ascii}

```rascal
lexical Ascii = [\a00-\a7f];
```

## syntax Alnum {#lang-std-ASCII-Alnum}

```rascal
lexical Alnum = [A-Z a-z 0-9];
```

## syntax Alpha {#lang-std-ASCII-Alpha}

```rascal
lexical Alpha = [A-Z a-z];
```

## syntax Upper {#lang-std-ASCII-Upper}

```rascal
lexical Upper = [A-Z];
```

## syntax Lower {#lang-std-ASCII-Lower}

```rascal
lexical Lower = [a-z];
```

## syntax Blank {#lang-std-ASCII-Blank}

```rascal
lexical Blank = [\ \t];
```

## syntax Ctrl {#lang-std-ASCII-Ctrl}

```rascal
lexical Ctrl = [\a00-\a1f \a7f];
```

## syntax Digit {#lang-std-ASCII-Digit}

```rascal
lexical Digit = [0-9];
```

## syntax Graph {#lang-std-ASCII-Graph}

```rascal
lexical Graph = [~-!];
```

## syntax HexNumber {#lang-std-ASCII-HexNumber}

```rascal
lexical HexNumber = [A-F a-f 0-9];
```

## syntax Print {#lang-std-ASCII-Print}

```rascal
lexical Print = [\ ~-!];
```

## syntax Punt {#lang-std-ASCII-Punt}

```rascal
lexical Punt = [!-/ :-@ \[-~];
```

## syntax Space {#lang-std-ASCII-Space}

```rascal
lexical Space = [\t \n \a0B \a0C \r \ ];
```

