/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang;

import io.usethesource.vallang.IValue;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.visitors.IValueVisitor;

public interface ITuple
extends Iterable<IValue>,
IValue {
    @Override
    default public int getMatchFingerprint() {
        return 110725064 + this.arity();
    }

    public IValue get(int var1);

    @Deprecated
    public IValue get(String var1);

    public ITuple set(int var1, IValue var2);

    @Deprecated
    public ITuple set(String var1, IValue var2);

    public int arity();

    public IValue select(int ... var1) throws IndexOutOfBoundsException;

    @Deprecated
    public IValue selectByFieldNames(String ... var1) throws FactTypeUseException;

    @Override
    default public boolean match(IValue o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof ITuple) {
            ITuple peer = (ITuple)o;
            if (this.getType() != peer.getType()) {
                return false;
            }
            int arity = this.arity();
            if (arity != peer.arity()) {
                return false;
            }
            for (int i = 0; i < arity; ++i) {
                if (this.get(i).match(peer.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    default public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
        return v.visitTuple(this);
    }
}

