/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.impl.persistent;

import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class Tuple
implements ITuple {
    protected static final TypeFactory typeFactory = TypeFactory.getInstance();
    private @MonotonicNonNull Type cachedTupleType;
    protected final IValue[] elements;
    private static final ITuple EMPTY_TUPLE = new Tuple(new IValue[0]);

    public static ITuple newTuple(IValue ... elements) {
        if (elements.length == 0) {
            return EMPTY_TUPLE;
        }
        return new Tuple(elements);
    }

    private Tuple(IValue ... elements) {
        this.elements = elements;
    }

    @Override
    public Type getType() {
        if (this.cachedTupleType == null) {
            this.cachedTupleType = TypeFactory.getInstance().tupleType(this.elements);
        }
        return this.cachedTupleType;
    }

    @Override
    public int arity() {
        return this.elements.length;
    }

    @Override
    public IValue get(int i) {
        return this.elements[i];
    }

    @Override
    public IValue get(String label) {
        return this.elements[this.getType().getFieldIndex(label)];
    }

    @Override
    public Iterator<IValue> iterator() {
        return new TupleIterator(this);
    }

    @Override
    public <T, E extends Throwable> T accept(IValueVisitor<T, E> v) throws E {
        return v.visitTuple(this);
    }

    @Override
    public ITuple set(int index, IValue arg) {
        int nrOfElements = this.elements.length;
        IValue[] newElements = new IValue[nrOfElements];
        Type[] elementTypes = new Type[nrOfElements];
        for (int i = nrOfElements - 1; i >= 0; --i) {
            IValue element;
            newElements[i] = element = this.elements[i];
            elementTypes[i] = element.getType();
        }
        newElements[index] = arg;
        elementTypes[index] = arg.getType();
        return new Tuple(newElements);
    }

    @Override
    public ITuple set(String label, IValue arg) {
        int nrOfElements = this.elements.length;
        IValue[] newElements = new IValue[nrOfElements];
        Type[] elementTypes = new Type[nrOfElements];
        for (int i = nrOfElements - 1; i >= 0; --i) {
            IValue element;
            newElements[i] = element = this.elements[i];
            elementTypes[i] = element.getType();
        }
        newElements[this.getType().getFieldIndex((String)label)] = arg;
        elementTypes[this.getType().getFieldIndex((String)label)] = arg.getType();
        return new Tuple(newElements);
    }

    @Override
    public IValue select(int ... indexes) {
        if (indexes.length == 1) {
            return this.get(indexes[0]);
        }
        int nrOfElements = indexes.length;
        IValue[] elements = new IValue[nrOfElements];
        Type[] elementTypes = new Type[nrOfElements];
        for (int i = nrOfElements - 1; i >= 0; --i) {
            IValue element;
            elements[i] = element = this.get(indexes[i]);
            elementTypes[i] = element.getType();
        }
        return new Tuple(elements);
    }

    @Override
    public IValue selectByFieldNames(String ... fields) {
        if (fields.length == 1) {
            return this.get(fields[0]);
        }
        int nrOfElements = fields.length;
        IValue[] elements = new IValue[nrOfElements];
        Type[] elementTypes = new Type[nrOfElements];
        for (int i = nrOfElements - 1; i >= 0; --i) {
            IValue element;
            elements[i] = element = this.get(fields[i]);
            elementTypes[i] = element.getType();
        }
        return new Tuple(elements);
    }

    @Override
    public String toString() {
        return this.defaultToString();
    }

    public int hashCode() {
        int hash = 1331;
        for (int i = this.elements.length - 1; i >= 0; --i) {
            hash -= (hash << 19) + (hash >>> 8);
            hash ^= this.elements[i].hashCode();
        }
        return hash - (hash << 7);
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            Tuple otherTuple = (Tuple)o;
            IValue[] otherElements = otherTuple.elements;
            int nrOfElements = this.elements.length;
            if (otherElements.length == nrOfElements) {
                for (int i = nrOfElements - 1; i >= 0; --i) {
                    if (otherElements[i].equals(this.elements[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean match(IValue value) {
        if (value == this) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (value instanceof Tuple) {
            Tuple otherTuple = (Tuple)value;
            if (this.getType() != otherTuple.getType()) {
                return false;
            }
            IValue[] otherElements = otherTuple.elements;
            int nrOfElements = this.elements.length;
            if (otherElements.length == nrOfElements) {
                for (int i = nrOfElements - 1; i >= 0; --i) {
                    if (otherElements[i].match(this.elements[i])) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    private static class TupleIterator
    implements Iterator<IValue> {
        private final IValue[] elements;
        private int index = 0;

        public TupleIterator(Tuple tuple) {
            this.elements = tuple.elements;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.elements.length;
        }

        @Override
        public IValue next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more elements in this iteration.");
            }
            return this.elements[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator doesn't support removal.");
        }
    }
}

