/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.io.binary.util;

import io.usethesource.vallang.io.binary.util.TrackLastWritten;
import java.util.LinkedHashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MapLastWritten<T>
implements TrackLastWritten<T> {
    private final Map<IdentityWrapper<T>, Long> lookupData;
    private long written;

    public MapLastWritten(final int size) {
        this.lookupData = new LinkedHashMap<IdentityWrapper<T>, Long>(size + 1, 1.0f, false){

            @Override
            protected boolean removeEldestEntry(Map.Entry<IdentityWrapper<T>, Long> eldest) {
                return super.size() > size;
            }
        };
        this.written = 0L;
    }

    @Override
    public int howLongAgo(T obj) {
        Long writtenAt = this.lookupData.get(new IdentityWrapper<T>(obj));
        if (writtenAt != null) {
            return (int)(this.written - writtenAt - 1L);
        }
        return -1;
    }

    @Override
    public void write(T obj) {
        this.lookupData.put(new IdentityWrapper<T>(obj), this.written++);
    }

    public static class IdentityWrapper<T> {
        private final T wrapped;
        private final int hashCode;

        public IdentityWrapper(T wrapped) {
            this.wrapped = wrapped;
            this.hashCode = System.identityHashCode(wrapped);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(@Nullable Object obj) {
            return obj != null && this.getClass().equals(obj.getClass()) && ((IdentityWrapper)obj).wrapped == this.wrapped;
        }
    }
}

