/*
 * Decompiled with CFR 0.152.
 */
package io.usethesource.vallang.type;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.exceptions.FactTypeUseException;
import io.usethesource.vallang.exceptions.IllegalOperationException;
import io.usethesource.vallang.type.DefaultSubtypeOfValue;
import io.usethesource.vallang.type.ITypeVisitor;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;

class TupleType
extends DefaultSubtypeOfValue {
    final Type[] fFieldTypes;
    protected int fHashcode = -1;

    TupleType(Type[] fieldTypes) {
        this.fFieldTypes = fieldTypes;
    }

    @Override
    public TypeFactory.TypeReifier getTypeReifier(TypeFactory.TypeValues symbols) {
        return new Info(symbols);
    }

    @Override
    public boolean isFixedWidth() {
        return true;
    }

    @Override
    public Type getFieldType(int i) {
        return this.fFieldTypes[i];
    }

    @Override
    public int getArity() {
        return this.fFieldTypes.length;
    }

    @Override
    public Type compose(Type other) {
        if (other.equivalent(TF.voidType())) {
            return other;
        }
        if (this.getArity() != 2 || other.getArity() != 2) {
            throw new IllegalOperationException("compose", this, other);
        }
        if (!this.getFieldType(1).comparable(other.getFieldType(0))) {
            return TF.voidType();
        }
        return TF.tupleType(this.getFieldType(0), other.getFieldType(1));
    }

    @Override
    public Type carrier() {
        Type lub = TypeFactory.getInstance().voidType();
        for (Type field : this) {
            lub = lub.lub(field);
        }
        return TypeFactory.getInstance().setType(lub);
    }

    @Override
    public Type getFieldTypes() {
        return this;
    }

    @Override
    public String[] getFieldNames() {
        return new String[0];
    }

    @Override
    public Type closure() {
        if (this.getArity() == 2) {
            Type lub = this.fFieldTypes[0].lub(this.fFieldTypes[1]);
            return TF.tupleType(lub, lub);
        }
        return super.closure();
    }

    static Type lubTupleTypes(Type t1, Type t2) {
        int N2 = t1.getArity();
        Type[] fieldTypes = new Type[N2];
        for (int i = 0; i < N2; ++i) {
            fieldTypes[i] = t1.getFieldType(i).lub(t2.getFieldType(i));
        }
        return TypeFactory.getInstance().tupleType(fieldTypes);
    }

    static Type glbTupleTypes(Type t1, Type t2) {
        int N2 = t1.getArity();
        Type[] fieldTypes = new Type[N2];
        for (int i = 0; i < N2; ++i) {
            fieldTypes[i] = t1.getFieldType(i).glb(t2.getFieldType(i));
        }
        return TypeFactory.getInstance().tupleType(fieldTypes);
    }

    @Override
    public boolean hasFieldNames() {
        return false;
    }

    @Override
    public boolean hasField(String fieldName) {
        return false;
    }

    @Override
    public int hashCode() {
        int h2 = this.fHashcode;
        if (h2 == -1) {
            h2 = 55501;
            for (Type elemType : this.fFieldTypes) {
                h2 = h2 * 44927 + elemType.hashCode();
            }
            this.fHashcode = h2;
        }
        return h2;
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        TupleType other = (TupleType)obj;
        if (this.fFieldTypes.length != other.fFieldTypes.length) {
            return false;
        }
        for (int i = this.fFieldTypes.length - 1; i >= 0; --i) {
            if (this.fFieldTypes[i] == other.fFieldTypes[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("tuple[");
        int idx = 0;
        for (Type elemType : this.fFieldTypes) {
            if (idx++ > 0) {
                sb.append(",");
            }
            sb.append(elemType.toString());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Iterator<Type> iterator() {
        return new Iterator<Type>(){
            private int cursor = 0;

            @Override
            public boolean hasNext() {
                return this.cursor < TupleType.this.fFieldTypes.length;
            }

            @Override
            public Type next() {
                return TupleType.this.fFieldTypes[this.cursor++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public <T, E extends Throwable> T accept(ITypeVisitor<T, E> visitor) throws E {
        return visitor.visitTuple(this);
    }

    @Override
    protected boolean isSupertypeOf(Type type) {
        return type.isSubtypeOfTuple(this);
    }

    @Override
    public Type lub(Type other) {
        return other.lubWithTuple(this);
    }

    @Override
    public Type glb(Type type) {
        return type.glbWithTuple(this);
    }

    @Override
    public boolean intersects(Type other) {
        return other.intersectsWithTuple(this);
    }

    @Override
    protected boolean intersectsWithTuple(Type type) {
        int N2 = this.getArity();
        if (N2 != type.getArity()) {
            return false;
        }
        for (int i = 0; i < N2; ++i) {
            if (this.getFieldType(i).intersects(type.getFieldType(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isSubtypeOfTuple(Type type) {
        if (this.getArity() == type.getArity()) {
            for (int i = 0; i < this.getArity(); ++i) {
                if (this.getFieldType(i).isSubtypeOf(type.getFieldType(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    protected boolean isSubtypeOfVoid(Type type) {
        if (this.isOpen()) {
            for (Type elem : this) {
                if (!elem.isSubtypeOfVoid(type)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected Type lubWithTuple(Type type) {
        if (this.getArity() == type.getArity()) {
            return TupleType.lubTupleTypes(this, type);
        }
        return TF.valueType();
    }

    @Override
    protected Type glbWithTuple(Type type) {
        if (this.getArity() == type.getArity()) {
            return TupleType.glbTupleTypes(this, type);
        }
        return TF.voidType();
    }

    @Override
    public boolean isOpen() {
        for (Type arg : this.fFieldTypes) {
            if (!arg.isOpen()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean match(Type matched, Map<Type, Type> bindings) throws FactTypeUseException {
        if (!super.match(matched, bindings)) {
            return false;
        }
        if (matched.isTuple() || matched.isAliased() && matched.getAliased().isTuple() || matched.isBottom()) {
            for (int i = this.getArity() - 1; i >= 0; --i) {
                if (this.getFieldType(i).match(matched.getFieldType(i), bindings)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Type instantiate(Map<Type, Type> bindings) {
        Type[] fChildren = new Type[this.getArity()];
        for (int i = fChildren.length - 1; i >= 0; --i) {
            fChildren[i] = this.getFieldType(i).instantiate(bindings);
        }
        return TypeFactory.getInstance().tupleType(fChildren);
    }

    @Override
    public Type select(int ... fields) {
        int width = fields.length;
        if (width == 0) {
            return TypeFactory.getInstance().voidType();
        }
        if (width == 1) {
            return this.getFieldType(fields[0]);
        }
        Type[] fieldTypes = new Type[width];
        for (int i = width - 1; i >= 0; --i) {
            fieldTypes[i] = this.getFieldType(fields[i]);
        }
        return TypeFactory.getInstance().tupleType(fieldTypes);
    }

    @Override
    public IValue randomValue(Random random, TypeFactory.RandomTypesConfig typesConfig, IValueFactory vf, TypeStore store, Map<Type, Type> typeParameters, int maxDepth, int maxWidth) {
        IValue[] elems = new IValue[this.getArity()];
        for (int i = 0; i < elems.length; ++i) {
            assert (!this.getFieldType(i).isBottom()) : "field " + i + " has illegal type void";
            elems[i] = this.getFieldType(i).randomValue(random, typesConfig, vf, store, typeParameters, maxDepth - 1, maxWidth);
        }
        ITuple done = vf.tuple(elems);
        this.match(done.getType(), typeParameters);
        return done;
    }

    @Override
    public boolean isTuple() {
        return true;
    }

    public static class Info
    extends TypeFactory.TypeReifier {
        public Info(TypeFactory.TypeValues symbols) {
            super(symbols);
        }

        @Override
        public Type getSymbolConstructorType() {
            return this.symbols().typeSymbolConstructor("tuple", Type.TF.listType(this.symbols().symbolADT()), "symbols");
        }

        @Override
        public Type fromSymbol(IConstructor symbol, TypeStore store, Function<IConstructor, Set<IConstructor>> grammar) {
            return this.symbols().fromSymbols((IList)symbol.get("symbols"), store, grammar);
        }

        @Override
        public IConstructor toSymbol(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            IListWriter w = vf.listWriter();
            if (type.hasFieldNames()) {
                for (int i = 0; i < type.getArity(); ++i) {
                    w.append(this.symbols().labelSymbol(vf, type.getFieldType(i).asSymbol(vf, store, grammar, done), type.getFieldName(i)));
                }
            } else {
                for (Type f : type) {
                    w.append(f.asSymbol(vf, store, grammar, done));
                }
            }
            return vf.constructor(this.getSymbolConstructorType(), new IValue[]{w.done()});
        }

        @Override
        public void asProductions(Type type, IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            for (Type f : type) {
                f.asProductions(vf, store, grammar, done);
            }
        }

        @Override
        public boolean isRecursive() {
            return true;
        }

        @Override
        public Type randomInstance(BiFunction<TypeStore, TypeFactory.RandomTypesConfig, Type> next, TypeStore store, TypeFactory.RandomTypesConfig rnd) {
            return this.randomInstance(next, store, rnd, rnd.nextInt(rnd.getMaxDepth() + 1));
        }

        Type randomInstance(BiFunction<TypeStore, TypeFactory.RandomTypesConfig, Type> next, TypeStore store, TypeFactory.RandomTypesConfig rnd, int arity) {
            Type[] types = new Type[arity];
            for (int i = 0; i < arity; ++i) {
                while ((types[i] = next.apply(store, rnd)).isBottom()) {
                }
            }
            if (!rnd.isWithTupleFieldNames() || rnd.nextBoolean()) {
                return this.tf().tupleType(types);
            }
            String[] labels = new String[arity];
            for (int i = 0; i < arity; ++i) {
                labels[i] = this.randomLabel(rnd);
            }
            return this.tf().tupleType(types, labels);
        }
    }
}

