/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.lang.yaml;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IDateTime;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.IMapWriter;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.rascalmpl.exceptions.ImplementationError;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.library.lang.yaml.YAMLTypeFactory;
import org.rascalmpl.types.TypeReifier;
import org.yaml.snakeyaml.Yaml;

public class RascalYAML {
    private static final String ANCHOR_ANNO = "anchor";
    private final IValueFactory values;
    private final TypeReifier reifier;
    private final TypeStore definitions;
    private static final TypeFactory tf = TypeFactory.getInstance();

    public RascalYAML(IValueFactory values, TypeStore definitions) {
        this.values = values;
        this.reifier = new TypeReifier(values);
        this.definitions = definitions;
    }

    public IConstructor loadYAML(IString src) {
        Yaml yaml = new Yaml();
        Object obj = yaml.load(src.getValue());
        if (obj == null) {
            throw RuntimeExceptionFactory.illegalArgument(src, null, null);
        }
        IdentityHashMap<Object, Integer> anchors = new IdentityHashMap<Object, Integer>();
        this.computeAnchors(obj, anchors, 0);
        return this.loadRec(obj, anchors, new IdentityHashMap<Object, Boolean>());
    }

    private int computeAnchors(Object obj, IdentityHashMap<Object, Integer> anchors, int a) {
        block5: {
            block6: {
                block4: {
                    if (anchors.containsKey(obj)) {
                        anchors.put(obj, a);
                        return a + 1;
                    }
                    anchors.put(obj, -1);
                    if (!(obj instanceof Object[])) break block4;
                    for (Object elt : (Object[])obj) {
                        a = this.computeAnchors(elt, anchors, a);
                    }
                    break block5;
                }
                if (!(obj instanceof List)) break block6;
                for (Object elt : (List)obj) {
                    a = this.computeAnchors(elt, anchors, a);
                }
                break block5;
            }
            if (!(obj instanceof Map)) break block5;
            Map m4 = (Map)obj;
            for (Map.Entry e : m4.entrySet()) {
                a = this.computeAnchors(e.getKey(), anchors, a);
                a = this.computeAnchors(e.getValue(), anchors, a);
            }
        }
        return a;
    }

    private IConstructor loadRec(Object obj, IdentityHashMap<Object, Integer> anchors, IdentityHashMap<Object, Boolean> visited) {
        IConstructor result;
        IMap empty = (IMap)this.values.mapWriter().done();
        if (obj instanceof Integer) {
            return this.values.constructor(YAMLTypeFactory.Node_scalar, this.values.integer((Integer)obj)).asWithKeywordParameters().setParameter("tag", this.reifier.typeToValue(tf.integerType(), this.definitions, empty));
        }
        if (obj instanceof Long) {
            return this.values.constructor(YAMLTypeFactory.Node_scalar, this.values.integer((Long)obj)).asWithKeywordParameters().setParameter("tag", this.reifier.typeToValue(tf.integerType(), this.definitions, empty));
        }
        if (obj instanceof Double) {
            return this.values.constructor(YAMLTypeFactory.Node_scalar, this.values.real((Double)obj)).asWithKeywordParameters().setParameter("tag", this.reifier.typeToValue(tf.realType(), this.definitions, empty));
        }
        if (obj instanceof Float) {
            return this.values.constructor(YAMLTypeFactory.Node_scalar, this.values.real(((Float)obj).floatValue())).asWithKeywordParameters().setParameter("tag", this.reifier.typeToValue(tf.realType(), this.definitions, empty));
        }
        if (obj instanceof String) {
            return this.values.constructor(YAMLTypeFactory.Node_scalar, this.values.string((String)obj)).asWithKeywordParameters().setParameter("tag", this.reifier.typeToValue(tf.stringType(), this.definitions, empty));
        }
        if (obj instanceof Boolean) {
            return this.values.constructor(YAMLTypeFactory.Node_scalar, this.values.bool((Boolean)obj)).asWithKeywordParameters().setParameter("tag", this.reifier.typeToValue(tf.boolType(), this.definitions, empty));
        }
        if (obj instanceof Date) {
            return this.values.constructor(YAMLTypeFactory.Node_scalar, this.values.datetime(((Date)obj).getTime())).asWithKeywordParameters().setParameter("tag", this.reifier.typeToValue(tf.dateTimeType(), this.definitions, empty));
        }
        if (obj instanceof URI) {
            return this.values.constructor(YAMLTypeFactory.Node_scalar, this.values.sourceLocation((URI)obj)).asWithKeywordParameters().setParameter("tag", this.reifier.typeToValue(tf.sourceLocationType(), this.definitions, empty));
        }
        if (visited.containsKey(obj)) {
            assert (anchors.get(obj) != -1);
            return this.values.constructor(YAMLTypeFactory.Node_reference).asWithKeywordParameters().setParameter(ANCHOR_ANNO, this.values.integer(anchors.get(obj)));
        }
        visited.put(obj, true);
        if (obj instanceof Object[]) {
            IListWriter w = this.values.listWriter();
            for (Object elt : (Object[])obj) {
                w.append(this.loadRec(elt, anchors, visited));
            }
            result = this.values.constructor(YAMLTypeFactory.Node_sequence, new IValue[]{w.done()});
        } else if (obj instanceof List) {
            IListWriter w = this.values.listWriter();
            for (Object elt : (List)obj) {
                w.append(this.loadRec(elt, anchors, visited));
            }
            result = this.values.constructor(YAMLTypeFactory.Node_sequence, new IValue[]{w.done()});
        } else if (obj instanceof Map) {
            IMapWriter w = this.values.mapWriter();
            Map m4 = (Map)obj;
            for (Map.Entry e : m4.entrySet()) {
                w.put(this.loadRec(e.getKey(), anchors, visited), this.loadRec(e.getValue(), anchors, visited));
            }
            result = this.values.constructor(YAMLTypeFactory.Node_mapping, new IValue[]{w.done()});
        } else {
            if (obj == null) {
                throw RuntimeExceptionFactory.illegalTypeArgument(this.values.string("missing input"));
            }
            throw RuntimeExceptionFactory.illegalArgument(this.values.string(obj.toString() + " (class=" + obj.getClass() + ")"));
        }
        if (anchors.get(obj) != -1) {
            result = result.asWithKeywordParameters().setParameter(ANCHOR_ANNO, this.values.integer(anchors.get(obj)));
        }
        return result;
    }

    public IString dumpYAML(IConstructor yaml) {
        HashMap<Integer, Object> visited = new HashMap<Integer, Object>();
        Object obj = this.dumpYAMLrec(yaml, visited);
        Yaml y = new Yaml();
        return this.values.string(y.dump(obj));
    }

    private Object dumpYAMLrec(IConstructor yaml, Map<Integer, Object> visited) {
        if (yaml.getConstructorType() == YAMLTypeFactory.Node_reference) {
            int id = ((IInteger)yaml.get(0)).intValue();
            if (!visited.containsKey(id)) {
                throw RuntimeExceptionFactory.indexOutOfBounds(this.values.integer(id), null, null);
            }
            return visited.get(id);
        }
        if (yaml.getConstructorType() == YAMLTypeFactory.Node_scalar) {
            IValue value = yaml.get(0);
            if (value.getType() == tf.integerType()) {
                return new Integer(((IInteger)value).intValue());
            }
            if (value.getType() == tf.realType()) {
                return new Double(((IReal)value).doubleValue());
            }
            if (value.getType() == tf.stringType()) {
                return new String(((IString)value).getValue());
            }
            if (value.getType() == tf.boolType()) {
                return new Boolean(((IBool)value).getValue());
            }
            if (value.getType() == tf.dateTimeType()) {
                return new Date(((IDateTime)value).getInstant());
            }
            if (value.getType() == tf.sourceLocationType()) {
                return ((ISourceLocation)value).getURI();
            }
            throw RuntimeExceptionFactory.illegalArgument(yaml, null, null);
        }
        if (yaml.getConstructorType() == YAMLTypeFactory.Node_sequence) {
            ArrayList<Object> l = new ArrayList<Object>();
            if (yaml.asWithKeywordParameters().hasParameter(ANCHOR_ANNO)) {
                visited.put(((IInteger)yaml.asWithKeywordParameters().getParameter(ANCHOR_ANNO)).intValue(), l);
            }
            for (IValue v : (IList)yaml.get(0)) {
                l.add(this.dumpYAMLrec((IConstructor)v, visited));
            }
            return l;
        }
        if (yaml.getConstructorType() == YAMLTypeFactory.Node_mapping) {
            IdentityHashMap<Object, Object> m4 = new IdentityHashMap<Object, Object>();
            if (yaml.asWithKeywordParameters().hasParameter(ANCHOR_ANNO)) {
                visited.put(((IInteger)yaml.asWithKeywordParameters().getParameter(ANCHOR_ANNO)).intValue(), m4);
            }
            Iterator<Map.Entry<IValue, IValue>> iter = ((IMap)yaml.get(0)).entryIterator();
            while (iter.hasNext()) {
                Map.Entry<IValue, IValue> e = iter.next();
                m4.put(this.dumpYAMLrec((IConstructor)e.getKey(), visited), this.dumpYAMLrec((IConstructor)e.getValue(), visited));
            }
            return m4;
        }
        throw new ImplementationError("Invalid YAML data type: " + yaml);
    }
}

