/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.result;

import io.usethesource.vallang.IConstructor;
import java.net.URI;
import org.rascalmpl.parser.gtd.result.AbstractNode;
import org.rascalmpl.parser.gtd.result.struct.Link;
import org.rascalmpl.parser.gtd.util.ArrayList;
import org.rascalmpl.parser.util.DebugUtil;

public abstract class AbstractContainerNode<P>
extends AbstractNode {
    protected final URI input;
    protected final int offset;
    protected final int endOffset;
    protected final boolean isNullable;
    protected final boolean isSeparator;
    protected final boolean isLayout;
    protected Link firstAlternative;
    protected P firstProduction;
    protected ArrayList<Link> alternatives;
    protected ArrayList<P> productions;

    protected AbstractContainerNode(URI input, int offset, int endOffset, boolean isNullable, boolean isSeparator, boolean isLayout) {
        this.input = input;
        this.offset = offset;
        this.endOffset = endOffset;
        this.isNullable = isNullable;
        this.isSeparator = isSeparator;
        this.isLayout = isLayout;
    }

    public void addAlternative(P production, Link children) {
        if (this.firstAlternative == null) {
            this.firstAlternative = children;
            this.firstProduction = production;
        } else {
            if (this.alternatives == null) {
                this.alternatives = new ArrayList(1);
                this.productions = new ArrayList(1);
            }
            this.alternatives.add(children);
            this.productions.add(production);
        }
    }

    public URI getInput() {
        return this.input;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public boolean isEmpty() {
        return this.isNullable;
    }

    @Override
    public boolean isNonterminalSeparator() {
        return this.isSeparator;
    }

    public boolean isLayout() {
        return this.isLayout;
    }

    public P getFirstProduction() {
        return this.firstProduction;
    }

    public Link getFirstAlternative() {
        return this.firstAlternative;
    }

    public ArrayList<P> getAdditionalProductions() {
        return this.productions;
    }

    public ArrayList<Link> getAdditionalAlternatives() {
        return this.alternatives;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("offset=" + this.offset);
        builder.append(",endOffset=" + this.endOffset);
        if (this.isNullable) {
            builder.append(",nullable");
        }
        if (this.isSeparator) {
            builder.append(",separator");
        }
        if (this.isLayout) {
            builder.append(",layout");
        }
        if (this.firstAlternative != null) {
            builder.append(",");
            builder.append(DebugUtil.prodToString((IConstructor)this.firstProduction));
            if (this.productions != null) {
                for (int i = 0; i < this.productions.size(); ++i) {
                    builder.append(",");
                    builder.append(DebugUtil.prodToString((IConstructor)this.productions.get(i)));
                }
            }
            builder.append("]");
        }
        return builder.toString();
    }
}

