/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.parser.gtd.stack.filter.precede;

import org.rascalmpl.parser.gtd.location.PositionStore;
import org.rascalmpl.parser.gtd.stack.filter.IEnterFilter;

public class CharPrecedeRequirement
implements IEnterFilter {
    private final int[][] ranges;

    public CharPrecedeRequirement(int[][] ranges) {
        this.ranges = ranges;
    }

    @Override
    public boolean isFiltered(int[] input, int location, PositionStore positionStore) {
        if (location - 1 < 0) {
            return true;
        }
        int prev = input[location - 1];
        for (int i = this.ranges.length - 1; i >= 0; --i) {
            int[] range = this.ranges[i];
            if (prev < range[0] || prev > range[1]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEqual(IEnterFilter otherEnterFilter) {
        if (!(otherEnterFilter instanceof CharPrecedeRequirement)) {
            return false;
        }
        CharPrecedeRequirement otherCharPrecedeFilter = (CharPrecedeRequirement)otherEnterFilter;
        int[][] otherRanges = otherCharPrecedeFilter.ranges;
        block0: for (int i = this.ranges.length - 1; i >= 0; --i) {
            int[] range = this.ranges[i];
            for (int j = otherRanges.length - 1; j >= 0; --j) {
                int[] otherRange = otherRanges[j];
                if (range[0] == otherRange[0] && range[1] == otherRange[1]) continue block0;
            }
            return false;
        }
        return true;
    }
}

