/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jline.terminal.Terminal;
import org.jline.utils.InfoCmp;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.ast.OptionalEqualSign;
import org.rascalmpl.ast.OptionalTerminator;
import org.rascalmpl.ast.QualifiedName;
import org.rascalmpl.ast.ShellCommand;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.ideservices.IDEServices;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.control_exceptions.QuitException;
import org.rascalmpl.interpreter.env.ModuleEnvironment;
import org.rascalmpl.interpreter.env.Pair;
import org.rascalmpl.interpreter.result.AbstractFunction;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.utils.Names;
import org.rascalmpl.semantics.dynamic.QualifiedName;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public abstract class ShellCommand
extends org.rascalmpl.ast.ShellCommand {
    private static void setOption(IEvaluator<Result<IValue>> __eval, String name, String value) {
        switch (name) {
            case "rascal.generatorProfiling": {
                __eval.getConfiguration().setGeneratorProfiling(Boolean.parseBoolean(value));
                __eval.getParserGenerator().setGeneratorProfiling(Boolean.parseBoolean(value));
                break;
            }
            case "rascal.profiling": {
                __eval.getConfiguration().setProfiling(Boolean.parseBoolean(value));
                break;
            }
            case "rascal.errors": {
                __eval.getConfiguration().setErrors(Boolean.parseBoolean(value));
                break;
            }
            case "rascal.tracing": {
                __eval.getConfiguration().setTracing(Boolean.parseBoolean(value));
                break;
            }
            case "rascal.debugging": {
                __eval.getConfiguration().setDebugging(Boolean.parseBoolean(value));
            }
        }
        __eval.updateProperties();
    }

    public ShellCommand(ISourceLocation __param1, IConstructor tree) {
        super(__param1, tree);
    }

    public static class Unextend
    extends ShellCommand.Unextend {
        public Unextend(ISourceLocation src, IConstructor node, QualifiedName name, OptionalTerminator terminator) {
            super(src, node, name, terminator);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.getOutPrinter().println(":unextend is not implemented.");
            return ResultFactory.nothing();
        }
    }

    public static class Unimport
    extends ShellCommand.Unimport {
        public Unimport(ISourceLocation __param1, IConstructor tree, QualifiedName __param2, OptionalTerminator term) {
            super(__param1, tree, __param2, term);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            ((ModuleEnvironment)__eval.getCurrentEnvt().getRoot()).unImport(Names.fullName(this.getName()));
            return ResultFactory.nothing();
        }
    }

    public static class Undeclare
    extends ShellCommand.Undeclare {
        public Undeclare(ISourceLocation src, IConstructor node, @Nullable QualifiedName optName, OptionalTerminator terminator) {
            super(src, node, optName, terminator);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> eval) {
            if (this.getOptName() == null) {
                eval.getCurrentModuleEnvironment().reset();
            } else {
                QualifiedName n = this.getOptName();
                if (Names.isQualified(n)) {
                    throw new IllegalArgumentException("name " + Names.fullName(n) + " should not be qualified for :undeclare");
                }
                String simpleName = Names.name(Names.lastName(n));
                ModuleEnvironment env = eval.getCurrentModuleEnvironment();
                env.unsetSimpleVariable(simpleName);
                env.unsetAllFunctions(simpleName);
                env.unsetConcreteSyntaxType(simpleName);
            }
            return Undeclare.nothing();
        }
    }

    public static class Test
    extends ShellCommand.Test {
        public Test(ISourceLocation __param1, IConstructor tree, QualifiedName mut, OptionalTerminator term) {
            super(__param1, tree, mut, term);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            Optional<String> name = this.getOptName() != null ? Optional.of(Names.fullName(this.getOptName())) : Optional.empty();
            return ResultFactory.makeResult(TF.boolType(), VF.bool(__eval.runTests(__eval.getMonitor(), name)), __eval);
        }
    }

    public static class SetOption
    extends ShellCommand.SetOption {
        public SetOption(ISourceLocation src, IConstructor node, QualifiedName name, OptionalEqualSign sign, Expression expression, OptionalTerminator terminator) {
            super(src, node, name, sign, expression, terminator);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            String name = "rascal." + ((QualifiedName.Default)this.getName()).fullName();
            String value = this.getExpression().interpret(__eval).getValue().toString();
            ShellCommand.setOption(__eval, name, value);
            return ResultFactory.nothing();
        }
    }

    public static class UnsetOptionTrue
    extends ShellCommand.UnsetOption {
        public UnsetOptionTrue(ISourceLocation src, IConstructor node, QualifiedName name, OptionalTerminator terminator) {
            super(src, node, name, terminator);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            String name = "rascal." + ((QualifiedName.Default)this.getName()).fullName();
            ShellCommand.setOption(__eval, name, "false");
            return ResultFactory.nothing();
        }
    }

    public static class SetOptionTrue
    extends ShellCommand.SetOptionTrue {
        public SetOptionTrue(ISourceLocation src, IConstructor node, QualifiedName name, OptionalTerminator terminator) {
            super(src, node, name, terminator);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            String name = "rascal." + ((QualifiedName.Default)this.getName()).fullName();
            ShellCommand.setOption(__eval, name, "true");
            return ResultFactory.nothing();
        }
    }

    public static class Quit
    extends ShellCommand.Quit {
        public Quit(ISourceLocation __param1, IConstructor tree, OptionalTerminator term) {
            super(__param1, tree, term);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            throw new QuitException();
        }
    }

    public static class ListDeclarations
    extends ShellCommand.ListDeclarations {
        public ListDeclarations(ISourceLocation __param1, IConstructor tree, OptionalTerminator term) {
            super(__param1, tree, term);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            ModuleEnvironment env = __eval.getCurrentModuleEnvironment();
            PrintWriter pr = __eval.getOutPrinter();
            if (!env.getVariables().isEmpty()) {
                pr.println("Variables:");
                Map<String, Result<IValue>> vars = env.getVariables();
                for (Map.Entry entry : vars.entrySet()) {
                    pr.println(((Result)entry.getValue()).getStaticType() + " " + (String)entry.getKey());
                }
            }
            if (!env.getFunctions().isEmpty()) {
                List<Pair<String, LinkedHashSet<AbstractFunction>>> functions = env.getFunctions();
                pr.println("Functions:");
                for (Pair pair : functions) {
                    pr.println((String)pair.getFirst() + ":");
                    for (AbstractFunction alt : (LinkedHashSet)pair.getSecond()) {
                        pr.println("   - " + alt.getHeader().replaceAll("\n", " "));
                    }
                }
            }
            if (!env.getAbstractDatatypes().isEmpty()) {
                Collection<Type> data = env.getAbstractDatatypes();
                pr.println("Data:");
                for (Type type : data) {
                    pr.println(type + ":");
                    env.getStore().getConstructors().stream().filter(c -> c.getAbstractDataType() == t2).forEach(cons -> pr.println("   - " + cons));
                }
            }
            if (!env.getProductions().isEmpty()) {
                Set<IValue> syntax = env.getProductions();
                pr.println("Syntax definitions:");
                for (IValue iValue : syntax) {
                    pr.println(TreeAdapter.yield((IConstructor)iValue));
                }
            }
            return ResultFactory.nothing();
        }
    }

    public static class History
    extends ShellCommand.History {
        public History(ISourceLocation __param1, IConstructor tree, OptionalTerminator term) {
            super(__param1, tree, term);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> eval) {
            eval.getErrorPrinter().println(":history command is not implemented here yet.");
            return History.nothing();
        }
    }

    public static class Help
    extends ShellCommand.Help {
        public Help(ISourceLocation __param1, IConstructor tree, OptionalTerminator term) {
            super(__param1, tree, term);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            __eval.setCurrentAST(this);
            __eval.printHelpMessage(__eval.getOutPrinter());
            return ResultFactory.nothing();
        }
    }

    public static class Clear
    extends ShellCommand.Clear {
        public Clear(ISourceLocation __param1, IConstructor tree, OptionalTerminator term) {
            super(__param1, tree, term);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            IRascalMonitor monitor = __eval.getMonitor();
            if (monitor instanceof IDEServices) {
                IDEServices services = (IDEServices)monitor;
                Terminal term = services.activeTerminal();
                if (term != null) {
                    term.puts(InfoCmp.Capability.clear_screen, new Object[0]);
                } else {
                    __eval.getErrorPrinter().println(":clear does not work for this context.");
                }
            } else {
                __eval.getErrorPrinter().println(":clear is not implemented in this context.");
            }
            return ResultFactory.nothing();
        }
    }

    public static class Edit
    extends ShellCommand.Edit {
        public Edit(ISourceLocation __param1, IConstructor tree, QualifiedName __param2, OptionalTerminator term) {
            super(__param1, tree, __param2, term);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> __eval) {
            IRascalMonitor monitor = __eval.getMonitor();
            if (monitor instanceof IDEServices) {
                IDEServices services = (IDEServices)monitor;
                String name = Names.fullName(this.getName());
                ISourceLocation uri = __eval.getRascalResolver().resolveModule(name);
                if (uri == null) {
                    __eval.getErrorPrinter().println("module " + name + " can not be found in the search path.");
                } else {
                    services.edit(uri);
                }
            } else {
                __eval.getErrorPrinter().println("The current Rascal execution environment does not know how to start an editor.");
            }
            return ResultFactory.nothing();
        }
    }
}

