/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.tasks;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IExternalValue;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import io.usethesource.vallang.type.ExternalType;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.type.TypeStore;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.tasks.FactFactory;
import org.rascalmpl.tasks.GraphBuilder;
import org.rascalmpl.tasks.IDependencyListener;
import org.rascalmpl.tasks.IExpirationListener;
import org.rascalmpl.tasks.IFact;
import org.rascalmpl.tasks.IFactFactory;
import org.rascalmpl.tasks.INameFormatter;
import org.rascalmpl.tasks.ITaskRegistry;
import org.rascalmpl.tasks.ITransaction;
import org.rascalmpl.tasks.Key;
import org.rascalmpl.tasks.PDBValueTaskRegistry;
import org.rascalmpl.tasks.facts.AbstractFact;

public class Transaction
implements ITransaction<Type, IValue, IValue>,
IExternalValue,
IExpirationListener<IValue> {
    public static final Type TransactionType = new ExternalType(){

        @Override
        protected boolean intersectsWithExternal(Type type) {
            return false;
        }

        @Override
        protected Type lubWithExternal(Type type) {
            return null;
        }

        @Override
        protected boolean isSubtypeOfExternal(Type type) {
            return false;
        }

        @Override
        protected Type glbWithExternal(Type type) {
            return null;
        }

        @Override
        public IConstructor asSymbol(IValueFactory vf, TypeStore store, ISetWriter grammar, Set<IConstructor> done) {
            return null;
        }

        @Override
        public Type asAbstractDataType() {
            return null;
        }

        @Override
        public IValue randomValue(Random random, TypeFactory.RandomTypesConfig typesConfig, IValueFactory vf, TypeStore store, Map<Type, Type> typeParameters, int maxDepth, int maxBreadth) {
            return null;
        }
    };
    private final Transaction parent;
    private final boolean commitEnabled;
    private final Map<Key, IFact<IValue>> map = new HashMap<Key, IFact<IValue>>();
    private final ITaskRegistry<Type, IValue, IValue> registry;
    private final Set<IFact<IValue>> deps = new HashSet<IFact<IValue>>();
    private final Set<Key> removed = new HashSet<Key>();
    private INameFormatter format;
    private final PrintWriter stderr;
    private Map<Type, Collection<IDependencyListener>> listeners = new HashMap<Type, Collection<IDependencyListener>>();

    public Transaction(PrintWriter stderr) {
        this(null, null, stderr, true);
    }

    public Transaction(INameFormatter format, PrintWriter stderr) {
        this(null, format, stderr, true);
    }

    public Transaction(Transaction parent, PrintWriter stderr) {
        this(parent, null, stderr, true);
    }

    public Transaction(Transaction parent, PrintWriter stderr, boolean commitEnabled) {
        this(parent, null, stderr, commitEnabled);
    }

    public Transaction(Transaction parent, INameFormatter format, PrintWriter stderr, boolean commitEnabled) {
        this.parent = parent;
        this.commitEnabled = commitEnabled;
        this.registry = parent != null ? parent.registry : PDBValueTaskRegistry.getRegistry();
        this.format = format == null && parent != null ? parent.format : format;
        this.stderr = stderr == null ? new PrintWriter(System.err) : stderr;
    }

    @Override
    public Type getType() {
        return TransactionType;
    }

    @Override
    public boolean match(IValue other) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IValue getFact(IRascalMonitor monitor, Type key, IValue name) {
        IFact<IValue> fact = null;
        try {
            boolean status = false;
            Transaction transaction = this;
            synchronized (transaction) {
                IValue value;
                Key k = new Key(key, name);
                fact = this.query(k);
                if (fact != null && (value = fact.getValue()) != null) {
                    this.deps.add(fact);
                    return value;
                }
                String JOB = "Producing fact " + this.formatKey(key, name);
                monitor.jobStart(JOB);
                Transaction tr = new Transaction(this, this.stderr, true);
                status = this.registry.produce(monitor, tr, key, name);
                monitor.jobEnd(JOB, true);
                fact = tr.map.get(k);
                if (fact != null) {
                    tr.commit();
                    this.deps.add(fact);
                }
            }
            if (fact != null) {
                return fact.getValue();
            }
            System.err.println("ERROR: failed to produce fact: " + this.formatKey(key, name) + "." + (status ? "" : " (producer was not authorative)"));
            return null;
        }
        catch (RuntimeException t2) {
            t2.printStackTrace();
            throw t2;
        }
    }

    @Override
    public IValue queryFact(Type key, IValue name) {
        Key k = new Key(key, name);
        IFact<IValue> fact = this.query(k);
        if (fact != null) {
            return fact.getValue();
        }
        return null;
    }

    protected IFact<IValue> query(Key k) {
        IFact<IValue> fact = this.map.get(k);
        if (fact == null && this.parent != null) {
            return this.parent.query(k);
        }
        return fact;
    }

    @Override
    public synchronized void removeFact(Type key, IValue name) {
        Key k = new Key(key, name);
        IFact<IValue> fact = this.map.get(k);
        this.map.remove(k);
        if (fact != null) {
            this.notifyListeners(key, fact, IDependencyListener.Change.REMOVED);
            fact.remove();
            this.deps.remove(fact);
            this.removed.add(k);
        }
    }

    public synchronized void removeFact(IFact<IValue> fact) {
        this.removeFact(((Key)fact.getKey()).type, ((Key)fact.getKey()).name);
    }

    @Override
    public synchronized IFact<IValue> setFact(Type key, IValue name, IValue value) {
        return this.setFact(key, name, value, (Collection<IFact<IValue>>)null, FactFactory.getInstance());
    }

    @Override
    public synchronized IFact<IValue> setFact(Type key, IValue name, IValue value, Collection<IFact<IValue>> dependencies) {
        return this.setFact(key, name, value, dependencies, FactFactory.getInstance());
    }

    @Override
    public synchronized IFact<IValue> setFact(Type key, IValue name, IFact<IValue> fact) {
        Key k = new Key(key, name);
        IFact<IValue> oldFact = this.map.get(k);
        if (oldFact == null) {
            this.map.put(k, fact);
            this.removed.remove(k);
        } else if (oldFact != fact) {
            oldFact.remove();
            this.map.put(k, fact);
            this.removed.remove(k);
        }
        this.notifyListeners(key, fact, IDependencyListener.Change.CHANGED);
        return fact;
    }

    @Override
    public synchronized IFact<IValue> setFact(Type key, IValue name, IValue value, Collection<IFact<IValue>> dependencies, IFactFactory factory) {
        Key k = new Key(key, name);
        IFact<IValue> fact = this.map.get(k);
        if (fact == null) {
            fact = factory.fact(IValue.class, k, this.formatKey(k), this, this.registry.getDepPolicy(key), this.registry.getRefPolicy(key));
        }
        boolean change = fact.setValue(value);
        if (dependencies != null) {
            fact.setDepends(Collections.unmodifiableCollection(dependencies));
        } else {
            fact.setDepends(Collections.unmodifiableCollection(this.deps));
        }
        this.map.put(k, fact);
        this.removed.remove(k);
        if (change) {
            this.notifyListeners(key, fact, IDependencyListener.Change.CHANGED);
        }
        return fact;
    }

    @Override
    public void abandon() {
        for (IFact<IValue> fact : this.map.values()) {
            this.notifyListeners(((Key)fact.getKey()).type, fact, IDependencyListener.Change.REMOVED);
            fact.remove();
        }
        this.map.clear();
        this.removed.clear();
        this.deps.clear();
    }

    @Override
    public void commit() {
        if (this.parent != null && this.commitEnabled) {
            if (this.parent.parent == null) {
                AbstractFact.pruneExpired();
            }
            for (Key k : this.removed) {
                this.parent.removeFact(k.type, k.name);
            }
            HashSet<IDependencyListener> toNotify = new HashSet<IDependencyListener>();
            HashSet<IFact<IValue>> trSet = new HashSet<IFact<IValue>>();
            for (Key k : this.map.keySet()) {
                IFact<IValue> fact = this.parent.map.get(k);
                IFact<IValue> trFact = this.map.get(k);
                trSet.add(trFact);
                if (fact != null) {
                    Collection<IDependencyListener> ls = fact.getListeners();
                    if (fact.updateFrom(trFact)) {
                        this.parent.notifyListeners(k.type, fact, IDependencyListener.Change.CHANGED);
                        toNotify.addAll(ls);
                    }
                    trSet.add(fact);
                    continue;
                }
                this.parent.map.put(k, this.map.get(k));
                this.parent.notifyListeners(k.type, trFact, IDependencyListener.Change.CHANGED);
            }
        }
    }

    @Override
    public void commit(Collection<IFact<IValue>> deps) {
        if (this.parent != null && this.commitEnabled) {
            for (Key k : this.removed) {
                this.parent.removeFact(k.type, k.name);
            }
            for (Key k : this.map.keySet()) {
                IFact<IValue> fact = this.parent.query(k);
                this.map.get(k).setDepends(deps);
                if (fact != null) {
                    if (!fact.updateFrom(this.map.get(k))) continue;
                    this.parent.notifyListeners(k.type, fact, IDependencyListener.Change.CHANGED);
                    continue;
                }
                this.parent.map.put(k, this.map.get(k));
                this.parent.notifyListeners(k.type, this.map.get(k), IDependencyListener.Change.CHANGED);
            }
        }
    }

    private void notifyListeners(Type k, IFact<IValue> fact, IDependencyListener.Change change) {
        Collection<IDependencyListener> ls = this.listeners.get(k);
        if (ls != null) {
            for (IDependencyListener l : ls) {
                l.changed(fact, change, null);
            }
        }
    }

    @Override
    public synchronized void registerListener(IDependencyListener listener, Type key) {
        Collection<IDependencyListener> ls = this.listeners.get(key);
        if (ls == null) {
            ls = new ArrayList<IDependencyListener>();
        }
        if (!ls.contains(listener)) {
            ls.add(listener);
        }
        this.listeners.put(key, ls);
    }

    @Override
    public synchronized void unregisterListener(IDependencyListener listener, Type key) {
        Collection<IDependencyListener> ls = this.listeners.get(key);
        if (ls != null) {
            ls.remove(listener);
            this.listeners.put(key, ls);
        }
    }

    private String formatKey(Object key) {
        if (key instanceof Key) {
            Key k = (Key)key;
            return this.formatKey(k.type, k.name);
        }
        return key.toString();
    }

    private String formatKey(Type key, IValue name) {
        if (this.format == null && this.parent != null) {
            return this.parent.formatKey(key, name);
        }
        String n = this.format != null ? this.format.format(name) : name.toString();
        return key.getName() + "(" + n + ")";
    }

    @Override
    public IFact<IValue> findFact(Type key, IValue name) {
        return this.query(new Key(key, name));
    }

    public static Key makeKey(Type key, IValue name) {
        return new Key(key, name);
    }

    public ITuple getGraph() {
        GraphBuilder g2 = new GraphBuilder();
        for (Key key : this.map.keySet()) {
            g2.addFact(this.map.get(key), key.type.getName(), this.map.get(key).getStatus());
        }
        for (IFact iFact : this.map.values()) {
            for (IFact<?> d : iFact.getDepends()) {
                if (d.getListeners().contains(iFact)) {
                    g2.arrow(iFact, d, "<->");
                    continue;
                }
                g2.arrow(iFact, d, "->");
                System.err.printf("Warning: fact %s depends on %s but does not listen on it.", iFact, d);
            }
        }
        return g2.getGraph();
    }

    @Override
    public synchronized void expire(Object key) {
        Key k = (Key)key;
        this.map.remove(k);
        this.removed.add(k);
    }

    @Override
    public int getMatchFingerprint() {
        return this.hashCode();
    }
}

