/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.uri.zip;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.rascalmpl.uri.zip.CompressedFSTree;
import org.rascalmpl.uri.zip.EntryEnumerator;
import org.rascalmpl.uri.zip.IndexedFSEntry;

public class ZipFileTree
extends CompressedFSTree {
    public ZipFileTree(File jar) {
        super(IndexedFSEntry.forFile(jar), ZipFileTree.openZip(jar));
    }

    private static EntryEnumerator openZip(File zipFile) {
        return () -> {
            final ZipFile zip = new ZipFile(zipFile);
            final Enumeration<? extends ZipEntry> actual = zip.entries();
            return new EntryEnumerator.CloseableIterator(){

                @Override
                public void close() throws IOException {
                    zip.close();
                }

                @Override
                public boolean hasNext() {
                    return actual.hasMoreElements();
                }

                @Override
                public ZipEntry next() {
                    return (ZipEntry)actual.nextElement();
                }
            };
        };
    }
}

