/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.dap.variable;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IDateTime;
import io.usethesource.vallang.IExternalValue;
import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IMap;
import io.usethesource.vallang.INode;
import io.usethesource.vallang.IRational;
import io.usethesource.vallang.IReal;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.ITuple;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.impl.reference.ValueFactory;
import io.usethesource.vallang.type.Type;
import io.usethesource.vallang.type.TypeFactory;
import io.usethesource.vallang.visitors.IValueVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.rascalmpl.dap.SuspendedState;
import org.rascalmpl.dap.variable.RascalVariable;
import org.rascalmpl.dap.variable.RascalVariableUtils;
import org.rascalmpl.dap.variable.VariableSubElementsCounter;
import org.rascalmpl.dap.variable.VariableSubElementsCounterVisitor;
import org.rascalmpl.ideservices.IDEServices;

public class VariableSubfieldsVisitor
implements IValueVisitor<List<RascalVariable>, RuntimeException> {
    private final IDEServices services;
    private final SuspendedState stateManager;
    private final Type visitedType;
    private final int startIndex;
    private final int count;

    public VariableSubfieldsVisitor(SuspendedState stateManager, Type visitedType, int startIndex, int count, IDEServices services) {
        this.services = services;
        this.stateManager = stateManager;
        this.visitedType = visitedType;
        this.startIndex = startIndex;
        this.count = count;
    }

    @Override
    public List<RascalVariable> visitString(IString o) throws RuntimeException {
        return Collections.emptyList();
    }

    @Override
    public List<RascalVariable> visitReal(IReal o) throws RuntimeException {
        return Collections.emptyList();
    }

    @Override
    public List<RascalVariable> visitRational(IRational o) throws RuntimeException {
        return Collections.emptyList();
    }

    @Override
    public List<RascalVariable> visitList(IList o) throws RuntimeException {
        ArrayList<RascalVariable> result = new ArrayList<RascalVariable>();
        int max = this.count == -1 ? o.length() : Math.min(o.length(), this.startIndex + this.count);
        for (int i = this.startIndex; i < max; ++i) {
            RascalVariable newVar = new RascalVariable(this.visitedType.isList() ? this.visitedType.getElementType() : o.getElementType(), Integer.toString(i), o.get(i), this.services);
            this.addVariableToResult(newVar, result);
        }
        return result;
    }

    @Override
    public List<RascalVariable> visitSet(ISet o) throws RuntimeException {
        ArrayList<RascalVariable> result = new ArrayList<RascalVariable>();
        AtomicInteger i = new AtomicInteger(this.startIndex);
        o.stream().skip(this.startIndex).limit(this.count == -1 ? (long)(o.size() - this.startIndex) : (long)this.count).forEach(value -> {
            RascalVariable newVar = new RascalVariable(this.visitedType.isSet() ? this.visitedType.getElementType() : o.getElementType(), Integer.toString(i.get()), (IValue)value, this.services);
            this.addVariableToResult(newVar, result);
            i.getAndIncrement();
        });
        return result;
    }

    @Override
    public List<RascalVariable> visitSourceLocation(ISourceLocation o) throws RuntimeException {
        return Collections.emptyList();
    }

    @Override
    public List<RascalVariable> visitTuple(ITuple o) throws RuntimeException {
        ArrayList<RascalVariable> result = new ArrayList<RascalVariable>();
        Type type = this.visitedType.isTuple() ? this.visitedType : o.getType();
        int max = this.count == -1 ? o.arity() : Math.min(o.arity(), this.startIndex + this.count);
        for (int i = this.startIndex; i < max; ++i) {
            RascalVariable newVar = new RascalVariable(type.getFieldType(i), type.hasFieldNames() ? type.getFieldName(i) : Integer.toString(i), o.get(i), this.services);
            this.addVariableToResult(newVar, result);
        }
        return result;
    }

    @Override
    public List<RascalVariable> visitNode(INode o) throws RuntimeException {
        ArrayList<RascalVariable> result = new ArrayList<RascalVariable>();
        int max = this.count == -1 ? o.arity() : Math.min(o.arity(), this.startIndex + this.count);
        for (int i = this.startIndex; i < max; ++i) {
            RascalVariable newVar = new RascalVariable(o.get(i).getType(), Integer.toString(i), o.get(i), this.services);
            this.addVariableToResult(newVar, result);
        }
        return result;
    }

    @Override
    public List<RascalVariable> visitConstructor(IConstructor o) throws RuntimeException {
        ArrayList<RascalVariable> result = new ArrayList<RascalVariable>();
        if (this.startIndex < o.arity()) {
            int max = this.count == -1 ? o.arity() : Math.min(o.arity(), this.startIndex + this.count);
            for (int i = this.startIndex; i < max; ++i) {
                RascalVariable newVar = new RascalVariable(o.getConstructorType().getFieldType(i), o.getConstructorType().hasFieldNames() ? o.getConstructorType().getFieldName(i) : Integer.toString(i), o.get(i), this.services);
                this.addVariableToResult(newVar, result);
            }
        }
        if (o.mayHaveKeywordParameters() && (this.count == -1 || this.startIndex + this.count - o.arity() > 0)) {
            Map<String, IValue> parameters = o.asWithKeywordParameters().getParameters();
            int remaining = this.count == -1 ? parameters.size() : this.startIndex + this.count - o.arity();
            int startParametersIndex = this.startIndex < o.arity() ? 0 : this.startIndex - o.arity();
            parameters.keySet().stream().skip(startParametersIndex).limit(remaining).forEach(name -> {
                IValue value = (IValue)parameters.get(name);
                RascalVariable newVar = new RascalVariable(value.getType(), "[" + name + "]", value, this.services);
                this.addVariableToResult(newVar, result);
            });
        }
        return result;
    }

    @Override
    public List<RascalVariable> visitInteger(IInteger o) throws RuntimeException {
        return Collections.emptyList();
    }

    @Override
    public List<RascalVariable> visitMap(IMap o) throws RuntimeException {
        ArrayList<RascalVariable> result = new ArrayList<RascalVariable>();
        o.stream().skip(this.startIndex).limit(this.count == -1 ? (long)(o.size() - this.startIndex) : (long)this.count).forEach(pair -> {
            ITuple tuple = (ITuple)pair;
            RascalVariable newVar = new RascalVariable(this.visitedType.isMap() ? this.visitedType.getValueType() : o.getValueType(), RascalVariableUtils.getDisplayString(tuple.get(0), this.services), tuple.get(1), this.services);
            this.addVariableToResult(newVar, result);
        });
        return result;
    }

    @Override
    public List<RascalVariable> visitBoolean(IBool boolValue) throws RuntimeException {
        return Collections.emptyList();
    }

    @Override
    public List<RascalVariable> visitExternal(IExternalValue externalValue) throws RuntimeException {
        return Collections.emptyList();
    }

    @Override
    public List<RascalVariable> visitDateTime(IDateTime o) throws RuntimeException {
        ArrayList<RascalVariable> result = new ArrayList<RascalVariable>();
        if (o.isDate() || o.isDateTime()) {
            result.add(new RascalVariable(TypeFactory.getInstance().integerType(), "year", ValueFactory.getInstance().integer(o.getYear()), this.services));
            result.add(new RascalVariable(TypeFactory.getInstance().integerType(), "month", ValueFactory.getInstance().integer(o.getMonthOfYear()), this.services));
            result.add(new RascalVariable(TypeFactory.getInstance().integerType(), "day", ValueFactory.getInstance().integer(o.getDayOfMonth()), this.services));
        }
        if (o.isTime() || o.isDateTime()) {
            result.add(new RascalVariable(TypeFactory.getInstance().integerType(), "hour", ValueFactory.getInstance().integer(o.getHourOfDay()), this.services));
            result.add(new RascalVariable(TypeFactory.getInstance().integerType(), "minute", ValueFactory.getInstance().integer(o.getMinuteOfHour()), this.services));
            result.add(new RascalVariable(TypeFactory.getInstance().integerType(), "second", ValueFactory.getInstance().integer(o.getSecondOfMinute()), this.services));
            result.add(new RascalVariable(TypeFactory.getInstance().integerType(), "millisecond", ValueFactory.getInstance().integer(o.getMillisecondsOfSecond()), this.services));
            result.add(new RascalVariable(TypeFactory.getInstance().integerType(), "timezoneOffsetHours", ValueFactory.getInstance().integer(o.getTimezoneOffsetHours()), this.services));
            result.add(new RascalVariable(TypeFactory.getInstance().integerType(), "timezoneOffsetMinutes", ValueFactory.getInstance().integer(o.getTimezoneOffsetMinutes()), this.services));
        }
        return result;
    }

    private void addVariableToResult(RascalVariable newVar, List<RascalVariable> resultList) {
        if (newVar.hasSubFields()) {
            this.stateManager.addVariable(newVar);
            VariableSubElementsCounter counter = newVar.getValue().accept(new VariableSubElementsCounterVisitor());
            newVar.setIndexedVariables(counter.getIndexedVariables());
            newVar.setNamedVariables(counter.getNamedVariables());
        }
        resultList.add(newVar);
    }
}

