/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.exceptions;

import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.io.StandardTextWriter;
import java.io.IOException;
import org.rascalmpl.exceptions.StackTrace;
import org.rascalmpl.interpreter.control_exceptions.ControlException;
import org.rascalmpl.interpreter.utils.LimitedResultWriter;
import org.rascalmpl.uri.URIUtil;

public final class Throw
extends ControlException {
    private static final long serialVersionUID = -7290501865940548332L;
    private final IValue exception;
    private volatile ISourceLocation loc;
    private volatile StackTrace trace;

    public Throw(IValue value, ISourceLocation loc, StackTrace trace) {
        super(Throw.toString(value, 4096));
        this.exception = value;
        this.loc = loc;
        if (trace == null) {
            trace = StackTrace.EMPTY_STACK_TRACE;
        }
        this.trace = trace;
    }

    public Throw(IValue value) {
        super(Throw.toString(value, 4096));
        this.exception = value;
        this.loc = URIUtil.rootLocation("TODO");
        this.trace = StackTrace.EMPTY_STACK_TRACE;
    }

    private static String toString(IValue value, int length) {
        if (value == null) {
            return "no exception message";
        }
        StandardTextWriter stw = new StandardTextWriter(true);
        LimitedResultWriter lros = new LimitedResultWriter(length);
        try {
            stw.write(value, lros);
        }
        catch (RuntimeException runtimeException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return lros.toString();
    }

    public StackTrace getTrace() {
        return this.trace;
    }

    public void setTrace(StackTrace trace) {
        if (trace == null) {
            trace = StackTrace.EMPTY_STACK_TRACE;
        }
        this.trace = trace;
    }

    public IValue getException() {
        return this.exception;
    }

    public ISourceLocation getLocation() {
        return this.loc;
    }

    public void setLocation(ISourceLocation loc) {
        this.loc = loc;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this.reallyFillInStackTrace();
    }

    @Override
    public String getMessage() {
        if (this.loc != null) {
            return (this.loc.getScheme().equals("file") ? this.loc.getAuthority() + this.loc.getPath() : this.loc.top()) + (this.loc.hasLineColumn() ? ":" + this.loc.getBeginLine() + "," + this.loc.getBeginColumn() + ": " + super.getMessage() : ": " + super.getMessage());
        }
        return super.getMessage();
    }
}

