/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.interpreter.matching;

import io.usethesource.vallang.IBool;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.AbstractMatchingResult;
import org.rascalmpl.interpreter.matching.IVarPattern;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.result.ResultFactory;
import org.rascalmpl.interpreter.staticErrors.UnexpectedType;

public class LiteralPattern
extends AbstractMatchingResult {
    private IValue literal;
    private boolean isPattern = false;

    public LiteralPattern(IEvaluatorContext ctx, AbstractAST x, IValue literal) {
        super(ctx, x);
        this.literal = literal;
    }

    @Override
    public List<IVarPattern> getVariables() {
        return Collections.emptyList();
    }

    @Override
    public Type getType(Environment env, HashMap<String, IVarPattern> patternVars) {
        return this.literal.getType();
    }

    @Override
    public void initMatch(Result<IValue> subject) {
        super.initMatch(subject);
        this.isPattern = true;
    }

    @Override
    public boolean next() {
        this.checkInitialized();
        if (!this.hasNext) {
            return false;
        }
        this.hasNext = false;
        if (this.isPattern && this.subject.getValue().getType().comparable(this.literal.getType())) {
            return this.subject.equals(ResultFactory.makeResult(this.literal.getType(), this.literal, this.ctx)).isTrue();
        }
        if (!this.isPattern) {
            if (this.literal.getType().isBool()) {
                return ((IBool)this.literal).getValue();
            }
            throw new UnexpectedType(this.tf.boolType(), this.literal.getType(), this.ctx.getCurrentAST());
        }
        return false;
    }

    public IValue toIValue(Environment env) {
        return this.literal;
    }

    public String toString() {
        return "pattern: " + this.literal;
    }
}

