/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.library.analysis.statistics;

import io.usethesource.vallang.IList;
import io.usethesource.vallang.INumber;
import io.usethesource.vallang.IString;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.IValueFactory;
import org.apache.commons.math.stat.Frequency;
import org.rascalmpl.exceptions.RuntimeExceptionFactory;
import org.rascalmpl.library.analysis.statistics.ComparableValue;

public class Frequencies {
    private final IValueFactory values;

    public Frequencies(IValueFactory values) {
        this.values = values;
    }

    Frequency make(IList dataValues) {
        Frequency freq = new Frequency();
        for (IValue v : dataValues) {
            if (v instanceof INumber) {
                freq.addValue(new ComparableValue((INumber)v));
                continue;
            }
            if (v instanceof IString) {
                freq.addValue(new ComparableValue((IString)v));
                continue;
            }
            throw RuntimeExceptionFactory.illegalArgument(v, null, null);
        }
        return freq;
    }

    public IValue cumFreq(IList dataValues, INumber n) {
        return this.values.integer(this.make(dataValues).getCumFreq(new ComparableValue(n)));
    }

    public IValue cumFreq(IList dataValues, IString s2) {
        return this.values.integer(this.make(dataValues).getCumFreq(new ComparableValue(s2)));
    }

    public IValue cumPct(IList dataValues, INumber n) {
        return this.values.real(this.make(dataValues).getCumPct(new ComparableValue(n)));
    }

    public IValue cumPct(IList dataValues, IString s2) {
        return this.values.real(this.make(dataValues).getCumPct(new ComparableValue(s2)));
    }

    public IValue pct(IList dataValues, INumber n) {
        return this.values.real(this.make(dataValues).getPct(new ComparableValue(n)));
    }

    public IValue pct(IList dataValues, IString s2) {
        return this.values.real(this.make(dataValues).getPct(new ComparableValue(s2)));
    }
}

