/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.semantics.dynamic;

import io.usethesource.vallang.IConstructor;
import io.usethesource.vallang.IList;
import io.usethesource.vallang.IListWriter;
import io.usethesource.vallang.ISet;
import io.usethesource.vallang.ISetWriter;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.type.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.rascalmpl.ast.AbstractAST;
import org.rascalmpl.ast.Expression;
import org.rascalmpl.interpreter.IEvaluator;
import org.rascalmpl.interpreter.IEvaluatorContext;
import org.rascalmpl.interpreter.env.Environment;
import org.rascalmpl.interpreter.matching.BasicBooleanResult;
import org.rascalmpl.interpreter.matching.ConcreteApplicationPattern;
import org.rascalmpl.interpreter.matching.ConcreteListPattern;
import org.rascalmpl.interpreter.matching.ConcreteListVariablePattern;
import org.rascalmpl.interpreter.matching.ConcreteOptPattern;
import org.rascalmpl.interpreter.matching.IBooleanResult;
import org.rascalmpl.interpreter.matching.IMatchingResult;
import org.rascalmpl.interpreter.matching.LiteralPattern;
import org.rascalmpl.interpreter.matching.NodePattern;
import org.rascalmpl.interpreter.matching.SetPattern;
import org.rascalmpl.interpreter.matching.TypedVariablePattern;
import org.rascalmpl.interpreter.result.IRascalResult;
import org.rascalmpl.interpreter.result.Result;
import org.rascalmpl.interpreter.staticErrors.UndeclaredVariable;
import org.rascalmpl.interpreter.staticErrors.UninitializedVariable;
import org.rascalmpl.types.NonTerminalType;
import org.rascalmpl.types.RascalTypeFactory;
import org.rascalmpl.values.RascalValueFactory;
import org.rascalmpl.values.parsetrees.ITree;
import org.rascalmpl.values.parsetrees.ProductionAdapter;
import org.rascalmpl.values.parsetrees.SymbolAdapter;
import org.rascalmpl.values.parsetrees.TreeAdapter;

public abstract class Tree
extends Expression {
    public Tree(ISourceLocation src, IConstructor node) {
        super(src, node);
    }

    public boolean isLayout() {
        return false;
    }

    public static class Cycle
    extends Tree {
        private final int length;
        private final IConstructor node;

        public Cycle(ISourceLocation src, IConstructor node, int length) {
            super(src, node);
            this.length = length;
            this.node = node;
        }

        @Override
        public String toString() {
            return super.toString() + "\nCycle:" + this.node + " Length:" + this.length;
        }

        @Override
        public Object clone() {
            return new Cycle(this.src, this.node, this.length);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Cycle)) {
                return false;
            }
            Cycle other = (Cycle)o;
            return this.node.equals(other.node);
        }

        @Override
        public int hashCode() {
            return this.node.hashCode();
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> eval) {
            return Cycle.makeResult(RascalValueFactory.Tree, VF.cycle(this.node, this.length), eval);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            return new LiteralPattern(eval, this, VF.cycle(this.node, this.length));
        }

        @Override
        public Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return RascalValueFactory.Tree;
        }
    }

    public static class Char
    extends Tree {
        private final IConstructor node;

        public Char(ISourceLocation src, IConstructor node) {
            super(src, node);
            this.node = node;
        }

        @Override
        public String toString() {
            return super.toString() + "\nChar:" + this.node;
        }

        @Override
        public Object clone() {
            return new Char(this.src, this.node);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Char)) {
                return false;
            }
            Char other = (Char)o;
            return this.node.equals(other.node);
        }

        @Override
        public int hashCode() {
            return 17 + 37 * this.node.hashCode();
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> eval) {
            return Char.makeResult(RascalValueFactory.Tree, this.node, eval);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            return new LiteralPattern(eval, this, this.node);
        }

        @Override
        public Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return RascalValueFactory.Tree;
        }
    }

    public static class Amb
    extends Tree {
        private final Type type;
        private final java.util.List<Expression> alts;

        public Amb(ISourceLocation src, IConstructor node, java.util.List<Expression> alternatives) {
            super(src, node);
            this.type = RascalTypeFactory.getInstance().nonTerminalType(node);
            this.alts = alternatives;
        }

        @Override
        public String toString() {
            return super.toString() + "\nAmb:" + this.alts.size() + " Type:" + this.type;
        }

        @Override
        public Object clone() {
            return new Amb(this.src, null, this.clone(this.alts));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Amb)) {
                return false;
            }
            Amb other = (Amb)o;
            return this.alts.equals(other.alts);
        }

        @Override
        public int hashCode() {
            return this.alts.hashCode();
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> eval) {
            ISetWriter w = eval.getValueFactory().setWriter();
            for (Expression a : this.alts) {
                w.insert(a.interpret(eval).getValue());
            }
            return Amb.makeResult(this.type, VF.amb((ISet)w.done()), eval);
        }

        @Override
        public Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return this.type;
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new BasicBooleanResult(eval, this);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            ArrayList<IMatchingResult> kids = new ArrayList<IMatchingResult>(this.alts.size());
            for (Expression arg : this.alts) {
                kids.add(arg.buildMatcher(eval, bindTypeParameters));
            }
            SetPattern setMatcher = new SetPattern(eval, this, kids, bindTypeParameters);
            ArrayList<IMatchingResult> wrap = new ArrayList<IMatchingResult>(1);
            wrap.add(setMatcher);
            IRascalResult ambCons = eval.getCurrentEnvt().getFrameVariable("amb");
            return new NodePattern(eval, this, new LiteralPattern(eval, this, (IValue)((Result)ambCons).getValue()), null, RascalValueFactory.Tree_Amb, wrap, Collections.emptyMap());
        }
    }

    public static class List
    extends Appl {
        private final int delta;

        public List(IConstructor prod, ISourceLocation src, java.util.List<Expression> args) {
            super(prod, src, args);
            this.delta = this.getDelta(this.production);
        }

        @Override
        public Object clone() {
            return new List(this.production, this.src, this.clone(this.args));
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            ArrayList<IMatchingResult> kids = new ArrayList<IMatchingResult>(this.args.size());
            for (Expression arg : this.args) {
                kids.add(arg.buildMatcher(eval, bindTypeParameters));
            }
            return new ConcreteListPattern(eval, this, kids, bindTypeParameters);
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> eval) {
            IListWriter w = eval.getValueFactory().listWriter();
            for (Expression arg : this.args) {
                w.append(arg.interpret(eval).getValue());
            }
            ISourceLocation location = this.getLocation();
            if (location != null) {
                HashMap<String, IValue> annos = new HashMap<String, IValue>();
                annos.put("loc", location);
                return List.makeResult(this.type, VF.appl(annos, this.production, this.flatten((IList)w.done())), eval);
            }
            return List.makeResult(this.type, VF.appl(this.production, this.flatten((IList)w.done())), eval);
        }

        private void appendPreviousSeparators(IList args, IListWriter result, int delta, int i, boolean previousWasEmpty) {
            if (!previousWasEmpty) {
                for (int j = i - delta; j > 0 && j < i; ++j) {
                    result.append(args.get(j));
                }
            }
        }

        private IList flatten(IList args) {
            IListWriter result = VF.listWriter();
            boolean previousWasEmpty = false;
            for (int i = 0; i < args.length(); i += this.delta + 1) {
                ITree tree = (ITree)args.get(i);
                if (TreeAdapter.isList(tree) && ProductionAdapter.shouldFlatten(this.production, TreeAdapter.getProduction(tree))) {
                    IList nestedArgs = TreeAdapter.getArgs(tree);
                    if (nestedArgs.length() > 0) {
                        this.appendPreviousSeparators(args, result, this.delta, i, previousWasEmpty);
                        result.appendAll(nestedArgs);
                        previousWasEmpty = false;
                        continue;
                    }
                    previousWasEmpty = true;
                    continue;
                }
                this.appendPreviousSeparators(args, result, this.delta, i, previousWasEmpty);
                result.append(tree);
                previousWasEmpty = false;
            }
            return (IList)result.done();
        }

        private int getDelta(IConstructor prod) {
            IConstructor rhs = ProductionAdapter.getType(prod);
            if (SymbolAdapter.isIterPlusSeps(rhs) || SymbolAdapter.isIterStarSeps(rhs)) {
                return SymbolAdapter.getSeparators(rhs).length();
            }
            return 0;
        }
    }

    public static class Optional
    extends Appl {
        public Optional(IConstructor production, ISourceLocation src, java.util.List<Expression> args) {
            super(production, src, args);
        }

        @Override
        public Object clone() {
            return new Optional(this.production, this.src, this.clone(this.args));
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            ArrayList<IMatchingResult> kids = new ArrayList<IMatchingResult>(this.args.size());
            if (this.args.size() == 1) {
                kids.add(((Expression)this.args.get(0)).buildMatcher(eval, bindTypeParameters));
            }
            return new ConcreteOptPattern(eval, this, kids);
        }
    }

    public static class Appl
    extends Tree {
        protected final IConstructor production;
        protected final java.util.List<Expression> args;
        protected final Type type;

        public Appl(IConstructor prod, ISourceLocation src, java.util.List<Expression> args) {
            super(src, null);
            this.production = prod;
            this.type = RascalTypeFactory.getInstance().nonTerminalType(this.production);
            this.args = args;
        }

        @Override
        public String toString() {
            return super.toString() + "\nAppl:" + this.production + " Type:" + this.type + " Arity: " + this.args.size();
        }

        @Override
        public Object clone() {
            return new Appl(this.production, this.src, this.clone(this.args));
        }

        @Override
        public boolean isLayout() {
            return ProductionAdapter.isLayout(this.production);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Appl)) {
                return false;
            }
            Appl other = (Appl)o;
            return this.production.equals(other.production) && this.args.equals(other.args);
        }

        @Override
        public int hashCode() {
            return 101 + 23 * this.production.hashCode() + 131 * this.args.hashCode();
        }

        public IConstructor getProduction() {
            return this.production;
        }

        @Override
        public Type getConcreteSyntaxType() {
            return this.type;
        }

        @Override
        public Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return this.type;
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> eval) {
            IListWriter w = eval.getValueFactory().listWriter();
            for (Expression arg : this.args) {
                w.append(arg.interpret(eval).getValue());
            }
            ISourceLocation location = this.getLocation();
            if (location != null) {
                HashMap<String, IValue> kwParams = new HashMap<String, IValue>();
                kwParams.put("src", location);
                return Appl.makeResult(this.type, VF.appl(kwParams, this.production, (IList)w.done()), eval);
            }
            return Appl.makeResult(this.type, VF.appl(this.production, (IList)w.done()), eval);
        }

        @Override
        public IBooleanResult buildBacktracker(IEvaluatorContext eval) {
            return new BasicBooleanResult(eval, this);
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext eval, boolean bindTypeParameters) {
            ArrayList<IMatchingResult> kids = new ArrayList<IMatchingResult>(this.args.size());
            for (Expression kid : this.args) {
                if (((Tree)kid).isLayout()) continue;
                kids.add(kid.buildMatcher(eval, bindTypeParameters));
            }
            return new ConcreteApplicationPattern(eval, this, kids);
        }
    }

    public static class MetaVariable
    extends Tree {
        private final String name;
        private final Type type;

        public MetaVariable(ISourceLocation src, IConstructor node, IConstructor symbol, String name) {
            super(src, node);
            this.name = name;
            this.type = RTF.nonTerminalType(symbol);
        }

        @Override
        public String toString() {
            return super.toString() + "\nVar:" + this.name + " Type:" + this.type;
        }

        @Override
        public Type typeOf(Environment env, IEvaluator<Result<IValue>> eval, boolean instantiateTypeParameters) {
            return this.type;
        }

        @Override
        public Object clone() {
            return new MetaVariable(this.src, null, ((NonTerminalType)this.type).getSymbol(), this.name);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof MetaVariable)) {
                return false;
            }
            MetaVariable other = (MetaVariable)o;
            return this.name.equals(other.name) && this.type.equals(other.type);
        }

        @Override
        public int hashCode() {
            return 13333331 + 37 * this.name.hashCode() + 61 * this.type.hashCode();
        }

        @Override
        public Result<IValue> interpret(IEvaluator<Result<IValue>> eval) {
            IRascalResult variable = eval.getCurrentEnvt().getFrameVariable(this.name);
            if (variable == null) {
                throw new UndeclaredVariable(this.name, this);
            }
            if (((Result)variable).getValue() == null) {
                throw new UninitializedVariable(this.name, this);
            }
            return variable;
        }

        @Override
        public IMatchingResult buildMatcher(IEvaluatorContext ctx, boolean bindTypeParameters) {
            IConstructor symbol = ((NonTerminalType)this.type).getSymbol();
            if (SymbolAdapter.isStarList(symbol) || SymbolAdapter.isPlusList(symbol)) {
                return new ConcreteListVariablePattern(ctx, (AbstractAST)this, this.type, this.name);
            }
            return new TypedVariablePattern(ctx, (Expression)this, this.type, this.name, bindTypeParameters);
        }
    }
}

