/*
 * Decompiled with CFR 0.152.
 */
package org.rascalmpl.shell;

import io.usethesource.vallang.IInteger;
import io.usethesource.vallang.ISourceLocation;
import io.usethesource.vallang.IValue;
import io.usethesource.vallang.io.StandardTextWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.jline.terminal.Terminal;
import org.rascalmpl.debug.IRascalMonitor;
import org.rascalmpl.exceptions.Throw;
import org.rascalmpl.interpreter.Evaluator;
import org.rascalmpl.library.util.PathConfig;
import org.rascalmpl.shell.ShellEvaluatorFactory;
import org.rascalmpl.uri.URIResolverRegistry;
import org.rascalmpl.uri.URIUtil;
import org.rascalmpl.uri.jar.JarURIResolver;

public abstract class AbstractCommandlineTool {
    public static int main(String mainModule, String[] sourceFolders, String[] args, Terminal term, IRascalMonitor monitor, PrintWriter err, PrintWriter out) {
        try {
            Evaluator eval = ShellEvaluatorFactory.getBasicEvaluator(term.reader(), out, err, monitor);
            ISourceLocation rascalJar = JarURIResolver.jarify(PathConfig.resolveCurrentRascalRuntimeJar());
            for (String folder : sourceFolders) {
                ISourceLocation src = URIUtil.getChildLocation(rascalJar, folder);
                if (!URIResolverRegistry.getInstance().exists(src)) {
                    throw new FileNotFoundException(src.toString());
                }
                eval.addRascalSearchPath(src);
            }
            eval.doImport(monitor, mainModule);
            IValue result = eval.main(monitor, mainModule, "main", args);
            if (result == null) {
                return 0;
            }
            if (result.getType().isInteger()) {
                return ((IInteger)result).intValue();
            }
            return 0;
        }
        catch (Throw e) {
            try {
                err.println(e.getException());
                e.getTrace().prettyPrintedString(err, new StandardTextWriter());
            }
            catch (IOException ioe) {
                err.println(ioe.getMessage());
            }
            return 1;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 1;
        }
    }

    public static int main(String mainModule, String[] sourceFolders, Map<String, IValue> args, Terminal term, IRascalMonitor monitor, PrintWriter err, PrintWriter out) {
        try {
            Evaluator eval = ShellEvaluatorFactory.getBasicEvaluator(term.reader(), out, err, monitor);
            ISourceLocation rascalJar = JarURIResolver.jarify(PathConfig.resolveCurrentRascalRuntimeJar());
            for (String folder : sourceFolders) {
                ISourceLocation src = URIUtil.getChildLocation(rascalJar, folder);
                if (!URIResolverRegistry.getInstance().exists(src)) {
                    throw new FileNotFoundException(src.toString());
                }
                eval.addRascalSearchPath(src);
            }
            eval.doImport(monitor, mainModule);
            IValue result = eval.main(monitor, mainModule, "main", args);
            if (result == null) {
                return 0;
            }
            if (result.getType().isInteger()) {
                return ((IInteger)result).intValue();
            }
            return 0;
        }
        catch (Throw e) {
            try {
                err.println(e.getException());
                e.getTrace().prettyPrintedString(err, new StandardTextWriter());
            }
            catch (IOException ioe) {
                err.println(ioe.getMessage());
            }
            return 1;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return 1;
        }
    }
}

