---
title: "module analysis::diff::edits::ExecuteTextEdits"
id: ExecuteTextEdits
slug: /Library/analysis/diff/edits/ExecuteTextEdits
---

<div class="theme-doc-version-badge badge badge--secondary">rascal-Not specified</div>

#### Usage

```rascal
import analysis::diff::edits::ExecuteTextEdits;
```

#### Dependencies
```rascal
extend analysis::diff::edits::TextEdits;
import DateTime;
import IO;
import List;
import String;
```


## function executeDocumentEdits {#analysis-diff-edits-ExecuteTextEdits-executeDocumentEdits}

Execute file changes, including in-file edits if present.

```rascal
void executeDocumentEdits(list[FileSystemChange] edits)
```

## function executeFileSystemChanges {#analysis-diff-edits-ExecuteTextEdits-executeFileSystemChanges}

Execute file changes, including in-file edits if present.

```rascal
void executeFileSystemChanges(list[FileSystemChange] edits)
```

## function executeFileSystemChange {#analysis-diff-edits-ExecuteTextEdits-executeFileSystemChange}

```rascal
void executeFileSystemChange(removed(loc f))

void executeFileSystemChange(created(loc f))

void executeFileSystemChange(renamed(loc from, loc to))

void executeFileSystemChange(changed(loc file))
```

## function executeFileSystemChange {#analysis-diff-edits-ExecuteTextEdits-executeFileSystemChange}

Edit a file according to the given ((TextEdit)) instructions

```rascal
void executeFileSystemChange(changed(loc file, list[TextEdit] edits))
```

## function executeTextEdits {#analysis-diff-edits-ExecuteTextEdits-executeTextEdits}

```rascal
str executeTextEdits(str content, list[TextEdit] edits)
```

