/*
 * Decompiled with CFR 0.152.
 */
package engineering.swat.watch.impl.mac;

import engineering.swat.watch.impl.mac.MacWatchKey;
import engineering.swat.watch.impl.mac.MacWatchService;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;

class MacWatchable
implements Watchable {
    private final Path path;
    private final Map<MacWatchService, MacWatchKey> registrations;

    MacWatchable(Path path) {
        this.path = path;
        this.registrations = new ConcurrentHashMap<MacWatchService, MacWatchKey>();
    }

    Path getPath() {
        return this.path;
    }

    void unregister(MacWatchService watcher) {
        this.registrations.remove(watcher);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        if (!(watcher instanceof MacWatchService)) {
            throw new IllegalArgumentException("A `MacWatchable` must be registered with a `MacWatchService`");
        }
        if (Stream.of(events).noneMatch(StandardWatchEventKinds.OVERFLOW::equals)) {
            events = (WatchEvent.Kind[])Stream.concat(Stream.of(events), Stream.of(StandardWatchEventKinds.OVERFLOW)).toArray(WatchEvent.Kind[]::new);
        }
        Function<MacWatchService, MacWatchKey> newMacWatchKey = service -> {
            try {
                return new MacWatchKey(this, (MacWatchService)service);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        try {
            return this.registrations.computeIfAbsent((MacWatchService)watcher, newMacWatchKey).initialize(events, modifiers);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.register(watcher, events, new WatchEvent.Modifier[0]);
    }
}

